/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DexGlobalAnalysisDialog
extends JebDialog {
    boolean success;
    Text wFilterIncl;
    String filterIncl;
    Text wFilterExcl;
    String filterExcl;
    Text wMethodTimeout;
    Integer methodTimeout;
    Text wTotalTimeout;
    Integer totalTimeout;

    public DexGlobalAnalysisDialog(Shell parent) {
        super(parent, "Global Analysis", true, true);
        this.scrolledContainer = true;
    }

    public void setInclusions(String initialFilter) {
        this.filterIncl = initialFilter;
    }

    public String getInclusions() {
        return this.filterIncl;
    }

    public void setExclusions(String initialFilter) {
        this.filterExcl = initialFilter;
    }

    public String getExclusions() {
        return this.filterExcl;
    }

    public void setMethodTimeoutSec(int itemTimeout) {
        if (itemTimeout >= 0) {
            this.methodTimeout = itemTimeout;
        }
    }

    public int getMethodTimeoutSec() {
        if (this.methodTimeout == null) {
            return -1;
        }
        return this.methodTimeout;
    }

    public void setTotalTimeoutSec(int totalTimeout) {
        if (totalTimeout >= 0) {
            this.totalTimeout = totalTimeout;
        }
    }

    public int getTotalTimeoutSec() {
        if (this.totalTimeout == null) {
            return -1;
        }
        return this.totalTimeout;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.success;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        Object msg = "";
        if (Licensing.isDemoBuild()) {
            msg = (String)msg + "[!] DEMO MODE: filtering is off; will process about ~20% of the code base\n\n";
            this.filterIncl = "";
            this.filterExcl = "";
        }
        msg = (String)msg + "Perform a decompilation of all or a subset of methods with specific settings in order to discover encrypted strings and reflected code. Cross-references and comments will be generated. Your existing decompilations will not be impacted. All filters must be in internal form. Examples: La/b/c; Lcom/foo/ Lx/y;->f";
        Label label = new Label(parent, 16448);
        label.setText((String)msg);
        label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 60));
        Group c0 = UIUtil.createGroupGrid(parent, 0, "Settings", 1, 2);
        new Label((Composite)c0, 0).setText("Method timeout (seconds):");
        this.wMethodTimeout = UIUtil.createTextboxInGrid((Composite)c0, 2048, 5, 1);
        this.wMethodTimeout.setText(this.methodTimeout == null ? "" : this.methodTimeout.toString());
        this.wMethodTimeout.selectAll();
        new Label((Composite)c0, 0).setText("Global timeout (seconds):");
        this.wTotalTimeout = UIUtil.createTextboxInGrid((Composite)c0, 2048, 5, 1);
        this.wTotalTimeout.setText(this.totalTimeout == null ? "" : this.totalTimeout.toString());
        this.wTotalTimeout.selectAll();
        Composite c1 = UIUtil.createCompositeGrid((Composite)c0, 0, 2, 1, 0);
        new Label(c1, 0).setText("Inclusions (code filters, one prefix per line): ");
        this.wFilterIncl = UIUtil.createTextboxInGrid(c1, 2818, 60, 3, true, true);
        this.wFilterIncl.setText(this.filterIncl == null ? "" : this.filterIncl);
        this.wFilterIncl.setFocus();
        this.wFilterIncl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    return;
                }
                e.doit = true;
            }
        });
        new Label(c1, 0).setText("Exclusions (one prefix per line):");
        this.wFilterExcl = UIUtil.createTextboxInGrid(c1, 2818, 60, 5, true, true);
        this.wFilterExcl.setText(this.filterExcl == null ? "" : this.filterExcl);
        this.wFilterExcl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    return;
                }
                e.doit = true;
            }
        });
        this.createButtons(parent, 288, 32);
        this.getButtonByStyle(32).setText("     Start     ");
    }

    @Override
    protected void onConfirm() {
        this.success = true;
        this.methodTimeout = Conversion.stringToInt(this.wMethodTimeout.getText());
        this.totalTimeout = Conversion.stringToInt(this.wTotalTimeout.getText());
        this.filterIncl = this.wFilterIncl.getText();
        this.filterExcl = this.wFilterExcl.getText();
        super.onConfirm();
    }

    @Override
    protected void onCancel() {
        this.success = false;
        super.onCancel();
    }
}

