/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DexGenericUnpackingDialog
extends JebDialog {
    boolean success;
    Text wTotalTimeout;
    Integer totalTimeout;
    Button wUseUnpackedDex;
    Boolean useUnpackedDex;
    Button wUseUnpackedLibs;
    Boolean useUnpackedLibs;
    Button wMonitorEvents;
    Boolean monitorEvents;

    public DexGenericUnpackingDialog(Shell parent) {
        super(parent, "Generic Unpacking", true, true);
        this.scrolledContainer = true;
    }

    public void setTotalTimeoutSec(int timeout) {
        if (timeout >= 0) {
            this.totalTimeout = timeout;
        }
    }

    public int getTotalTimeoutSec() {
        if (this.totalTimeout == null) {
            return -1;
        }
        return this.totalTimeout;
    }

    public void setUseUnpackedDex(boolean enabled) {
        this.useUnpackedDex = enabled;
    }

    public boolean getUseUnpackedDex() {
        if (this.useUnpackedDex == null) {
            return false;
        }
        return this.useUnpackedDex;
    }

    public void setUseUnpackedLibs(boolean enabled) {
        this.useUnpackedLibs = enabled;
    }

    public boolean getUseUnpackedLibs() {
        if (this.useUnpackedLibs == null) {
            return false;
        }
        return this.useUnpackedLibs;
    }

    public void setMonitorEvents(boolean enabled) {
        this.monitorEvents = enabled;
    }

    public boolean getMonitorEvents() {
        if (this.monitorEvents == null) {
            return false;
        }
        return this.monitorEvents;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.success;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        Object msg = "";
        msg = (String)msg + "Attempt generic unpacking of the APK. The unpacker will emulate parts of the app and attempt to recover dynamically-generated dex files.";
        Label label = new Label(parent, 16448);
        label.setText((String)msg);
        label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 40));
        Group c0 = UIUtil.createGroupGrid(parent, 0, "Settings", 1, 2);
        new Label((Composite)c0, 0).setText("Global timeout (seconds):");
        this.wTotalTimeout = UIUtil.createTextboxInGrid((Composite)c0, 2048, 5, 1);
        this.wTotalTimeout.setText(this.totalTimeout == null ? "" : this.totalTimeout.toString());
        this.wTotalTimeout.selectAll();
        this.wUseUnpackedDex = UIUtil.createCheckbox((Composite)c0, "Auto-integrate unpacked Dex code to main Dex unit", null);
        this.wUseUnpackedDex.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        this.wUseUnpackedDex.setSelection(this.getUseUnpackedDex());
        this.wUseUnpackedLibs = UIUtil.createCheckbox((Composite)c0, "Allow use of unpacked native libraries", null);
        this.wUseUnpackedLibs.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        this.wUseUnpackedLibs.setSelection(this.getUseUnpackedLibs());
        this.wMonitorEvents = UIUtil.createCheckbox((Composite)c0, "Monitor events and generate unpacking report", null);
        this.wMonitorEvents.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        this.wMonitorEvents.setSelection(this.getMonitorEvents());
        this.createButtons(parent, 288, 32);
        this.getButtonByStyle(32).setText("     Start     ");
    }

    @Override
    protected void onConfirm() {
        this.success = true;
        this.totalTimeout = Conversion.stringToInt(this.wTotalTimeout.getText());
        this.useUnpackedDex = this.wUseUnpackedDex.getSelection();
        this.useUnpackedLibs = this.wUseUnpackedLibs.getSelection();
        this.monitorEvents = this.wMonitorEvents.getSelection();
        super.onConfirm();
    }

    @Override
    protected void onCancel() {
        this.success = false;
        super.onCancel();
    }
}

