/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.DexConstantCreateDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DexConstantSelectorDialog
extends DataFrameDialog {
    IDexUnit dex;
    Object value;
    char valueTypeChar;
    List<Entry> entries = new ArrayList<Entry>();
    boolean resetRequested;
    private int selectedIndex = -1;

    public DexConstantSelectorDialog(Shell parent, IDexUnit dex, Object value) {
        super(parent, "Select a constant", true, null);
        this.dex = dex;
        this.value = value;
        this.valueTypeChar = DexConstantSelectorDialog.getValueJavaTypeChar(value);
        if (this.valueTypeChar == '\u0000') {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Integer open() {
        this.reload();
        String msg = Strings.ff("Select a static final field having the value: %s (type: %c)", this.value, Character.valueOf(this.valueTypeChar));
        this.setMessage(msg);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public boolean isResetRequested() {
        return this.resetRequested;
    }

    public Entry getSelectedEntry() {
        if (!this.shell.isDisposed()) {
            throw new IllegalStateException("Shell be called only after the dialog was closed");
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return this.entries.get(this.selectedIndex);
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000, 0x40000000}, 32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 0x30000000) {
            return "Set or Create a Field...";
        }
        if (btnId == 0x40000000) {
            return "Reset to Immediate";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x30000000) {
            Entry e;
            DexConstantCreateDialog dlg = new DexConstantCreateDialog(this.getShell(), this.dex, this.value);
            if (dlg.open() >= 0 && (e = dlg.getSelectedEntry()) != null) {
                if (!this.dex.getConstantsLibrary().setValue(this.value, e.fieldIndex)) {
                    UI.error(Strings.ff("Failed to attach value %s to field %s", this.value, this.dex.getField(e.fieldIndex)));
                } else {
                    this.reload();
                    this.refresh();
                }
            }
        } else if (buttonId == 0x40000000) {
            this.resetRequested = true;
            this.shell.close();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame("Location", "Name", "Signature");
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        this.entries = new ArrayList<Entry>();
        Iterator<Object> iterator = this.dex.getConstantsLibrary().getFieldIndices(this.value, true, true).iterator();
        while (iterator.hasNext()) {
            int fieldIndex = iterator.next();
            Entry e = new Entry();
            e.fieldIndex = fieldIndex;
            this.entries.add(e);
        }
        for (Entry e : this.entries) {
            if (e.fieldIndex < 0) continue;
            IDexField f = this.dex.getField(e.fieldIndex);
            String name = f.getName();
            String sig = f.getSignature(true);
            df.addRow(f.isInternal() ? "Internal" : "External", name, sig);
        }
    }

    static char getValueJavaTypeChar(Object value) {
        if (value instanceof Byte) {
            return 'B';
        }
        if (value instanceof Character) {
            return 'C';
        }
        if (value instanceof Short) {
            return 'S';
        }
        if (value instanceof Integer) {
            return 'I';
        }
        if (value instanceof Long) {
            return 'J';
        }
        if (value instanceof Float) {
            return 'F';
        }
        if (value instanceof Double) {
            return 'D';
        }
        return '\u0000';
    }

    public static class Entry {
        public int fieldIndex;
    }
}

