/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.DexConstantSelectorDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.InputDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DexConstantCreateDialog
extends DataFrameDialog {
    IDexUnit dex;
    Object value;
    char valueTypeChar;
    List<DexConstantSelectorDialog.Entry> entries = new ArrayList<DexConstantSelectorDialog.Entry>();
    private int selectedIndex = -1;

    public DexConstantCreateDialog(Shell parent, IDexUnit dex, Object value) {
        super(parent, "Create a constant", true, null);
        this.dex = dex;
        this.value = value;
        this.valueTypeChar = DexConstantSelectorDialog.getValueJavaTypeChar(value);
        if (this.valueTypeChar == '\u0000') {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Integer open() {
        this.reload();
        String msg = Strings.ff("Select or create a field ref. and attach the following value: %s (type: %c)", this.value, Character.valueOf(this.valueTypeChar));
        this.setMessage(msg);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public DexConstantSelectorDialog.Entry getSelectedEntry() {
        if (!this.shell.isDisposed()) {
            throw new IllegalStateException("Shell be called only after the dialog was closed");
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return this.entries.get(this.selectedIndex);
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000}, 32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 0x30000000) {
            return "Add a Field Reference...";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x30000000) {
            String[] elts;
            InputDialog dlg = new InputDialog(this.getShell(), "Create a Field", "");
            dlg.setMessage("Fully-qualified name, dot-separated:");
            String r = dlg.open();
            if (r != null && (elts = r.trim().split("\\.")).length >= 2) {
                String fsig = "L" + Strings.join("/", elts, 0, elts.length - 1) + ";";
                if (this.dex.getField(fsig = fsig + "->" + elts[elts.length - 1] + ":" + this.valueTypeChar) == null) {
                    IDexField f = this.dex.addField(fsig);
                    if (f == null) {
                        UI.error(Strings.ff("Failed to create field reference: %s", fsig));
                    } else {
                        this.reload();
                        this.refresh();
                    }
                }
            }
        } else {
            super.onButtonClick(buttonId);
        }
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame("Name", "Signature");
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        this.entries = new ArrayList<DexConstantSelectorDialog.Entry>();
        for (IDexField iDexField : this.dex.getFields()) {
            if (iDexField.isInternal()) continue;
            DexConstantSelectorDialog.Entry e = new DexConstantSelectorDialog.Entry();
            e.fieldIndex = iDexField.getIndex();
            this.entries.add(e);
        }
        for (DexConstantSelectorDialog.Entry entry : this.entries) {
            if (entry.fieldIndex < 0) continue;
            IDexField f = this.dex.getField(entry.fieldIndex);
            String name = f.getName();
            String sig = f.getSignature(true);
            df.addRow(name, sig);
        }
    }
}

