/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.android.IApkUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerMachineInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerProcessInformation;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerTargetEnumerator;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnitIdentifier;
import com.pnfsoftware.jeb.core.units.code.debug.impl.DebuggerSetupInformation;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ContentAssistedText;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.handlers.help.HelpUserManualHandler;
import com.pnfsoftware.jeb.rcpclient.parts.CTabFolderRendererFix;
import com.pnfsoftware.jeb.rcpclient.util.CTabFolderUtils;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class DbgAttachDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(DbgAttachDialog.class);
    private RcpClientContext context;
    private IDebuggerUnit dbg;
    private IUnit target;
    private List<IDebuggerUnitIdentifier> idents = new ArrayList<IDebuggerUnitIdentifier>();
    private IApkUnit apkunit;
    private List<IDebuggerUnitIdentifier> identifiers = new ArrayList<IDebuggerUnitIdentifier>();
    private List<IDebuggerMachineInformation> machines = new ArrayList<IDebuggerMachineInformation>();
    private DataFrame dfMachines;
    private DataFrameView dfvMachines;
    private List<? extends IDebuggerProcessInformation> processes = new ArrayList<IDebuggerProcessInformation>();
    private DataFrame dfProcesses;
    private DataFrameView dfvProcesses;
    private CTabFolder debugTab;
    private ContentAssistedText widgetHostname;
    private ContentAssistedText widgetPort;
    private ContentAssistedText widgetImageBase;
    private Button btnSuspendThreads;
    private Button btnUseChildren;
    private Button btnRefresh;
    private DbgAttachInfo result;

    public DbgAttachDialog(Shell parent, RcpClientContext context, IDebuggerUnit optionalDebuggerUnit, IUnit optionalTargetUnit) {
        super(parent, S.s(234), true, true);
        this.context = context;
        this.dbg = optionalDebuggerUnit;
        if (this.dbg == null && context != null) {
            this.idents = context.getEnginesContext().getDebuggerUnitIdentifiers();
        }
        for (IUnit unit = this.target = optionalTargetUnit; unit != null; unit = (IUnit)unit.getParent()) {
            if (unit instanceof IApkUnit) {
                this.apkunit = (IApkUnit)unit;
                break;
            }
            if (!(unit.getParent() instanceof IUnit)) break;
        }
    }

    int updateMachinesList() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block4: {
                    block3: {
                        DbgAttachDialog.this.identifiers.clear();
                        DbgAttachDialog.this.machines.clear();
                        if (DbgAttachDialog.this.dbg == null) break block3;
                        IDebuggerTargetEnumerator ta = DbgAttachDialog.this.dbg.getTargetEnumerator();
                        if (ta == null) break block4;
                        for (IDebuggerMachineInformation iDebuggerMachineInformation : ta.listMachines()) {
                            DbgAttachDialog.this.identifiers.add(null);
                            DbgAttachDialog.this.machines.add(iDebuggerMachineInformation);
                        }
                        break block4;
                    }
                    for (IDebuggerUnitIdentifier ident : DbgAttachDialog.this.idents) {
                        IDebuggerTargetEnumerator iDebuggerTargetEnumerator = ident.getTargetEnumerator();
                        if (iDebuggerTargetEnumerator == null) continue;
                        for (IDebuggerMachineInformation iDebuggerMachineInformation : iDebuggerTargetEnumerator.listMachines()) {
                            DbgAttachDialog.this.identifiers.add(ident);
                            DbgAttachDialog.this.machines.add(iDebuggerMachineInformation);
                        }
                    }
                }
            }
        };
        if (this.context != null) {
            this.context.executeTaskWithPopupDelay(500, "Please wait while debugger information is being gathered...", false, r);
        } else {
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)r);
        }
        return this.machines.size();
    }

    int updateProcessesList(IDebuggerMachineInformation machine) {
        Runnable r = () -> {
            this.processes = machine.getProcesses();
        };
        if (this.context != null) {
            this.context.executeTaskWithPopupDelay(500, "Please wait while processes information is being gathered...", false, r);
        } else {
            BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)r);
        }
        return this.processes.size();
    }

    void onTabSelected() {
        this.btnRefresh.setVisible(this.debugTab.getSelectionIndex() == 0);
    }

    private DataFrame getMachines() {
        if (this.dfMachines == null) {
            this.dfMachines = new DataFrame(S.s(591), S.s(447), S.s(351), S.s(387));
        }
        return this.dfMachines;
    }

    void prepareMachineList() {
        this.getMachines().clear();
        if (this.updateMachinesList() == 0 && this.apkunit != null) {
            UI.warnOptional(this.shell, "Warning", "No Android device detected!\n\nMake sure that:\n- Your device is connected / emulator is running\n- The Android Debug Bridge tool (adb) is installed and accessible.\n  It is recommended to install the Android SDK or Android Studio with the SDK.\n\nOpen a command prompt and run 'adb devices' to verify the connectivity and status or your Android device(s).", "popupDebugAndroidNoDeviceFound");
        }
        for (IDebuggerMachineInformation machine : this.machines) {
            int flags = machine.getFlags();
            Object ff = "";
            ff = (flags & 1) != 0 ? (String)ff + "Online" : (String)ff + "Offline";
            this.getMachines().addRow(machine.getName(), machine.getLocation(), ff, machine.getInformation());
        }
    }

    private DataFrame getProcesses() {
        if (this.dfProcesses == null) {
            this.dfProcesses = new DataFrame(S.s(376), S.s(591), S.s(351));
        }
        return this.dfProcesses;
    }

    /*
     * WARNING - void declaration
     */
    String prepareProcessList(IDebuggerMachineInformation machine) {
        void var3_5;
        String pname;
        this.getProcesses().clear();
        if (machine != null) {
            if (this.updateProcessesList(machine) == 0 && this.apkunit != null) {
                UI.warnOptional(this.shell, "Warning", "No Android process/app was gathered!\n\nMake sure that:\n- Your device is connected / emulator is running\n- The Android Debug Bridge tool (adb) is installed and accessible. It is recommended to install the Android SDK or Android Studio with the SDK.\n\nOpen a command prompt and run 'adb devices' to verify the connectivity and status or your Android device(s).", "popupDebugAndroidNoProcessFound");
            }
            for (IDebuggerProcessInformation iDebuggerProcessInformation : this.processes) {
                int flags = iDebuggerProcessInformation.getFlags();
                Object ff = "";
                if ((flags & 1) != 0) {
                    ff = (String)ff + "D";
                }
                this.getProcesses().addRow(iDebuggerProcessInformation.getId(), iDebuggerProcessInformation.getName(), ff);
            }
        }
        if (this.apkunit != null && !Strings.isBlank(pname = this.apkunit.getPackageName())) {
            return pname;
        }
        StringBuilder suggestedFilter = new StringBuilder();
        IUnit iUnit = this.target;
        while (var3_5 != null) {
            if (!Strings.isBlank(var3_5.getName())) {
                if (suggestedFilter.length() > 0) {
                    suggestedFilter.append("|");
                }
                suggestedFilter.append(var3_5.getName());
            }
            if (!(var3_5.getParent() instanceof IUnit)) break;
            IUnit iUnit2 = (IUnit)var3_5.getParent();
        }
        return suggestedFilter.toString();
    }

    void refreshMachineList() {
        int index = this.dfvMachines.getSelectedRow();
        this.prepareMachineList();
        this.dfvMachines.refresh();
        if (index < this.dfvMachines.getItemCount() && index >= 0) {
            this.dfvMachines.setSelection(index);
        } else if (this.dfvMachines.getItemCount() > 0) {
            this.dfvMachines.setSelection(0);
        }
    }

    void refreshProcessList() {
        int index = this.dfvMachines.getSelectedRow();
        String suggFilter = this.prepareProcessList(index < 0 || index >= this.machines.size() ? null : this.machines.get(index));
        this.dfvProcesses.refresh();
        this.tryAutoSelectProcess(suggFilter, false);
    }

    @Override
    public DbgAttachInfo open() {
        super.open();
        return this.result;
    }

    @Override
    protected void createContents(Composite parent) {
        this.shell.setMinimumSize(600, 500);
        UIUtil.setStandardLayout(parent, 3);
        this.debugTab = new CTabFolder(parent, 2048);
        this.debugTab.setRenderer((CTabFolderRenderer)new CTabFolderRendererFix(this.debugTab));
        this.debugTab.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, true));
        CTabFolderUtils.setCTabFolderHeight(this.debugTab, -1);
        CTabItem item = new CTabItem(this.debugTab, 0, 0);
        item.setText(" Debug ");
        Composite tabComposite = new Composite((Composite)this.debugTab, 0);
        UIUtil.setStandardLayout(tabComposite, 3);
        item.setControl((Control)tabComposite);
        int autoInitDone = this.createDebugOptions(tabComposite);
        CTabItem item2 = new CTabItem(this.debugTab, 0, 1);
        item2.setText(" Remote Debug ");
        Composite tabComposite2 = new Composite((Composite)this.debugTab, 0);
        UIUtil.setStandardLayout(tabComposite2, 3);
        item2.setControl((Control)tabComposite2);
        this.createRemoteDebugOptions(tabComposite2);
        this.debugTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DbgAttachDialog.this.onTabSelected();
            }
        });
        if (this.target instanceof IApkUnit || this.target instanceof IDexUnit) {
            this.debugTab.setSelection(0);
        } else if (this.target instanceof INativeCodeUnit) {
            this.debugTab.setSelection(1);
        } else {
            this.debugTab.setSelection(0);
        }
        Group g3 = new Group(parent, 0);
        g3.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, false));
        g3.setLayout((Layout)new GridLayout(1, false));
        g3.setText("Options");
        this.btnSuspendThreads = UIUtil.createCheckbox((Composite)g3, S.s(760), null);
        this.btnSuspendThreads.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        this.btnUseChildren = UIUtil.createCheckbox((Composite)g3, "Allow children debuggers (for Android apps, provide Native debugging)", null);
        this.btnUseChildren.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        this.btnUseChildren.setToolTipText("Example: when debugging an Android app with native code, the native code debugger will be a child of the bytecode debugger");
        this.btnUseChildren.setSelection(this.isChildrenDbgSelectedByDefault());
        Composite btns = new Composite(parent, 0);
        btns.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, false));
        btns.setLayout((Layout)new GridLayout(4, false));
        Button btnAttach = UIUtil.createPushbox(btns, S.s(83), e -> {
            if (this.tryAttach()) {
                this.shell.close();
            }
        });
        UIUtil.createPushbox(btns, S.s(201), e -> this.shell.close());
        UIUtil.createPushbox(btns, S.s(365), e -> HelpUserManualHandler.openManualPage(this.context.getBaseDirectory(), this.apkunit == null ? "debugging" : "android-debugging", false));
        this.btnRefresh = UIUtil.createPushbox(btns, "Refresh Machines List", e -> {
            this.refreshMachineList();
            this.refreshProcessList();
        });
        this.onTabSelected();
        if (autoInitDone == 2) {
            btnAttach.setFocus();
        }
        this.shell.setDefaultButton(btnAttach);
        if (DbgAttachDialog.getStandardWidgetManager() != null) {
            DbgAttachDialog.getStandardWidgetManager().wrapWidget((Control)this.dfvMachines, "dbgAttachTableMachines");
            DbgAttachDialog.getStandardWidgetManager().wrapWidget((Control)this.dfvProcesses, "dbgAttachTableProcesses");
        }
    }

    private int createDebugOptions(Composite parent) {
        int autoInitDone = 0;
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, true));
        c.setLayout((Layout)new GridLayout(1, false));
        this.prepareMachineList();
        Group g0 = new Group(c, 0);
        g0.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        g0.setLayout((Layout)new GridLayout(1, false));
        g0.setText(Strings.ff("%s / %s", S.s(449), S.s(273)));
        this.dfvMachines = new DataFrameView((Composite)g0, this.getMachines(), true, false);
        this.dfvMachines.addExtraEntriesToContextMenu();
        this.dfvMachines.setLayoutData(UIUtil.createGridDataFillHorizontally());
        Group g1 = new Group(c, 0);
        g1.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, true));
        g1.setLayout((Layout)new GridLayout(1, false));
        g1.setText(S.s(663));
        this.dfvProcesses = new DataFrameView((Composite)g1, this.getProcesses(), true);
        this.dfvProcesses.addExtraEntriesToContextMenu();
        IDebuggerMachineInformation machine = this.machines.isEmpty() ? null : this.machines.get(0);
        String suggestedFilter = this.prepareProcessList(machine);
        if (machine != null) {
            this.dfvMachines.setSelection(0);
            ++autoInitDone;
        }
        if (this.tryAutoSelectProcess(suggestedFilter, true)) {
            ++autoInitDone;
        }
        this.dfvProcesses.setLayoutData(UIUtil.createGridDataSpanHorizontally(1, true, true));
        this.dfvProcesses.refresh();
        this.dfvMachines.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = DbgAttachDialog.this.dfvMachines.getSelectedRow();
                (new Object[1])[0] = index;
                DbgAttachDialog.this.refreshProcessList();
            }
        });
        this.dfvProcesses.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                if (DbgAttachDialog.this.tryAttach()) {
                    DbgAttachDialog.this.shell.close();
                }
            }
        });
        return autoInitDone;
    }

    private void createRemoteDebugOptions(Composite parent) {
        Group g2 = new Group(parent, 0);
        g2.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(3, true, false));
        g2.setLayout((Layout)new GridLayout(2, false));
        g2.setText("Remote Debugging");
        UIUtil.createLabelInGridLayout((Composite)g2, 0, "Hint: Press " + ContentAssistedText.shortcut + " to browse your input history.", 2);
        new Label((Composite)g2, 0).setText(S.s(670) + ": ");
        TextHistory history = RcpClientContext.getHistory(this.context, "dbgRemoteHostname");
        this.widgetHostname = new ContentAssistedText((Composite)g2, 2048, null, history, false);
        this.widgetHostname.setLayoutData(UIUtil.createGridDataFillHorizontally());
        new Label((Composite)g2, 0).setText(S.s(671) + ": ");
        history = RcpClientContext.getHistory(this.context, "dbgRemotePort");
        this.widgetPort = new ContentAssistedText((Composite)g2, 2048, null, history, false);
        this.widgetPort.setLayoutData(UIUtil.createGridDataFillHorizontally());
        new Label((Composite)g2, 0).setText("Mapping base (optional): ");
        history = RcpClientContext.getHistory(this.context, "dbgRemoteMappingBase");
        this.widgetImageBase = new ContentAssistedText((Composite)g2, 2048, null, history, false);
        this.widgetImageBase.setLayoutData(UIUtil.createGridDataFillHorizontally());
        String msg = "The debugger will always attempt to find the actual image bases of the debugged modules.\nHowever, it it cannot find it, as is sometimes the case with gdbserver or lldbserver, you may provide one here, in hex. (e.g. 0x117F204000)";
        UIUtil.createHelpDecorator((Control)this.widgetImageBase.getWidget(), msg);
        this.widgetImageBase.getWidget().setToolTipText(msg);
    }

    private boolean isChildrenDbgSelectedByDefault() {
        return false;
    }

    private boolean tryAutoSelectProcess(String suggestedFilter, boolean autoProcessMachine) {
        String msg;
        if (this.machines.isEmpty()) {
            return false;
        }
        int candcnt = 0;
        int machineIndex = 0;
        do {
            if (autoProcessMachine && this.dfvMachines.getSelectionIndex() != machineIndex) {
                this.dfvMachines.setSelection(machineIndex);
                IDebuggerMachineInformation machine = this.machines.get(machineIndex);
                suggestedFilter = this.prepareProcessList(machine);
            }
            if (Strings.isBlank(suggestedFilter)) continue;
            this.dfvProcesses.forceFilter(suggestedFilter);
            TableItem[] items = this.dfvProcesses.getTableItems();
            for (int i = 0; i < items.length; ++i) {
                DataFrame.Row df = (DataFrame.Row)items[i].getData();
                String pName = df.get(1).toString();
                if (pName.endsWith("lldb-server") || pName.endsWith("gdbserver")) continue;
                if (candcnt == 0) {
                    this.dfvProcesses.setSelection(i);
                }
                ++candcnt;
            }
        } while (autoProcessMachine && candcnt == 0 && this.apkunit != null && ++machineIndex < this.machines.size() && machineIndex < 5);
        if (candcnt == 0 && this.apkunit != null) {
            msg = "No matching Android application was found running on the selected device!\n\nSteps to get you started:\n- If the app is installed on your device, launch it (e.g., via the App Drawer) or start one of its components via 'adb shell am'\n  (the Activity Manager also lets you start an app in a suspended mode that waits for the debugger connection before executing)\n- If the app is not installed on your device, install it via 'adb install APPFILE'\n\nDebuggability:\n- If your app is debuggable, you should be able to install, run, and debug it on any device\n- If your app is not debuggable, you will need an emulator or a rooted device to debug it (necessary but not sufficient,\n  there are more caveats to consider when debugging a non-debuggable app, such as the API level - refer to the user manual)\n- An alternative is to let JEB regenarate and sign a debuggable version of the APK.\n  Refer to the --makeapkdebug start-up script option to generate a debuggable version of an APK.";
            UI.warnOptional(this.shell, "Warning", msg, "popupDebugAndroidNoMatchingAppFound");
        }
        if (candcnt == 1 && this.apkunit != null && !this.apkunit.isDebuggable()) {
            msg = "Heads up! The APK loaded in JEB is marked non-debuggable. What about the one running on your device?\n\nIf the installed APK is equivalent but debuggable (e.g. regenerated with --makeapkdebug), then you may proceed as normal.\nIf the installed APK is the same as the JEB project's APK, you may encounter difficulties debugging it, unless you\nare working with an emulator or rooted device. Even then, several caveats apply.\n\nGuidelines on debugging a non-debuggable APK:\n- If the app is not debuggable, you will need an emulator or a rooted device to debug it (necessary but not sufficient,\n  there are more caveats to consider when debugging a non-debuggable app, such as the API level - refer to the user manual)\n- An alternative is to let JEB regenarate and sign a debuggable version of the APK.\n  Refer to the --makeapkdebug start-up script option to generate a debuggable version of an APK.\n\nRefer to the Manual (https://www.pnfsoftware.com/jeb/manual/android-debugging/) for more details.";
            UI.infoOptional(this.shell, "APK Debuggability", msg, "popupDebugAndroidNoDebuggableMatchingAppFound");
        }
        return candcnt == 1;
    }

    private boolean tryAttach() {
        boolean isRemote;
        this.result = null;
        boolean bl = isRemote = this.debugTab.getSelectionIndex() != 0;
        if (!isRemote) {
            int index = this.dfvMachines.getSelectedRow();
            if (index >= 0 && index < this.machines.size()) {
                IDebuggerMachineInformation machine = this.machines.get(index);
                IDebuggerUnitIdentifier ident = this.identifiers.get(index);
                List<Integer> processIndexes = this.dfvProcesses.getSelectedRows();
                if (processIndexes != null && processIndexes.size() == 1 && processIndexes.get(0) < this.processes.size()) {
                    IDebuggerProcessInformation process = this.processes.get(processIndexes.get(0));
                    this.result = new DbgAttachInfo(DebuggerSetupInformation.create(machine, process), ident);
                }
            }
        } else {
            int port;
            boolean fail = false;
            String hostname = this.widgetHostname.getText();
            if (hostname.isEmpty()) {
                hostname = "localhost";
                this.widgetHostname.setText(hostname);
            }
            if ((port = Conversion.stringToInt(this.widgetPort.getText())) == 0) {
                fail = true;
            }
            Long actualImageBase = null;
            String imgbase = this.widgetImageBase.getText();
            if (!imgbase.isEmpty()) {
                long val = Conversion.stringToLong(imgbase, -1L, 16);
                if (val == -1L) {
                    fail = true;
                } else {
                    actualImageBase = val;
                }
            }
            if (!fail) {
                this.result = new DbgAttachInfo(DebuggerSetupInformation.create(hostname, port), null);
                this.result.info.setActualImageBase(actualImageBase);
            }
        }
        if (this.result == null) {
            MessageDialog.openWarning(this.shell, S.s(405), S.s(406));
            return false;
        }
        if (isRemote) {
            this.widgetHostname.confirm();
            this.widgetPort.confirm();
            this.widgetImageBase.confirm();
        }
        this.result.info.setSuspendThreads(this.btnSuspendThreads.getSelection());
        this.result.info.setUseChildrenDebuggers(this.btnUseChildren.getSelection());
        return true;
    }

    public static class DbgAttachInfo {
        public DebuggerSetupInformation info;
        public IDebuggerUnitIdentifier ident;

        DbgAttachInfo(DebuggerSetupInformation info, IDebuggerUnitIdentifier ident) {
            this.info = info;
            this.ident = ident;
        }

        public String toString() {
            return Strings.ff("info=%s,ident=%s", this.info, this.ident);
        }
    }
}

