/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.SelectorHandler;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.operations.AbstractOperation;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DataFrameDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(DataFrameDialog.class);
    private String msg;
    private boolean displayIndex = false;
    private DataFrame df;
    private DataFrameView dfv;
    private int defaultSelectionIndex = -1;
    private List<Integer> selectedIndexes = null;
    private SelectorHandler selectorHandler;

    public DataFrameDialog(Shell parent, String caption, boolean modal, String widgetName) {
        super(parent, caption, true, modal, widgetName);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    public void setDisplayIndex(boolean displayIndex) {
        this.displayIndex = displayIndex;
    }

    protected final DataFrame getDataFrame() {
        return this.df;
    }

    public void setDataFrame(DataFrame df) {
        this.df = df;
    }

    public void refresh() {
        this.dfv.refresh();
    }

    public void setMessage(String msg) {
        this.msg = msg;
    }

    public void setDefaultSelection(int index) {
        this.defaultSelectionIndex = index;
    }

    @Override
    public Integer open() {
        if (this.df == null) {
            throw new IllegalStateException("The dataframe model was not set");
        }
        super.open();
        if (this.selectedIndexes == null || this.selectedIndexes.isEmpty()) {
            return -1;
        }
        return this.selectedIndexes.get(0);
    }

    public List<Integer> openMulti() {
        if (this.df == null) {
            throw new IllegalStateException("The dataframe model was not set");
        }
        super.open();
        return this.selectedIndexes;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        if (this.msg != null) {
            UIUtil.createLabelInGridLayout(parent, 0, this.msg, 1);
        }
        this.dfv = new DataFrameView(parent, this.df, this.displayIndex);
        this.dfv.addExtraEntriesToContextMenu();
        IOperable operable = new IOperable(){

            @Override
            public boolean verifyOperation(OperationRequest req) {
                return DataFrameDialog.this.selectorHandler != null;
            }

            @Override
            public boolean doOperation(OperationRequest req) {
                List<Integer> indexes = DataFrameDialog.this.dfv.getSelectedRows();
                if (indexes == null || indexes.size() != 1) {
                    return false;
                }
                return DataFrameDialog.this.selectorHandler.select(indexes.get(0));
            }
        };
        this.dfv.addExtraEntryToContextMenu(new AbstractOperation(operable, S.s(420)){

            @Override
            protected Operation getOperation() {
                return Operation.JUMP_TO;
            }
        });
        this.dfv.setLayoutData(UIUtil.createGridDataSpanHorizontally(1, true, true));
        this.dfv.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent e) {
                DataFrameDialog.this.onConfirm();
            }
        });
        if (this.defaultSelectionIndex >= 0) {
            this.dfv.setSelection(this.defaultSelectionIndex);
        }
        this.createPreButtonsArea(parent);
        this.createButtons(parent);
        if (DataFrameDialog.getStandardWidgetManager() != null) {
            DataFrameDialog.getStandardWidgetManager().wrapWidget((Control)this.dfv, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected void createButtons(Composite parent) {
        this.createOkayCancelButtons(parent);
    }

    protected void createPreButtonsArea(Composite parent) {
    }

    protected int getSelectedRow() {
        return this.dfv.getSelectedRow();
    }

    protected List<Integer> getSelectedRows() {
        return this.dfv.getSelectedRows();
    }

    @Override
    protected void onConfirm() {
        this.selectedIndexes = this.dfv.getSelectedRows();
        super.onConfirm();
    }
}

