/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.util.BrowserUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class CustomerActionDialog
extends JebDialog {
    private static final String surveySimpleURL = "pnfsoftware.com/survey";
    public static final String surveyURL = "https://www.pnfsoftware.com/survey";
    private static final Color cBg = UIAssetManager.getInstance().getSystemColor(25);

    public CustomerActionDialog(Shell parent) {
        super(parent, "Satisfaction Survey", true, true);
        this.scrolledContainer = true;
    }

    @Override
    public Object open() {
        super.open();
        return null;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2, 10);
        Color white = parent.getDisplay().getSystemColor(1);
        parent.setBackground(white);
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(16384, 128, false, false));
        l.setBackground(parent.getDisplay().getSystemColor(1));
        l.setImage(UIAssetManager.getInstance().getImage("jeb1/icon-jeb-48.png"));
        Composite c0 = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        c0.setLayoutData((Object)data);
        c0.setLayout((Layout)new RowLayout(512));
        c0.setBackground(white);
        SelectionAdapter l_visitWebsite = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openInBrowser(CustomerActionDialog.surveyURL);
            }
        };
        String text = "Dear User,\n\nWe are conducting a satisfaction survey and would love to hear from you.\nThe survey contains 7 questions and will take just a minute of your time.\n\nThank you in advance from your participation! (If you decide to take this survey\nlater, the web link can also be found in the About box of the Help menu.)\n\n";
        Label t1 = new Label(c0, 0);
        t1.setBackground(white);
        t1.setText(text);
        Link t0 = new Link(c0, 0);
        t0.setBackground(white);
        t0.setText(Strings.ff("<a href=\"%s\">Take the Survey</a> (Will navigate to %s)\n\n", surveyURL, surveySimpleURL));
        t0.addSelectionListener((SelectionListener)l_visitWebsite);
        Composite buttons = this.createOkayButton(parent);
        buttons.setBackground(cBg);
    }
}

