/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.impl.Comment;
import com.pnfsoftware.jeb.core.units.impl.MetaComment;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CommentExDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(CommentExDialog.class);
    private Font font;
    private String address;
    private Comment comment;
    private String description;
    private String cmtInline0;
    private String cmtPre0;
    private Text wInline;
    private Text wPre;
    private String cmtInline;
    private String cmtPre;

    public CommentExDialog(Shell parent, String address) {
        super(parent, S.s(204), true, true);
        this.scrolledContainer = true;
        this.font = UIUtil.getCodeFont();
        this.address = address;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    @Override
    public String open() {
        super.open();
        return this.cmtInline;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        String msg = this.description;
        if (msg == null) {
            msg = this.address == null ? "Comments at unknown address" : Strings.ff("Comments at address: %s", this.address);
        }
        Label label = new Label(parent, 0);
        label.setText(msg);
        label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        new Label(parent, 0).setText("Primary (inline): ");
        this.wInline = new Text(parent, 2626);
        this.wInline.setFont(this.font);
        GridData griddata = UIUtil.createGridDataForText((Control)this.wInline, 50, 3, true);
        this.wInline.setLayoutData((Object)griddata);
        new Label(parent, 0).setText("Header (above): ");
        this.wPre = new Text(parent, 2626);
        this.wPre.setFont(this.font);
        griddata = UIUtil.createGridDataForText((Control)this.wPre, 50, 2, true);
        this.wPre.setLayoutData((Object)griddata);
        new Label(parent, 0).setText("Meta Comments: ");
        Text wMeta = new Text(parent, 2634);
        wMeta.setFont(this.font);
        wMeta.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        griddata = UIUtil.createGridDataForText((Control)wMeta, 50, 2, true);
        griddata.grabExcessVerticalSpace = true;
        griddata.verticalAlignment = 4;
        wMeta.setLayoutData((Object)griddata);
        boolean focused = false;
        if (this.comment == null) {
            this.cmtInline0 = "";
            this.cmtPre0 = "";
        } else {
            this.cmtInline0 = Strings.safe(this.comment.getInline());
            this.wInline.setText(this.cmtInline0);
            if (!focused) {
                focused = true;
                this.wInline.selectAll();
                this.wInline.setFocus();
            }
            this.cmtPre0 = Strings.safe(this.comment.getPre());
            this.wPre.setText(this.cmtPre0);
            if (!focused) {
                focused = true;
                this.wPre.selectAll();
                this.wPre.setFocus();
            }
            StringBuilder sb = new StringBuilder();
            for (MetaComment c : this.comment.getMetaComments()) {
                Strings.ff(sb, "%s\n", c);
            }
            String meta = sb.toString();
            if (!meta.isEmpty()) {
                wMeta.setText(meta);
            }
        }
        if (!focused) {
            this.wInline.setFocus();
        }
        this.createOkayCancelButtons(parent);
        Button btnOk = this.getButtonByStyle(32);
        UIUtil.customizeTextWidgetNavigation(this.wInline, btnOk);
        UIUtil.customizeTextWidgetNavigation(this.wPre, btnOk);
    }

    @Override
    protected void onConfirm() {
        this.cmtInline = this.wInline.getText();
        this.cmtPre = this.wPre.getText();
        super.onConfirm();
    }

    public boolean hasInlineCommentChanged() {
        return !this.cmtInline.equals(this.cmtInline0);
    }

    public String getInline() {
        return this.cmtInline;
    }

    public boolean hasPreCommentChanged() {
        return !this.cmtPre.equals(this.cmtPre0);
    }

    public String getPre() {
        return this.cmtPre;
    }
}

