/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.BookmarkManager;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BookmarkSelectorDialog
extends DataFrameDialog {
    RcpClientContext context;
    List<BookmarkManager.Bookmark> entries;
    private int selectedIndex = -1;

    public BookmarkSelectorDialog(Shell parent, RcpClientContext context) {
        super(parent, "Bookmarks", false, null);
        this.context = context;
        if (Licensing.isDebugBuild() && this.hasInstance()) {
            throw new IllegalStateException("A bookmark selector dialog already exists!");
        }
    }

    @Override
    public Integer open() {
        this.reload();
        String msg = Strings.ff("Bookmarked locations in the current project:", new Object[0]);
        this.setMessage(msg);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public BookmarkManager.Bookmark getSelectedEntry() {
        if (!this.shell.isDisposed()) {
            throw new IllegalStateException("Shell be called only after the dialog was closed");
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return this.entries.get(this.selectedIndex);
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000, 0x40000000}, 32);
        this.hideButton(32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Navigate";
        }
        if (btnId == 0x40000000) {
            return "Refresh";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            this.nav();
            super.onButtonClick(buttonId);
        } else if (buttonId == 0x30000000) {
            this.nav();
        } else if (buttonId == 0x40000000) {
            this.reload();
            this.refresh();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    private boolean nav() {
        int index = this.getSelectedRow();
        if (index < 0 || index >= this.entries.size()) {
            return false;
        }
        BookmarkManager.Bookmark e = this.entries.get(index);
        return this.nav(e);
    }

    private boolean nav(BookmarkManager.Bookmark e) {
        return GraphicalActionExecutor.gotoAddress(this.context, e.getUnit(), e.getAddress());
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame(S.s(786), S.s(788), S.s(52), S.s(268), S.s(203));
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        this.entries = this.getEntries();
        for (BookmarkManager.Bookmark e : this.entries) {
            IUnit unit = e.getUnit();
            String name = unit.getName();
            String type = e.getUnit().getFormatType();
            String address = e.getAddress();
            String desc = e.getDescription();
            String comment = null;
            if (unit instanceof IInteractiveUnit && address != null) {
                comment = ((IInteractiveUnit)unit).getInlineComment(address);
            }
            df.addRow(name, type, address, desc, comment);
        }
    }

    List<BookmarkManager.Bookmark> getEntries() {
        IRuntimeProject prj = this.context.getOpenedProject();
        if (prj == null) {
            return Collections.emptyList();
        }
        BookmarkManager bm = prj.getBookmarkManager();
        return bm.getAll();
    }
}

