/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.Assistant;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AssistantRenamerDialog
extends JebDialog {
    Assistant.Response r;
    Text wText;
    boolean retcode;

    public AssistantRenamerDialog(Shell parent, ISourceUnit srcUnit, Assistant.Response r) {
        super(parent, "Renaming Assistant", true, false, "assistantDlg");
        this.r = r;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.retcode;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        StringBuilder sb = new StringBuilder();
        Strings.ff(sb, "; format: \"current_signature => new_name\"", new Object[0]);
        for (Couple<String, String> c : this.r.deobmap) {
            if (Strings.isBlank(c.getFirst()) || Strings.isBlank(c.getSecond())) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            Strings.ff(sb, "%s => %s", c.getFirst(), c.getSecond());
        }
        String data = sb.toString();
        UIUtil.createLabelInGridLayout(parent, 64, "These suggestions were provided by the assistant. Edit as necessary. Press Okay to apply the new names.", 1);
        this.wText = UIUtil.createTextboxInGrid(parent, 2818, 80, 10, true, true);
        this.wText.setFont(UIUtil.getCodeFont());
        this.wText.setText(data);
        this.wText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    return;
                }
                e.doit = true;
            }
        });
        this.createOkayCancelButtons(parent);
    }

    @Override
    protected void onConfirm() {
        if (!this.updateResponseData()) {
            UI.warn(this.getShell(), "Warning", "Illegal renaming data!");
            return;
        }
        this.retcode = true;
        super.onConfirm();
    }

    private boolean updateResponseData() {
        ArrayList<Couple<String, String>> deobmap2 = new ArrayList<Couple<String, String>>();
        String data = this.wText.getText();
        for (String line : Strings.splitLines(data)) {
            String[] elts;
            if ((line = line.trim()).startsWith(";") || line.startsWith("//") || (elts = line.split("=>")).length != 2) continue;
            String oldname = elts[0].trim();
            String newname = elts[1].trim();
            if (Strings.isBlank(oldname) || Strings.isBlank(newname)) continue;
            deobmap2.add(new Couple<String, String>(oldname, newname));
        }
        if (deobmap2.isEmpty()) {
            return false;
        }
        this.r.deobmap.clear();
        this.r.deobmap.addAll(deobmap2);
        return true;
    }
}

