/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.AbstractClientContext;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ButtonGroup;
import com.pnfsoftware.jeb.rcpclient.util.BrowserUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AboutDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(AboutDialog.class);
    static final String[] app_thirdpartylist = new String[]{"Android Framework (Apache License 2.0)", "ANTLR4 (The BSD License)", "AOSP dx, d8 packages (Apache License 2.0)", "Apache Commons (Apache License 2.0)", "ByteBuddy (Apache License 2.0)", "Eclipse SWT, JFace (Eclipse Public License)", "Google Guava (Apache License 2.0)", "JEP (zlib/libpng License)", "JNA 5.x (Apache License 2.0)", "JSON-Simple (Apache License 2.0)", "Jsoup (MIT License)", "Jython (Python Software Foundation License 2.0)", "LZ4 for Java (Apache License 2.0)", "Netty (Apache License 2.0)", "Objenesis (Apache License 2.0)", "Okhttp, Okio (Apache License 2.0)", "SnakeYAML (Apache License 2.0)", "SQLite (Apache License 2.0)", "Z3 (MIT License)", "Zip4j (Apache License 2.0)"};
    private AbstractClientContext context;
    private static final Color cBg = UIAssetManager.getInstance().getSystemColor(25);

    public AboutDialog(Shell parent, AbstractClientContext context) {
        super(parent, Strings.ff(S.s(2), "JEB"), true, true);
        this.scrolledContainer = true;
        this.context = context;
    }

    @Override
    public Object open() {
        if (Licensing.isDebugBuild()) {
            System.gc();
        }
        super.open();
        return null;
    }

    @Override
    public void createContents(Composite ctl) {
        String licenseKey;
        UIUtil.setStandardLayout(ctl, 2, 10);
        ctl.setBackground(cBg);
        Label l = new Label(ctl, 0);
        l.setLayoutData((Object)new GridData(16384, 128, false, false));
        l.setBackground(cBg);
        l.setImage(UIAssetManager.getInstance().getImage("jeb1/icon-jeb-48.png"));
        Composite c0 = new Composite(ctl, 0);
        GridData data = new GridData();
        data.horizontalIndent = 15;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        c0.setLayoutData((Object)data);
        c0.setLayout((Layout)new GridLayout(1, false));
        c0.setBackground(cBg);
        SelectionAdapter l_visitLink = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openInBrowser(e.text);
            }
        };
        Link t0 = new Link(c0, 64);
        t0.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        t0.setBackground(cBg);
        t0.setText(Strings.ff("<a href=\"%s\">%s</a>", "https://www.pnfsoftware.com", "PNF Software, Inc."));
        t0.addSelectionListener((SelectionListener)l_visitLink);
        if (Licensing.isFloatingBuild() && this.context != null) {
            Link t01 = new Link(c0, 64);
            t01.setBackground(cBg);
            int protocol = this.context.getControllerProtocol();
            String url = Strings.ff("%s://%s:%d", switch (protocol) {
                case 0 -> "http";
                case 1 -> "https";
                default -> {
                    logger.warn("Illegal controller protocol value (%d), will assume http", protocol);
                    yield "http";
                }
            }, this.context.getControllerInterface(), this.context.getControllerPort());
            t01.setText(Strings.ff("<a href=\"%s\">%s</a>", url, "Visit your Floating Controller Web Portal"));
            t01.addSelectionListener((SelectionListener)l_visitLink);
        }
        Label t1 = new Label(c0, 64);
        t1.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        t1.setBackground(cBg);
        t1.setText(Strings.ff("\n%s - %s\n%s \u00a9 %s\n\n", "JEB", "Interactive Decompilation for Software Analysis", "PNF Software, Inc.", "2015-2024"));
        final Text t2 = new Text(c0, 2114);
        t2.setEditable(false);
        StringBuilder sb = new StringBuilder();
        sb.append(AbstractClientContext.generateLicenseInformation());
        if (this.context != null && (licenseKey = this.context.getPropertyManager().getString(".LicenseKey")) != null && !licenseKey.isEmpty()) {
            Strings.ff(sb, "\n%s: %s", S.s(436), licenseKey);
        }
        final String text = sb.toString();
        t2.setText(text);
        t2.setFocus();
        t2.selectAll();
        Composite c00 = new Composite(c0, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        c00.setLayout((Layout)layout);
        c00.setBackground(cBg);
        UIUtil.createPushbox(c00, S.s(213), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sel = t2.getSelectionText();
                if (sel.isEmpty()) {
                    sel = text;
                }
                UIUtil.copyTextToClipboard(sel);
                MessageDialog.openInformation(AboutDialog.this.shell, S.s(210), S.s(432));
            }
        });
        UIUtil.createPushbox(c00, "System...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int len;
                StringBuilder sb = new StringBuilder();
                sb.append("*** System Properties ***\n");
                int maxkeylen = 0;
                TreeSet<String> pkeys = new TreeSet<String>();
                for (Object object : new TreeSet<Object>(System.getProperties().keySet())) {
                    String pkey;
                    if (!(object instanceof String) || (pkey = (String)object).equals("line.separator")) continue;
                    pkeys.add(pkey);
                    len = pkey.length();
                    if (len <= maxkeylen) continue;
                    maxkeylen = len;
                }
                for (String string : pkeys) {
                    Strings.ff(sb, "%s%s  %s\n", string, Strings.spaces(maxkeylen - string.length()), System.getProperty(string));
                }
                sb.append("\n*** System Environment ***\n");
                maxkeylen = 0;
                TreeSet<String> keys = new TreeSet<String>(System.getenv().keySet());
                for (String key : keys) {
                    len = key.length();
                    if (len <= maxkeylen) continue;
                    maxkeylen = len;
                }
                for (String key : keys) {
                    Strings.ff(sb, "%s%s  %s\n", key, Strings.spaces(maxkeylen - key.length()), System.getenv(key));
                }
                TextDialog textDialog = new TextDialog(AboutDialog.this.getShell(), "System Information", sb.toString(), null);
                textDialog.setFont(UIUtil.getCodeFont());
                textDialog.setLineCount(40);
                textDialog.setColumnCount(100);
                textDialog.setEditable(false);
                textDialog.setSelected(false);
                textDialog.setCancelLabelId(null);
                textDialog.setNoWordWrap(true);
                textDialog.open();
            }
        });
        Label t3 = new Label(c0, 64);
        t3.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        t3.setBackground(cBg);
        t3.setText(Strings.ff("\n%s.\n", S.s(775)));
        StringBuilder tplText = new StringBuilder();
        for (String thirdparty : app_thirdpartylist) {
            Strings.ff(tplText, "- %s\n", thirdparty);
        }
        Text t31 = UIUtil.createTextboxInGrid(c0, 2562, 0, 4);
        t31.setEditable(false);
        t31.setText(tplText.toString());
        Label t4 = new Label(c0, 64);
        t4.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        t4.setBackground(cBg);
        t4.setText("\n" + AbstractClientContext.formatProcessInfo(true, true, false, false));
        Link t41 = new Link(c0, 64);
        t41.setBackground(cBg);
        t41.setText(Strings.ff("<a href=\"%s\">%s</a>", "https://www.pnfsoftware.com/jeb/faqmem", S.s(382)));
        t41.addSelectionListener((SelectionListener)l_visitLink);
        Label t5 = new Label(c0, 64);
        t5.setBackground(cBg);
        t5.setText("\n");
        ButtonGroup bg = ButtonGroup.buildButtons(ctl, 0, 2);
        bg.setBackground(cBg);
        Button btn_ok = bg.add(S.s(605), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AboutDialog.this.shell.close();
            }
        });
        bg.add("Survey", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserUtil.openInBrowser("https://www.pnfsoftware.com/survey");
            }
        });
        if (Licensing.isFree()) {
            Button btn = bg.add("Purchase", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserUtil.openInBrowser("https://www.pnfsoftware.com/jeb/buy");
                }
            });
            btn.setImage(UIAssetManager.getInstance().getImage("program/jeb_16px.png"));
            btn = bg.add("Donate", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserUtil.openInBrowser("https://www.pnfsoftware.com/jeb/donate");
                }
            });
            btn.setImage(UIAssetManager.getInstance().getImage("program/icon-donate-16x16.png"));
        }
        this.shell.setDefaultButton(btn_ok);
    }
}

