/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.actions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.actions.ActionAutoRenameAllData;
import com.pnfsoftware.jeb.core.actions.ActionCollapseData;
import com.pnfsoftware.jeb.core.actions.ActionCommentData;
import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionConvertData;
import com.pnfsoftware.jeb.core.actions.ActionCreatePackageData;
import com.pnfsoftware.jeb.core.actions.ActionDeleteData;
import com.pnfsoftware.jeb.core.actions.ActionMoveToData;
import com.pnfsoftware.jeb.core.actions.ActionOverridesData;
import com.pnfsoftware.jeb.core.actions.ActionRenameData;
import com.pnfsoftware.jeb.core.actions.ActionReplaceData;
import com.pnfsoftware.jeb.core.actions.ActionSetTypeData;
import com.pnfsoftware.jeb.core.actions.ActionTypeHierarchyData;
import com.pnfsoftware.jeb.core.actions.ActionXrefsData;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.CodeConstant;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.AutoRenameDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.CodeHierarchyDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.CommentDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.CreatePackageDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.MoveToDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.OverridesDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.ReferencesDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.RenameItemDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.SelectorHandler;
import com.pnfsoftware.jeb.rcpclient.dialogs.TypeHierarchyDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NamedConstantsChooserDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeTypeDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.nativeactions.NativeActionUtil;
import com.pnfsoftware.jeb.rcpclient.parts.AddressNavigator;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.swt.widgets.Shell;

public class GraphicalActionExecutor {
    private static final ILogger logger = GlobalLog.getLogger(GraphicalActionExecutor.class);
    private Shell shell;
    private IRcpClientContext context;

    public GraphicalActionExecutor(Shell shell, IRcpClientContext context) {
        this.shell = shell;
        this.context = context;
    }

    public boolean execute(ActionUIContext uictx) {
        return this.execute(uictx, null);
    }

    public boolean execute(ActionUIContext uictx, Object value) {
        (new Object[1])[0] = uictx;
        final ActionContext info = uictx.getActionContext();
        switch (info.getActionId()) {
            case 2: {
                ActionRenameData data = new ActionRenameData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                while (true) {
                    String newName;
                    boolean bypassNameChecks = false;
                    if (value == null) {
                        RenameItemDialog dlg = new RenameItemDialog(this.shell, RcpClientContext.getStandardRenamingHistory(this.context));
                        dlg.setDescription(data.getDescription());
                        dlg.setInitialValue(data.getCurrentName());
                        dlg.setOriginalValue(data.getOriginalName());
                        boolean bypassNameChecks0 = this.context.getPropertyManager().getBoolean(".ui.dialogs.rename.BypassChecks");
                        dlg.setBypassNameChecks(bypassNameChecks0);
                        newName = dlg.open();
                        if (newName != null && (bypassNameChecks = dlg.isBypassNameChecks()) != bypassNameChecks0) {
                            this.context.getPropertyManager().setBoolean(".ui.dialogs.rename.BypassChecks", bypassNameChecks);
                        }
                    } else {
                        newName = value.toString();
                    }
                    if (newName == null) break;
                    data.setNewName(newName);
                    data.setBypassNameChecks(bypassNameChecks);
                    if (info.getUnit().executeAction(info, data)) {
                        return true;
                    }
                    if (data.getExecutionErrorCode() != 1) break;
                    UI.error("The rename action failed because of a naming conflict.");
                    if (!data.canReuseObject()) break;
                    data.reset();
                    data.setCurrentName(newName);
                }
                return false;
            }
            case 14: {
                final ActionAutoRenameAllData data = new ActionAutoRenameAllData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                AutoRenameDialog dlg = new AutoRenameDialog(this.shell, Strings.safe(data.getDescription()));
                dlg.setInitialPolicy(data.getDefaultPolicy());
                dlg.setInitialFilter(data.getDefaultFilter());
                if (!dlg.open().booleanValue()) break;
                int policy = dlg.getPolicy();
                String filter = dlg.getFilter();
                if (policy <= 0) break;
                data.setPolicy(policy);
                data.setFilter(filter);
                boolean success = this.context.executeTaskWithPopupDelay(2000, "Renaming items...", true, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return info.getUnit().executeAction(info, data);
                    }
                });
                if (!success) break;
                int cnt = data.getRenamedCount();
                UI.info(this.shell, "Auto-rename", Strings.ff("%d %s renamed.", cnt, PluralFormatter.countS(cnt, "item")));
                break;
            }
            case 3: {
                String newComment;
                String address;
                ActionCommentData data = new ActionCommentData();
                if (!info.getUnit().prepareExecution(info, data) || (address = info.getAddress()) == null) break;
                if (value == null) {
                    CommentDialog dlg = new CommentDialog(this.shell, address);
                    dlg.setDescription(data.getDescription());
                    dlg.setInitialComment(data.getComment());
                    newComment = dlg.open();
                } else {
                    newComment = value.toString();
                }
                if (newComment == null) break;
                data.setNewComment(newComment);
                return info.getUnit().executeAction(info, data);
            }
            case 10: {
                String fqname;
                ActionCreatePackageData data = new ActionCreatePackageData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                if (value == null) {
                    CreatePackageDialog dlg = new CreatePackageDialog(this.shell, RcpClientContext.getStandardRenamingHistory(this.context));
                    dlg.setDescription(data.getDescription());
                    dlg.setInitialValue(data.getCurrentPackageFqname());
                    fqname = dlg.open();
                } else {
                    fqname = value.toString();
                }
                if (fqname == null) break;
                data.setFqname(fqname);
                return info.getUnit().executeAction(info, data);
            }
            case 16: {
                String fqname;
                ActionMoveToData data = new ActionMoveToData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                if (value == null) {
                    MoveToDialog dlg = new MoveToDialog(this.shell, RcpClientContext.getStandardRenamingHistory(this.context));
                    dlg.setDescription(data.getDescription());
                    dlg.setInitialValue(data.getCurrentItemFqname());
                    fqname = dlg.open();
                } else {
                    fqname = value.toString();
                }
                if (fqname == null) break;
                data.setDstContainerFqname(fqname);
                return info.getUnit().executeAction(info, data);
            }
            case 4: {
                List<ICoordinates> coords;
                long itemId;
                ActionXrefsData data = new ActionXrefsData();
                if (info.getUnit().prepareExecution(info, data)) {
                    Object caption = S.s(45);
                    if (data.getTarget() != null) {
                        caption = (String)caption + " to " + data.getTarget();
                    }
                    final List<String> addresses = data.getAddresses();
                    List<String> userAddresses = this.context.getPropertyManager().getBoolean(".ui.PreferRealAddressesInDialogs") ? null : data.getUserAddresses();
                    ReferencesDialog dlg = new ReferencesDialog(this.shell, (String)caption, userAddresses == null ? addresses : userAddresses, data.getDetails(), info.getUnit());
                    dlg.setMessage("Hints: this dialog is modeless. Click outside to carry on your navigation while keeping it on the foregound.\nAdditionally, right-click an address and use the 'Jump To' command to navigate to that address without closing the dialog.");
                    final IMPart part0 = this.context.getPartManager().getActivePart();
                    if (part0 == null) {
                        return false;
                    }
                    dlg.setSelectorHandler(new SelectorHandler(){

                        @Override
                        public boolean select(int index) {
                            if (index >= 0) {
                                IUnit unit = null;
                                if (part0.getManager() instanceof UnitPartManager) {
                                    unit = ((UnitPartManager)part0.getManager()).getUnit();
                                }
                                if (unit == null) {
                                    unit = info.getUnit();
                                }
                                String address = (String)addresses.get(index);
                                return GraphicalActionExecutor.gotoAddress(GraphicalActionExecutor.this.context, unit, address);
                            }
                            return false;
                        }
                    });
                    dlg.setDefaultSelection(addresses.indexOf(info.getAddress()));
                    int index = dlg.open();
                    if (index < 0) {
                        return false;
                    }
                    IUnit unit = null;
                    if (part0.getManager() instanceof UnitPartManager) {
                        unit = ((UnitPartManager)part0.getManager()).getUnit();
                    }
                    if (unit == null) {
                        unit = info.getUnit();
                    }
                    String address = addresses.get(index);
                    return GraphicalActionExecutor.gotoAddress(this.context, unit, address);
                }
                IUnitFragment fragment = uictx.getFragment();
                if (!(fragment instanceof TextFragment) || (itemId = info.getItemId()) == 0L || (coords = ((TextFragment)fragment).collectItemCoordinates(itemId)).isEmpty()) break;
                ArrayList<String> addresses = new ArrayList<String>();
                for (ICoordinates coord : coords) {
                    addresses.add(Strings.ff("Text @ %d:%d", 1 + coord.getLineDelta(), 1 + coord.getColumnOffset()));
                }
                ReferencesDialog dlg = new ReferencesDialog(this.shell, S.s(47), addresses, null, info.getUnit());
                int index = dlg.open();
                if (index < 0) break;
                ICoordinates coord = coords.get(index);
                ((TextFragment)fragment).setCaretCoordinates(coord);
                break;
            }
            case 12: {
                TypeHierarchyDialog dlg = JebDialog.getInstance(TypeHierarchyDialog.class);
                if (dlg != null) {
                    dlg.setFocus();
                    return false;
                }
                dlg = new TypeHierarchyDialog(this.shell, this.context);
                dlg.setSource(info.getUnit(), null, info.getItemId(), info.getAddress());
                int retcode = dlg.open();
                if (retcode != 1) {
                    return true;
                }
                ActionTypeHierarchyData data = new ActionTypeHierarchyData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                ICodeUnit codeUnit = null;
                IInteractiveUnit unit = info.getUnit();
                if (unit instanceof ICodeUnit) {
                    codeUnit = (ICodeUnit)unit;
                }
                if (unit instanceof ISourceUnit) {
                    codeUnit = DecompilerHelper.getRelatedCodeUnit(unit);
                }
                if (codeUnit == null) break;
                CodeHierarchyDialog dlg2 = JebDialog.getInstance(CodeHierarchyDialog.class);
                if (dlg2 != null) {
                    dlg2.setFocus();
                    return false;
                }
                dlg2 = new CodeHierarchyDialog(this.shell, codeUnit, data.getBaseNode(), data.getBaseNodeForAscendingHierarchy(), this.context);
                String selectedAddress = dlg2.open();
                if (selectedAddress == null) break;
                GraphicalActionExecutor.gotoAddress(this.context, info.getUnit(), selectedAddress);
                return info.getUnit().executeAction(info, data);
            }
            case 13: {
                OverridesDialog dlg = JebDialog.getInstance(OverridesDialog.class);
                if (dlg != null) {
                    dlg.setFocus();
                    return false;
                }
                dlg = new OverridesDialog(this.shell, this.context);
                dlg.setSource(info.getUnit(), null, info.getItemId(), info.getAddress());
                int retcode = dlg.open();
                if (retcode != 1) {
                    return true;
                }
                ActionOverridesData data = new ActionOverridesData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                ReferencesDialog dlg3 = new ReferencesDialog(this.shell, S.s(534), data.getAddresses(), null, info.getUnit());
                int index = dlg3.open();
                if (index >= 0) {
                    String address = data.getAddresses().get(index);
                    GraphicalActionExecutor.gotoAddress(this.context, info.getUnit(), address);
                }
                return info.getUnit().executeAction(info, data);
            }
            case 1: {
                ActionDeleteData data = new ActionDeleteData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                return info.getUnit().executeAction(info, data);
            }
            case 5: {
                ActionConvertData data = new ActionConvertData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                return info.getUnit().executeAction(info, data);
            }
            case 6: {
                INativeCodeUnit<?> pbcu = NativeActionUtil.getRelatedNativeCodeUnit(info.getUnit());
                if (pbcu == null) {
                    return false;
                }
                ActionReplaceData data = new ActionReplaceData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                Object o = data.getTargetObject();
                if (o == null) {
                    return false;
                }
                NamedConstantsChooserDialog dlg = new NamedConstantsChooserDialog(this.shell, pbcu, o);
                CodeConstant cst = dlg.open();
                if (cst == null) {
                    return false;
                }
                data.setWantedReplacement(cst);
                return info.getUnit().executeAction(info, data);
            }
            case 15: {
                String newType;
                ActionSetTypeData data = new ActionSetTypeData();
                if (!info.getUnit().prepareExecution(info, data)) break;
                if (value == null) {
                    String target = null;
                    TextHistory historyData = this.context.getTextHistoryData().get("nativeTypesHistory");
                    NativeTypeDialog dlg = new NativeTypeDialog(this.shell, 0, target, historyData, info.getUnit());
                    dlg.setInitialValue(data.getCurrentType());
                    newType = dlg.open();
                } else {
                    newType = value.toString();
                }
                if (newType == null) break;
                data.setNewType(newType);
                return info.getUnit().executeAction(info, data);
            }
            case 17: {
                ActionCollapseData data = new ActionCollapseData(true);
                data.setRecords(Maps.toMap(info.getAddress(), null));
                if (!info.getUnit().prepareExecution(info, data)) break;
                return info.getUnit().executeAction(info, data);
            }
            default: {
                logger.debug("The action (%d) is not supported by this client", info.getActionId());
            }
        }
        return false;
    }

    public static boolean gotoAddress(IRcpClientContext context, IUnit unit, String selectedAddress) {
        if (unit == null || unit.isDisposed() || selectedAddress == null) {
            return false;
        }
        if (context.getOpenedProject() == null) {
            return false;
        }
        PartManager pman = context.getPartManager();
        if (pman == null) {
            return false;
        }
        return new AddressNavigator(context, unit).navigate(selectedAddress);
    }
}

