/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class UsageTracker {
    private static final ILogger logger = GlobalLog.getLogger(UsageTracker.class);
    public static final long PERIOD_INACTIVITY = 15000L;
    public static final long PERIOD_TRIGGER_RECORD = 3000L;
    private Display display;
    private Listener filter;
    private long ts0;
    private long ts1;
    private long totalUseTime;

    public UsageTracker(Display display) {
        this.display = display;
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                if (event.type != 1 && event.type != 5) {
                    return;
                }
                long ts = (long)event.time & 0xFFFFFFFFL;
                if (UsageTracker.this.ts0 == 0L) {
                    UsageTracker.this.ts0 = ts;
                    UsageTracker.this.ts1 = ts;
                    return;
                }
                long gap = ts - UsageTracker.this.ts1;
                if (gap >= 15000L) {
                    UsageTracker.this.totalUseTime += UsageTracker.this.ts1 - UsageTracker.this.ts0;
                    UsageTracker.this.ts0 = ts;
                    UsageTracker.this.ts1 = ts;
                    return;
                }
                long activity = ts - UsageTracker.this.ts0;
                if (activity >= 3000L) {
                    UsageTracker.this.totalUseTime += activity;
                    UsageTracker.this.ts0 = ts;
                    UsageTracker.this.ts1 = ts;
                    return;
                }
                UsageTracker.this.ts1 = ts;
            }
        };
        display.addFilter(1, this.filter);
        display.addFilter(5, this.filter);
    }

    public void dispose() {
        this.display.removeFilter(1, this.filter);
        this.display.removeFilter(5, this.filter);
    }

    public long getTotalUseTime() {
        return this.totalUseTime;
    }

    public void reset() {
        this.ts0 = 0L;
        this.ts1 = 0L;
        this.totalUseTime = 0L;
    }
}

