/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.Assets;
import com.pnfsoftware.jeb.rcpclient.extensions.SwtRegistry;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public final class UIAssetManager
extends SwtRegistry {
    private static final ILogger logger = GlobalLog.getLogger(UIAssetManager.class);
    private static UIAssetManager manager = null;
    private Map<String, Image> images = new HashMap<String, Image>();
    private Map<ImageDescriptor, Image> images2 = new IdentityHashMap<ImageDescriptor, Image>();

    public static UIAssetManager getInstance() {
        if (manager == null) {
            manager = new UIAssetManager();
        }
        return manager;
    }

    private UIAssetManager() {
        super(Display.getCurrent());
    }

    public Image getImage(String filename) {
        Image asset = this.images.get(filename);
        if (asset == null) {
            try (InputStream in = Assets.getAsset(filename);){
                if (in == null) {
                    logger.warn("Image not found: %s", filename);
                } else {
                    asset = new Image((Device)this.display, in);
                }
                this.images.put(filename, asset);
            }
            catch (SWTException e) {
                logger.catching(e);
            }
            catch (IOException iOException) {}
        }
        return asset;
    }

    public Image getImage(String filename, AssetManagerOverlay overlay) {
        if (overlay == null) {
            return this.getImage(filename);
        }
        if (!overlay.hasLayer()) {
            return this.getImage(filename);
        }
        Image asset = this.images.get(filename + overlay.getId());
        if (asset == null) {
            asset = overlay.build(this.getImage(filename));
            this.images.put(filename + overlay.getId(), asset);
        }
        return asset;
    }

    public static String toBase64(Image image) {
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        imgLoader.save((OutputStream)stream, 5);
        return Base64.getEncoder().encodeToString(stream.toByteArray());
    }

    public Image getImage(ImageDescriptor imageDesc) {
        Image img = this.images2.get(imageDesc);
        if (img == null) {
            img = imageDesc.createImage((Device)this.display);
            if (img == null) {
                return null;
            }
            this.images2.put(imageDesc, img);
        }
        return img;
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Image image : this.images.values()) {
            image.dispose();
        }
        this.images.clear();
        for (Image image : this.images2.values()) {
            image.dispose();
        }
        this.images2.clear();
    }
}

