/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.ErrorLogGenerator;
import com.pnfsoftware.jeb.client.JebNet;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.util.collect.ConcurrentHashSet;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.net.Net;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RcpErrorUpRoutine
implements Runnable {
    private long artifactSizeLimit = 0x8000000L;
    private static final Set<String> uploadedSet = new ConcurrentHashSet<String>();
    private static final Set<String> uploadedSetSuccess = new ConcurrentHashSet<String>();
    private Net net;
    private boolean verbose;
    private Map<String, Object> extramap;
    private ErrorLogGenerator log;
    private boolean uploadErrorLogs;
    private boolean uploadErrorFiles;
    private List<IArtifact> artifacts;
    private File reloadedProjectFile;
    int fileUploadIOExceptionCount;
    Exception fileUploadGenericException;
    int dumpLogPolicy;
    File dumpLogFolder;

    public static void clearCache() {
        uploadedSet.clear();
        uploadedSetSuccess.clear();
    }

    public static int getUniqueUploads() {
        return uploadedSet.size();
    }

    public static int getUniqueSuccessfulUploads() {
        return uploadedSetSuccess.size();
    }

    public RcpErrorUpRoutine(Net net, ErrorLogGenerator log, Map<String, Object> extramap, boolean uploadErrorLogs, boolean uploadErrorFiles, List<IArtifact> artifacts, boolean verbose) {
        this.net = net;
        this.log = log;
        this.extramap = extramap;
        this.uploadErrorLogs = uploadErrorLogs;
        this.uploadErrorFiles = uploadErrorFiles;
        this.artifacts = artifacts;
        this.verbose = verbose;
    }

    public void setArtifactSizeLimit(long artifactSizeLimit) {
        this.artifactSizeLimit = artifactSizeLimit;
    }

    public boolean hasErrors() {
        return this.fileUploadIOExceptionCount != 0 || this.fileUploadGenericException != null;
    }

    public void setDumpLogPolicy(int policy) {
        this.dumpLogPolicy = policy;
    }

    public void setDumpLogFolder(File folder) {
        this.dumpLogFolder = folder;
    }

    public void setReloadedProjectFile(File file) {
        this.reloadedProjectFile = file;
    }

    @Override
    public void run() {
        boolean errorLogUploaded = false;
        if (this.uploadErrorLogs || this.uploadErrorFiles) {
            if (this.uploadErrorLogs) {
                String r = JebNet.post(this.net, "https://www.pnfsoftware.com/upload_errorlog", this.log.getLog(null, true));
                boolean bl = errorLogUploaded = r != null;
            }
            if (this.uploadErrorFiles) {
                try {
                    ArrayList<IInput> inputs = new ArrayList<IInput>();
                    boolean uploadArtifacts = true;
                    if (this.extramap != null) {
                        if (this.extramap.containsKey("dnuart")) {
                            uploadArtifacts = false;
                        }
                        if (this.extramap.get("pbmfp") instanceof String) {
                            String path = (String)this.extramap.get("pbmfp");
                            inputs.add(new FileInput(path));
                        }
                    }
                    int missingArtCount = 0;
                    if (uploadArtifacts) {
                        for (IArtifact a : this.artifacts) {
                            IInput input = a.getInput();
                            if (!input.canRead()) {
                                ++missingArtCount;
                                continue;
                            }
                            inputs.add(input);
                        }
                    }
                    for (IInput input : inputs) {
                        if (input.getCurrentSize() > this.artifactSizeLimit) continue;
                        File tempfile = null;
                        try {
                            File f;
                            if (input instanceof FileInput) {
                                f = ((FileInput)input).getFile();
                            } else {
                                try (InputStream in = input.getStream();){
                                    tempfile = IO.createTempFile();
                                    tempfile.deleteOnExit();
                                    IO.writeFile(tempfile, IO.readInputStream(in));
                                    f = tempfile;
                                }
                            }
                            if (f == null) continue;
                            this.upload(this.net, f, this.artifactSizeLimit);
                        }
                        catch (IOException iOException) {
                            ++this.fileUploadIOExceptionCount;
                        }
                        finally {
                            if (tempfile == null) continue;
                            tempfile.delete();
                        }
                    }
                    if (missingArtCount > 0 && this.reloadedProjectFile != null) {
                        try {
                            this.upload(this.net, this.reloadedProjectFile, this.artifactSizeLimit);
                        }
                        catch (IOException iOException) {
                            ++this.fileUploadIOExceptionCount;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogGenerator gen2 = new ErrorLogGenerator(ex);
                    JebNet.post(this.net, "https://www.pnfsoftware.com/upload_errorlog", gen2.getLog(null, true));
                    this.fileUploadGenericException = ex;
                }
            }
        }
        boolean dumpLog = false;
        if (this.dumpLogPolicy == 2) {
            dumpLog = true;
        } else if (this.dumpLogPolicy == 1) {
            boolean bl = dumpLog = !errorLogUploaded;
        }
        if (dumpLog && this.dumpLogFolder != null) {
            this.dumpLogFolder.mkdir();
            String path = this.log.dumpTo(this.dumpLogFolder.getAbsolutePath());
            StringBuilder msg = new StringBuilder();
            Strings.ff(msg, "%s.", S.s(305));
            Strings.ff(msg, "\n\n%s: %s.", S.s(307), path);
            if (this.verbose) {
                UI.error(msg.toString());
            }
        }
    }

    private boolean upload(Net net, File f, long maxSize) throws IOException {
        block9: {
            if (f != null && f.isFile() && f.canRead() && f.length() < maxSize) {
                try (FileInputStream in = new FileInputStream(f);){
                    HashCalculator h = new HashCalculator(in, 16);
                    if (!h.compute()) break block9;
                    String digest = Formatter.byteArrayToHexString(h.getSha256());
                    if (uploadedSet.add(digest)) {
                        if (JebNet.uploadFile(net, f, true) != null) {
                            uploadedSetSuccess.add(digest);
                            boolean bl = true;
                            return bl;
                        }
                        break block9;
                    }
                    boolean bl = uploadedSetSuccess.contains(digest);
                    return bl;
                }
            }
        }
        return false;
    }
}

