/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.ErrorLogGenerator;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.input.FileInput;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitLockedException;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.RcpErrorUpRoutine;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.encoding.HashCalculator;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import com.pnfsoftware.jeb.util.primitives.Booleans;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.SWTException;

public class RcpErrorHandler {
    public static final String EM_KEY_DO_NOT_UPLOAD_ARTIFACTS = "dnuart";
    public static final String EM_KEY_PROBLEMATIC_FILEPATH = "pbmfp";
    private static final Set<String> EM_SPECIAL_KEYS = new HashSet<String>();
    private static final ILogger logger;
    public static final long STD_FAILSAFE__SLIDING_WINDOW_DURATION_MS = 60000L;
    public static final int STD_FAILSAFE__MAX_REPORT_COUNT_PER_SLIDING_WINDOW = 5;
    private long failsafeSlidingWindowDurationMs = 60000L;
    private int failsafeMaxReportCountPerSlidingWindow = 5;
    private List<Long> errorTimestamps = new ArrayList<Long>();
    private Set<String> sentLoghashSet = new HashSet<String>();
    private RcpClientContext ctx;

    public RcpErrorHandler(RcpClientContext ctx) {
        this.ctx = ctx;
    }

    public void disableFailsafe() {
        this.failsafeSlidingWindowDurationMs = 0L;
        this.failsafeMaxReportCountPerSlidingWindow = 0;
    }

    public void enableFailsafe(long failsafeSlidingWindowDurationMs, int failsafeMaxReportCountPerSlidingWindow) {
        this.failsafeSlidingWindowDurationMs = failsafeSlidingWindowDurationMs;
        this.failsafeMaxReportCountPerSlidingWindow = failsafeMaxReportCountPerSlidingWindow;
    }

    public void handle(Throwable t) {
        logger.catching(t);
        try {
            this.processThrowableVerbose(t);
        }
        catch (Exception e) {
            logger.catchingSilent(e);
        }
    }

    private static void displayUnitLockedException(UnitLockedException e) {
        UI.warn("Please wait, an analysis is taking placing in the background...");
    }

    public void processThrowableVerbose(Throwable t) {
        this.processThrowable(t, true, false, false, null, null, null);
    }

    public void processThrowableSilent(Throwable t) {
        this.processThrowable(t, false, false, false, null, null, null);
    }

    public void processThrowable(Throwable t, boolean verbose, boolean forceUpload, boolean doNotUploadSample, String details, Map<String, Object> extramap, IUnit faultyUnit) {
        File prjFile;
        long ts;
        long delta;
        if (t instanceof UnitLockedException) {
            RcpErrorHandler.displayUnitLockedException((UnitLockedException)t);
            return;
        }
        long currentTs = System.currentTimeMillis();
        this.errorTimestamps.add(currentTs);
        if (this.failsafeMaxReportCountPerSlidingWindow > 0 && this.failsafeSlidingWindowDurationMs > 0L && this.errorTimestamps.size() > this.failsafeMaxReportCountPerSlidingWindow && (delta = currentTs - (ts = this.errorTimestamps.get(this.errorTimestamps.size() - this.failsafeMaxReportCountPerSlidingWindow - 1).longValue())) <= this.failsafeSlidingWindowDurationMs) {
            logger.debug("Error report not generated, too many exceptions are being reported", new Object[0]);
            return;
        }
        Throwable t0 = Throwables.getRootCause(t);
        boolean done = false;
        if (t0 instanceof Error) {
            if (verbose) {
                StringBuilder msg = new StringBuilder();
                Strings.ff(msg, "%s. %s.", S.s(795), S.s(323));
                Strings.ff(msg, "\n\n%s: %s", S.s(304), t0);
                UI.error(msg.toString());
            }
            logger.catching(t);
            done = true;
        } else if (t0 instanceof SWTException) {
            if (Licensing.isReleaseBuild()) {
                verbose = false;
            }
        } else if (t0 instanceof UnitLockedException) {
            RcpErrorHandler.displayUnitLockedException((UnitLockedException)t0);
            done = true;
        }
        if (done) {
            return;
        }
        ErrorLogGenerator log = new ErrorLogGenerator(t);
        if (extramap == null || !extramap.containsKey("urlencoded-threads")) {
            log.addRecord("urlencoded-threads", ErrorLogGenerator.generateUrlencodedThreadsRecordValue());
        }
        if (this.ctx.getEnginesContext() != null) {
            log.recordEnginesInformation(this.ctx.getEnginesContext());
        }
        log.addRecord("verbose", verbose);
        log.addRecord("uptime", this.ctx.getUpTimeInSeconds());
        log.addRecord("activetime", this.ctx.getActiveTimeInSeconds());
        if (this.ctx.isJustUpdated()) {
            log.addRecord("updated", true);
        }
        if (this.ctx.isIntegrityFailed()) {
            log.addRecord("icfail", true);
        }
        IRuntimeProject prj = this.ctx.getOpenedProject();
        String prjReloaded = "unknown";
        if (prj != null) {
            prjReloaded = Boolean.toString(prj.isReloaded());
        }
        log.addRecord("project-reloaded", prjReloaded);
        InputCollector prjInputCollector = new InputCollector("project");
        if (this.ctx.getLastReloadedProjectPath() != null && (prjFile = new File(this.ctx.getLastReloadedProjectPath())).exists() && prjFile.canRead()) {
            try {
                FileInput input = new FileInput(prjFile);
                prjInputCollector.add(input);
            }
            catch (IOException iOException) {}
        }
        prjInputCollector.generate(log);
        InputCollector artInputCollector = new InputCollector("artifacts");
        if (prj != null) {
            Boolean.toString(prj.isReloaded());
            for (ILiveArtifact a : prj.getLiveArtifacts()) {
                IInput input = a.getArtifact().getInput();
                artInputCollector.add(input);
            }
        }
        artInputCollector.generate(log, false, true);
        if (extramap != null && extramap.get(EM_KEY_PROBLEMATIC_FILEPATH) instanceof String) {
            String path = (String)extramap.get(EM_KEY_PROBLEMATIC_FILEPATH);
            try {
                FileInput input = new FileInput(path);
                InputCollector pbmInputCollector = new InputCollector("problematic");
                pbmInputCollector.add(input);
                pbmInputCollector.generate(log);
            }
            catch (IOException iOException) {}
        }
        IPropertyManager pm = this.ctx.getPropertyManager();
        boolean cfgUploadErrorLogs = Booleans.toBoolean(pm.getBoolean(".UploadErrorLogs"));
        boolean cfgUploadErrorFiles = Booleans.toBoolean(pm.getBoolean(".UploadErrorFiles"));
        log.addRecord("up-set", Strings.ff("%b;%b", cfgUploadErrorLogs, cfgUploadErrorFiles));
        if (details != null) {
            log.addRecord("details", details);
        }
        ArrayList<String> keysForLoghash = new ArrayList<String>();
        keysForLoghash.add("stacktrace");
        if (extramap != null) {
            for (String key : extramap.keySet()) {
                if (key == null || EM_SPECIAL_KEYS.contains(key)) continue;
                Object value = extramap.get(key);
                log.addRecord(key, value);
                keysForLoghash.add(key);
            }
        }
        if (faultyUnit != null) {
            try {
                log.addRecord("unit-path", UnitUtil.buildFullyQualifiedUnitPath(faultyUnit));
                log.addRecord("unit-type", faultyUnit.getFormatType());
                keysForLoghash.add("unit-path");
            }
            catch (Exception exception) {
                log.addRecord("unit_info_Gen_error", "Cannot generate unit information");
            }
        }
        keysForLoghash.sort(null);
        String partialLog = log.getLog(keysForLoghash, false);
        String loghash = Formatter.byteArrayToHexString(Hash.calculateSHA256(Strings.encodeUTF8(partialLog)));
        if (!this.sentLoghashSet.add(loghash)) {
            return;
        }
        if (Licensing.isFullBuild()) {
            forceUpload = false;
        }
        boolean uploadErrorLogs = !Licensing.isDebugBuild() && (forceUpload || cfgUploadErrorLogs || Licensing.isDemoBuild());
        boolean uploadErrorFiles = uploadErrorLogs && !doNotUploadSample && (forceUpload || cfgUploadErrorFiles || Licensing.isDemoBuild());
        Net net = new Net(this.ctx.getNetworkUtility());
        List<IArtifact> artifacts = prj == null ? Collections.emptyList() : prj.getLiveArtifacts().stream().map(la -> la.getArtifact()).collect(Collectors.toList());
        RcpErrorUpRoutine uploader = new RcpErrorUpRoutine(net, log, extramap, uploadErrorLogs, uploadErrorFiles, artifacts, verbose);
        uploader.setReloadedProjectFile(this.ctx.getLastReloadedProjectFile());
        uploader.setDumpLogPolicy(this.ctx.isDevelopmentMode() || Licensing.isDebugBuild() ? 2 : 1);
        uploader.setDumpLogFolder(new File(this.ctx.getBaseDirectory(), "errorlogs"));
        ThreadUtil.start(Licensing.isDebugBuild() ? "UploadError" : null, uploader);
    }

    static {
        EM_SPECIAL_KEYS.add(EM_KEY_PROBLEMATIC_FILEPATH);
        logger = GlobalLog.getLogger(RcpErrorHandler.class);
    }

    static class InputCollector {
        String keyBasename;
        List<String> sha256List = new ArrayList<String>();
        List<Long> filesizeList = new ArrayList<Long>();
        List<String> headerList = new ArrayList<String>();

        InputCollector(String keyBasename) {
            if (keyBasename == null) {
                throw new RuntimeException();
            }
            this.keyBasename = keyBasename;
        }

        void add(IInput input) {
            try (InputStream in = input.getStream();){
                HashCalculator h = new HashCalculator(in, 16);
                if (h.compute()) {
                    this.sha256List.add(Formatter.byteArrayToHexString(h.getSha256()));
                    this.filesizeList.add(input.getCurrentSize());
                    Object hdrstr = "";
                    ByteBuffer hdr = input.getHeader();
                    if (hdr != null) {
                        int len = Math.min(16, hdr.remaining());
                        byte[] bytes = new byte[len];
                        hdr.get(bytes);
                        hdrstr = "'" + Formatter.escapeBytes(bytes) + "'";
                    }
                    this.headerList.add((String)hdrstr);
                }
            }
            catch (IOException iOException) {}
        }

        void generate(ErrorLogGenerator log) {
            this.generate(log, false, false);
        }

        void generate(ErrorLogGenerator log, boolean forceGen, boolean forceList) {
            if (this.sha256List.size() >= 2 || forceList) {
                log.addRecord(this.keyBasename + "-sha256-list", Strings.join(",", this.sha256List));
                log.addRecord(this.keyBasename + "-filesize-list", Strings.join(",", this.filesizeList));
                log.addRecord(this.keyBasename + "-header-list", Strings.join(",", this.headerList));
            } else if (this.sha256List.size() == 1) {
                log.addRecord(this.keyBasename + "-sha256", this.sha256List.get(0));
                log.addRecord(this.keyBasename + "-filesize", this.filesizeList.get(0));
                log.addRecord(this.keyBasename + "-header", this.headerList.get(0));
            } else if (forceGen) {
                log.addRecord(this.keyBasename + "-sha256", "");
                log.addRecord(this.keyBasename + "-filesize", -1);
                log.addRecord(this.keyBasename + "-header", "");
            }
        }
    }
}

