/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.api.ButtonGroupType;
import com.pnfsoftware.jeb.client.api.FormEntry;
import com.pnfsoftware.jeb.client.api.GraphDialogExtensions;
import com.pnfsoftware.jeb.client.api.IGraphicalClientContext;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.client.api.IUnitFragmentPositionChangeListener;
import com.pnfsoftware.jeb.client.api.IconType;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.FormDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.GraphDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.InputDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class PublicContext
implements IGraphicalClientContext {
    private static final ILogger logger = GlobalLog.getLogger(PublicContext.class);
    RcpClientContext ctx;

    public PublicContext(RcpClientContext ctx) {
        this.ctx = ctx;
    }

    public RcpClientContext getContext() {
        return this.ctx;
    }

    @Override
    public String[] getArguments() {
        return this.ctx.getArguments();
    }

    @Override
    public String getBaseDirectory() {
        return this.ctx.getBaseDirectory();
    }

    @Override
    public String getProgramDirectory() {
        return this.ctx.getProgramDirectory();
    }

    @Override
    public Version getSoftwareVersion() {
        return new Version(RcpClientContext.app_ver);
    }

    @Override
    public long getUsedMemory() {
        return this.ctx.getUsedMemory();
    }

    @Override
    public long getMaxMemory() {
        return this.ctx.getMaxMemory();
    }

    @Override
    public long getProcessId() {
        return this.ctx.getProcessId();
    }

    @Override
    public IEnginesContext getEnginesContext() {
        return this.ctx.getEnginesContext();
    }

    @Override
    public IRuntimeProject getMainProject() {
        return this.ctx.getOpenedProject();
    }

    @Override
    public boolean closeMainProject() {
        return this.ctx.attemptCloseOpenedProject(null);
    }

    @Override
    public IUnit open(String path) throws IOException {
        Shell shell = this.ctx.getActiveShell();
        if (!this.ctx.hasOpenedProject()) {
            this.ctx.loadInputAsProject(shell, path);
            return this.ctx.getOpenedProject().getLiveArtifact(0).getMainUnit();
        }
        ILiveArtifact a = this.ctx.loadInputAsAdditionalArtifact(shell, path);
        if (a == null) {
            return null;
        }
        return a.getMainUnit();
    }

    @Override
    public String displayFileOpenSelector(String caption) {
        FileDialog dlg = new FileDialog(UI.getShellTracker().get(), 4096);
        dlg.setText(Strings.safe(caption, "Open a file..."));
        return dlg.open();
    }

    @Override
    public String displayFileSaveSelector(String caption) {
        FileDialog dlg = new FileDialog(UI.getShellTracker().get(), 8192);
        dlg.setText(Strings.safe(caption, "Save to file..."));
        return dlg.open();
    }

    @Override
    public String displayFolderSelector(String caption) {
        DirectoryDialog dlg = new DirectoryDialog(UI.getShellTracker().get());
        dlg.setText(Strings.safe(caption, "Select a folder..."));
        return dlg.open();
    }

    @Override
    public String displayQuestionBox(String caption, String message, String defaultValue) {
        InputDialog dlg = new InputDialog(UI.getShellTracker().get(), caption, defaultValue);
        dlg.setMessage(message);
        String value = dlg.open();
        return value;
    }

    @Override
    public String[] displaySimpleForm(String caption, String description, String ... entries) {
        if (entries.length == 0) {
            throw new IllegalArgumentException("No form entries");
        }
        if (entries.length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of entries; must be [header1, defValue1, header2, defValue2, ...]");
        }
        FormEntry[] fentries = new FormEntry[entries.length / 2];
        int j = 0;
        for (int i = 0; i < entries.length; i += 2) {
            FormEntry.Text fe = new FormEntry.Text();
            fe.header = entries[i];
            fe.defaultValue = entries[i + 1];
            fentries[j++] = fe;
        }
        Object[] r = this.displayForm(caption, description, fentries);
        if (r == null) {
            return null;
        }
        return (String[])r;
    }

    @Override
    public Object[] displayForm(String caption, String description, FormEntry<?> ... entries) {
        if (entries.length == 0) {
            throw new IllegalArgumentException("No form entries");
        }
        FormDialog dlg = new FormDialog(UI.getShellTracker().get(), caption, description);
        for (FormEntry<?> _e : entries) {
            if (_e == null || !(_e instanceof FormEntry.Text)) {
                throw new IllegalArgumentException("Unexpected form entry");
            }
            FormEntry.Text e = (FormEntry.Text)_e;
            dlg.addTextInput(e.header, (String)e.defaultValue, e.flags, e.minColumnCount, e.minLineCount, e.validator);
        }
        Object[] r = dlg.open();
        return r;
    }

    @Override
    public int displayMessageBox(String caption, String message, IconType iconType, ButtonGroupType bgType) {
        if (caption == null) {
            caption = "";
        }
        if (message == null) {
            message = "";
        }
        if (iconType == null) {
            iconType = IconType.INFORMATION;
        }
        if (bgType == null) {
            bgType = ButtonGroupType.OK;
        }
        int flags = 0;
        switch (iconType) {
            case QUESTION: {
                flags |= 4;
                break;
            }
            case INFORMATION: {
                flags |= 2;
                break;
            }
            case WARNING: {
                flags |= 8;
                break;
            }
            case ERROR: {
                flags |= 1;
            }
        }
        switch (bgType) {
            case OK: {
                flags |= 0x20;
                break;
            }
            case OK_CANCEL: {
                flags |= 0x120;
                break;
            }
            case YES_NO: {
                flags |= 0xC0;
                break;
            }
            case YES_NO_CANCEL: {
                flags |= 0x1C0;
            }
        }
        MessageBox dlg = new MessageBox(UI.getShellTracker().get(), flags);
        dlg.setText(caption);
        dlg.setMessage(message);
        int r = dlg.open();
        switch (r) {
            case 256: {
                return 0;
            }
            case 32: {
                return 1;
            }
            case 64: {
                return 2;
            }
            case 128: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public String displayText(String caption, String text, boolean editable) {
        String[] lines;
        int maxcolcnt = 0;
        for (String line : lines = Strings.splitLines(text)) {
            if (line.length() <= maxcolcnt) continue;
            maxcolcnt = line.length();
        }
        int rowcnt = Math.min(Math.max(10, lines.length), 40);
        int colcnt = Math.min(Math.max(40, maxcolcnt), 80);
        TextDialog dlg = new TextDialog(UI.getShellTracker().get(), caption, text, null);
        dlg.setEditable(editable);
        dlg.setFont(this.ctx.getFontManager().getCodeFont());
        dlg.setColumnCount(colcnt);
        dlg.setLineCount(rowcnt);
        return dlg.open();
    }

    @Override
    public int displayList(String caption, String message, String[] headers, Object[][] rows) {
        DataFrameDialog dlg = new DataFrameDialog(UI.getShellTracker().get(), caption, true, null);
        dlg.setDisplayIndex(true);
        dlg.setMessage(message);
        DataFrame df = new DataFrame(headers);
        for (Object[] row : rows) {
            df.addRow(row);
        }
        dlg.setDataFrame(df);
        int sel = dlg.open();
        return sel;
    }

    @Override
    public void executeAsync(String taskName, Runnable runnable) throws InterruptedException, InvocationTargetException {
        Shell shell = this.ctx.getActiveShell();
        UI.getTaskManager().create(shell, taskName, runnable, 0L);
    }

    @Override
    public <T> T executeAsyncWithReturn(String taskName, Callable<T> callable) throws InterruptedException, InvocationTargetException {
        Shell shell = this.ctx.getActiveShell();
        return UI.getTaskManager().create(shell, taskName, callable, 0L);
    }

    @Override
    public void uiExecute(Runnable runnable) {
        UI.getDisplay().asyncExec(runnable);
    }

    @Override
    public void uiExecuteBlocking(Runnable runnable) {
        UI.getDisplay().syncExec(runnable);
    }

    @Override
    public void uiExecuteWithDelay(int delay, Runnable runnable) {
        UI.getDisplay().timerExec(delay, runnable);
    }

    @Override
    public void registerUnitFragmentPositionChangeListener(IUnitFragmentPositionChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.ctx.registerUnitFragmentPositionChangeListener(listener);
    }

    @Override
    public void unregisterUnitFragmentPositionChangeListener(IUnitFragmentPositionChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.ctx.unregisterUnitFragmentPositionChangeListener(listener);
    }

    public List<UnitPartManager> getViews() {
        return this.getViews(null);
    }

    public List<UnitPartManager> getViews(IUnit targetUnit) {
        ArrayList<UnitPartManager> r = new ArrayList<UnitPartManager>();
        PartManager pman = this.ctx.getPartManager();
        for (IMPart part : pman.getUnitParts()) {
            IUnit unit;
            UnitPartManager unitPart = pman.getUnitPartManager(part);
            if (unitPart == null || (unit = unitPart.getUnit()) == null || targetUnit != null && targetUnit != unit) continue;
            r.add(unitPart);
        }
        return r;
    }

    @Override
    public UnitPartManager getFocusedView() {
        PartManager pman = this.ctx.getPartManager();
        IMPart part = pman.getActivePart();
        if (part != null && PartManager.isUnitPart(part)) {
            return pman.getUnitPartManager(part);
        }
        part = pman.getLastFocusedUnitPart();
        if (part != null) {
            return pman.getUnitPartManager(part);
        }
        return null;
    }

    @Override
    public boolean openView(IUnit unit) {
        List<IMPart> r = this.ctx.getPartManager().create(unit, true);
        return r != null && !r.isEmpty();
    }

    @Override
    public IUnitFragment findFragment(IUnit unit, String label, boolean focus) {
        List<UnitPartManager> views = this.getViews(unit);
        for (UnitPartManager pman : views) {
            AbstractUnitFragment<?> f = pman.getFragmentByName(label);
            if (f == null) continue;
            pman.requestActivation(focus);
            pman.setActiveFragment(f, focus);
            return f;
        }
        return null;
    }

    @Override
    public Map<Object, Object> getTransientStore() {
        return this.ctx.getTransientStore();
    }

    @Override
    public void displayGraph(String caption, Digraph model, GraphDialogExtensions ext) {
        Shell shell = this.ctx.getMainShell();
        if (shell == null) {
            return;
        }
        GraphDialog dlg = new GraphDialog(shell, Strings.safe(caption, "Graph"), this.ctx, true);
        dlg.setModel(model);
        dlg.setExtensions(ext);
        dlg.open();
    }

    @Override
    public boolean navigate(IUnit unit, String unitAddress) {
        if (unit == null) {
            return false;
        }
        return GraphicalActionExecutor.gotoAddress(this.ctx, unit, unitAddress);
    }
}

