/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class PDMHelpGenerator {
    private static final String jebDevBaseNico = new File(System.getProperty("user.home"), "jeb2" + File.separator + "jeb3-rcpclient").getAbsolutePath();
    private IPropertyDefinitionManager pdm0;
    private String header;
    private String footer;
    private File outfile;
    private TextBuilder b;

    public PDMHelpGenerator(IPropertyDefinitionManager pdm) {
        this.pdm0 = pdm;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public void setOuputFile(File outfile) {
        this.outfile = outfile;
    }

    public String generate() throws IOException {
        this.b = new TextBuilder(2);
        if (this.header != null) {
            this.b.append(this.header);
        }
        this.genInternal(this.pdm0);
        if (this.footer != null) {
            this.b.append(this.footer);
        }
        if (this.outfile != null) {
            IO.writeFile(this.outfile, this.b.toString());
        }
        return this.b.toString();
    }

    private void genInternal(IPropertyDefinitionManager pdm) {
        ArrayList<IPropertyDefinition> defs = new ArrayList<IPropertyDefinition>(pdm.getDefinitions());
        Collections.sort(defs, new Comparator<IPropertyDefinition>(){

            @Override
            public int compare(IPropertyDefinition x, IPropertyDefinition y) {
                return x.getName().compareTo(y.getName());
            }
        });
        for (IPropertyDefinition def : defs) {
            if (def.isInternal()) continue;
            this.b.append("<hr>\n");
            String propfqn = pdm.getNamespace() + "." + def.getName();
            this.b.append("### `%s`\n", this.mdEscape(propfqn));
            String desc = def.getDescription();
            desc = Strings.isBlank(desc) ? "N/A" : desc.replace("\n", "\n\n");
            this.b.append("**Description**: %s\n\n", this.mdEscape(desc));
            String t = def.getType().toString();
            t = t.replace(jebDevBaseNico, "$JEB_HOME").replace("\\", "/");
            this.b.append("**Type and Default**: %s\n\n", this.mdEscape(t));
            this.b.appendLine();
        }
        ArrayList<IPropertyDefinitionManager> children = new ArrayList<IPropertyDefinitionManager>(pdm.getChildren());
        Collections.sort(children, new Comparator<IPropertyDefinitionManager>(){

            @Override
            public int compare(IPropertyDefinitionManager x, IPropertyDefinitionManager y) {
                return x.getRegion().compareTo(y.getRegion());
            }
        });
        for (IPropertyDefinitionManager child : children) {
            this.genInternal(child);
        }
    }

    String mdEscape(String s) {
        char[] clist;
        for (char c : clist = new char[]{'\\', '`', '*', '{', '}', '[', ']', '#', '+', '!', '~'}) {
            s = s.replace("" + c, "\\" + c);
        }
        return s;
    }
}

