/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.parts.units.Position;
import com.pnfsoftware.jeb.util.format.Strings;
import java.lang.ref.WeakReference;

public class GlobalPosition {
    private WeakReference<IUnit> unitRef;
    private int partId;
    private long fragmentId;
    private Position position;

    public GlobalPosition(IUnit unit, int partId, long fragmentId, Position position) {
        this.unitRef = new WeakReference<IUnit>(unit);
        this.partId = partId;
        this.fragmentId = fragmentId;
        this.position = position;
    }

    public IUnit getUnit() {
        return (IUnit)this.unitRef.get();
    }

    public int getPartId() {
        return this.partId;
    }

    public long getFragmentId() {
        return this.fragmentId;
    }

    public Position getPosition() {
        return this.position;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fragmentId ^ this.fragmentId >>> 32);
        result = 31 * result + this.partId;
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.unitRef == null ? 0 : this.unitRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalPosition other = (GlobalPosition)obj;
        if (this.fragmentId != other.fragmentId) {
            return false;
        }
        if (this.partId != other.partId) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        if (this.unitRef == null && other.unitRef != null) {
            return false;
        }
        return this.unitRef.get() == other.unitRef.get();
    }

    public String toString() {
        return Strings.ff("%s @ %s", this.unitRef.get(), this.position);
    }
}

