/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.core.IArtifact;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.events.AbstractQuestionNotification;
import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.ExceptionNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.QuestionNotificationPath;
import com.pnfsoftware.jeb.core.events.QuestionNotificationYesNo;
import com.pnfsoftware.jeb.core.events.TelemetryNotification;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitInterpreter;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.DebuggerListener;
import com.pnfsoftware.jeb.rcpclient.DecompilerListener;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.PathDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.parts.MultiInterpreter;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.collect.ItemHistory;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.events.IEventSource;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnginesListener
implements IEventListener {
    private static final ILogger logger = GlobalLog.getLogger(EnginesListener.class);
    private static EnginesListener instance;
    private RcpClientContext context;
    private WeakIdentityHashMap<IUnit, Integer> interpreterIds = new WeakIdentityHashMap();

    public static synchronized EnginesListener initialize(RcpClientContext context, IEnginesContext engctx) {
        if (instance != null) {
            throw new RuntimeException("The context's engines listener was already initialized");
        }
        instance = new EnginesListener(context);
        engctx.addListener(instance);
        return instance;
    }

    private EnginesListener(RcpClientContext context) {
        this.context = context;
    }

    @Override
    public void onEvent(IEvent e) {
        if (!(e instanceof JebEvent)) {
            return;
        }
        J type = ((JebEvent)e).getType();
        if (type == J.ContextInitialized) {
            Object[] cfr_ignored_0 = new Object[0];
        } else if (type == J.UnitStatusChanged) {
            JebEvent event = (JebEvent)e;
            IUnit unit = (IUnit)event.getSource();
            logger.debug("Unit \"%s\" status has changed to: %s", unit.getName(), unit.getStatus());
        } else if (type == J.UnitCreated) {
            MultiInterpreter mi;
            int interpreterIndex;
            JebEvent event = (JebEvent)e;
            IUnit unit = (IUnit)event.getData();
            logger.debug("Unit \"%s\" (%s) was created", unit.getName(), unit.getFormatType());
            if (UnitUtil.isTopLevelUnit(unit)) {
                IArtifact a = (IArtifact)unit.getParent();
                long artifactSize = a.getInput() == null ? 0L : a.getInput().getCurrentSize();
                this.context.getTelemetry().record("topLevelUnitCreated", "unitType", unit.getFormatType(), "artifactSize", "" + artifactSize);
            }
            if (unit instanceof IDebuggerUnit) {
                IDebuggerUnit dbg = (IDebuggerUnit)unit;
                DebuggerListener.listenTo(dbg, this.context);
            } else if (unit instanceof IDecompilerUnit) {
                IDecompilerUnit decomp = (IDecompilerUnit)unit;
                DecompilerListener.listenTo(decomp, this.context);
            }
            List<IUnitInterpreter> interpreters = unit.getInterpreters();
            if (interpreters != null && !interpreters.isEmpty() && (interpreterIndex = (mi = this.context.getMasterInterpreter()).registerInterpreter(interpreters.get(0))) >= 0) {
                this.interpreterIds.put(unit, interpreterIndex);
                logger.info("A command interpreter for unit \"%s\" was registered to the console view. Switch to it by issuing the \"use %d\" command", unit.getName(), interpreterIndex);
            }
        } else if (type == J.UnitDestroyed) {
            JebEvent event = (JebEvent)e;
            final IUnit unit = (IUnit)event.getData();
            logger.debug("Unit \"%s\" was destroyed", unit.getName());
            Integer interpreterIndex = this.interpreterIds.get(unit);
            if (interpreterIndex != null) {
                MultiInterpreter mi = this.context.getMasterInterpreter();
                mi.unregisterInterpreter(interpreterIndex);
                this.interpreterIds.remove(unit);
            }
            if (unit instanceof IDebuggerUnit) {
                IDebuggerUnit dbg = (IDebuggerUnit)unit;
                DebuggerListener.stopListening(dbg);
            } else if (unit instanceof IDecompilerUnit) {
                IDecompilerUnit decomp = (IDecompilerUnit)unit;
                DecompilerListener.stopListening(decomp);
            }
            UIExecutor.sync(this.context.getDisplay(), (Runnable)new UIRunnable(){

                @Override
                public void runi() {
                    PartManager pman = EnginesListener.this.context.getPartManager();
                    List<IMPart> parts = pman.getPartsForUnit(unit);
                    for (IMPart part : parts) {
                        pman.unbindUnitPart(part);
                    }
                    ItemHistory<GlobalPosition> history = EnginesListener.this.context.getPartManager().getGlobalPositionHistory();
                    List<GlobalPosition> globalPositionList = history.get();
                    if (!globalPositionList.isEmpty()) {
                        ArrayList<GlobalPosition> toRemove = new ArrayList<GlobalPosition>();
                        for (GlobalPosition pos : globalPositionList) {
                            if (pos.getUnit() != unit) continue;
                            toRemove.add(pos);
                        }
                        if (!toRemove.isEmpty()) {
                            for (GlobalPosition rem : toRemove) {
                                history.remove(rem);
                            }
                            EnginesListener.this.context.refreshHandlersStates();
                        }
                    }
                }
            });
        } else if (type == J.Notification) {
            if (!(e.getData() instanceof ClientNotification)) {
                return;
            }
            ClientNotification n = (ClientNotification)e.getData();
            EnginesListener.processNotification(this.context, e.getSource(), n);
        } else if (type == J.ProjectUnloaded) {
            UIExecutor.sync(this.context.getDisplay(), (Runnable)new UIRunnable(){

                @Override
                public void runi() {
                    EnginesListener.this.context.getViewManager().getGlobalPositionHistory().reset();
                    EnginesListener.this.context.refreshHandlersStates();
                }
            });
        }
    }

    static void processNotification(final RcpClientContext context, final IEventSource source, final ClientNotification notif) {
        if (notif instanceof AbstractQuestionNotification) {
            final AbstractQuestionNotification n = (AbstractQuestionNotification)notif;
            UIExecutor.sync(UI.getDisplay(), (Runnable)new UIRunnable(null, false){

                @Override
                public void runi() {
                    if (n instanceof QuestionNotificationYesNo) {
                        boolean r;
                        QuestionNotificationYesNo notif = (QuestionNotificationYesNo)n;
                        if (n.isAskDoNotShowAnymore()) {
                            AdaptivePopupDialog popup = AdaptivePopupDialog.question(UI.getDockShell(), "Question", n.getMessage());
                            popup.setDefaultButton((Boolean)notif.getResponse());
                            r = popup.open() == 1;
                            n.setDoNotShowAnymoreResponse(popup.isDoNotShow());
                        } else {
                            r = UI.question(null, "Question", n.getMessage());
                        }
                        notif.setResponse(r);
                    } else if (n instanceof QuestionNotificationPath) {
                        PathDialog.Type pt;
                        QuestionNotificationPath notif = (QuestionNotificationPath)n;
                        switch (notif.getPathType()) {
                            case SAVE_TO_FILE: {
                                pt = PathDialog.Type.SAVE_TO_FILE;
                                break;
                            }
                            case SELECT_FILE: {
                                pt = PathDialog.Type.SELECT_FILE;
                                break;
                            }
                            case SELECT_FOLDER: {
                                pt = PathDialog.Type.SELECT_FOLDER;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        PathDialog dlg = new PathDialog(UI.getShellTracker().get(), pt, notif.getMessage(), (String)notif.getDefaultResponse());
                        String path = dlg.open();
                        notif.setResponse(path);
                    } else {
                        return;
                    }
                }
            });
        } else {
            UIExecutor.async(UI.getDisplay(), new UIRunnable(){

                @Override
                public void runi() {
                    if (notif instanceof ExceptionNotification) {
                        Throwable t = ((ExceptionNotification)notif).getThrowable();
                        if (t == null) {
                            return;
                        }
                        int flags = ((ExceptionNotification)notif).getFlags();
                        boolean silent = (flags & 1) != 0;
                        boolean forceUpload = (flags & 2) != 0;
                        boolean doNotUploadSample = (flags & 4) != 0;
                        Map<String, Object> extramap = ((ExceptionNotification)notif).getExtraData();
                        context.getErrorHandler().processThrowable(t, !silent, forceUpload, doNotUploadSample, null, extramap, null);
                    } else if (notif instanceof TelemetryNotification) {
                        TelemetryNotification tn = (TelemetryNotification)notif;
                        try {
                            context.getTelemetry().record(tn.getEventName(), tn.getProperties());
                        }
                        catch (Exception exception) {}
                    } else {
                        String msg = notif.getMessage();
                        msg = Strings.ff("Notification from: %s\n\nMessage: %s", source, msg);
                        int level = RcpClientContext.clientNotificationLevelToLoggerLevel(notif.getLevel());
                        UI.log(level, null, "Notification", msg);
                    }
                }
            });
        }
    }
}

