/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.LogDocument;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Document;

public class DecompilerListener {
    private static final ILogger logger = GlobalLog.getLogger(DecompilerListener.class);
    private static Map<IDecompilerUnit, DecompilerListener> map = new IdentityHashMap<IDecompilerUnit, DecompilerListener>();
    private int clientCount;
    private IDecompilerUnit decomp;
    private RcpClientContext context;
    private IEventListener listener;
    private LogDocument eventLog;
    private Map<ISourceUnit, Integer> resetMap = new IdentityHashMap<ISourceUnit, Integer>();

    public static synchronized DecompilerListener listenTo(IDecompilerUnit decomp, RcpClientContext context) {
        DecompilerListener listener = map.get(decomp);
        if (listener == null) {
            listener = new DecompilerListener(decomp, context);
            map.put(decomp, listener);
        }
        ++listener.clientCount;
        return listener;
    }

    public static synchronized boolean stopListening(IDecompilerUnit decomp) {
        DecompilerListener listener = map.get(decomp);
        if (listener == null) {
            return false;
        }
        --listener.clientCount;
        if (listener.clientCount <= 0) {
            listener.close();
            map.remove(decomp);
        }
        return true;
    }

    public static synchronized DecompilerListener get(IDecompilerUnit decomp) {
        return map.get(decomp);
    }

    public static synchronized List<DecompilerListener> getAll() {
        return new ArrayList<DecompilerListener>(map.values());
    }

    private DecompilerListener(IDecompilerUnit decomp, RcpClientContext context) {
        this.decomp = decomp;
        this.context = context;
        this.eventLog = new LogDocument(0x100000);
        this.listener = e -> this.onDebugEvent(e);
        decomp.addListener(this.listener);
    }

    public IDecompilerUnit getDecompiler() {
        return this.decomp;
    }

    public RcpClientContext getContext() {
        return this.context;
    }

    public Document getLog() {
        return this.eventLog;
    }

    private void close() {
        if (this.listener != null) {
            this.decomp.removeListener(this.listener);
        }
        this.pullResetUnits();
    }

    private void onDebugEvent(IEvent e) {
        if (e.getSource() != this.decomp) {
            return;
        }
        UIExecutor.async(() -> this.processEvent(e));
    }

    private void processEvent(IEvent e) {
        ISourceUnit srcUnit;
        Object addition = Strings.ff("%s", e.getType());
        if (e.getData() != null) {
            addition = (String)addition + Strings.ff(" / %s", e.getData());
        }
        addition = (String)addition + "\n";
        this.eventLog.append((String)addition);
        if (e.getType() == J.DecompClientNotification) {
            ClientNotification n = (ClientNotification)e.getData();
            String message = n.getMessage();
            int level = RcpClientContext.clientNotificationLevelToLoggerLevel(n.getLevel());
            UI.log(level, null, "Decompiler Notification", message);
        } else if (e.getType() == J.DecompSrcUnitResetEvent && (srcUnit = (ISourceUnit)e.getData()) != null) {
            (new Object[1])[0] = srcUnit;
            Map<ISourceUnit, Integer> map = this.resetMap;
            synchronized (map) {
                this.resetMap.put(srcUnit, null);
            }
        }
    }

    public List<ISourceUnit> pullResetUnits() {
        Map<ISourceUnit, Integer> map = this.resetMap;
        synchronized (map) {
            ArrayList<ISourceUnit> r = new ArrayList<ISourceUnit>(this.resetMap.keySet());
            this.resetMap.clear();
            return r;
        }
    }
}

