/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.core.events.ClientNotification;
import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitAddress;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.debug.DebuggerEventType;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerBreakpoint;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerEventData;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.LogDocument;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.TerminalPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UIState;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.Document;

public class DebuggerListener {
    private static final ILogger logger = GlobalLog.getLogger(DebuggerListener.class);
    private static WeakIdentityHashMap<IDebuggerUnit, DebuggerListener> map = new WeakIdentityHashMap();
    private int clientCount;
    private IDebuggerUnit dbg;
    private IRcpClientContext context;
    private IEventListener listener;
    private LogDocument eventLog;

    public static synchronized DebuggerListener listenTo(IDebuggerUnit dbg, IRcpClientContext context) {
        DebuggerListener listener = map.get(dbg);
        if (listener == null) {
            listener = new DebuggerListener(dbg, context);
            map.put(dbg, listener);
        }
        ++listener.clientCount;
        return listener;
    }

    public static synchronized boolean stopListening(IDebuggerUnit dbg) {
        DebuggerListener listener = map.get(dbg);
        if (listener == null) {
            return false;
        }
        --listener.clientCount;
        if (listener.clientCount <= 0) {
            listener.close();
            map.remove(dbg);
        }
        return true;
    }

    public static synchronized DebuggerListener get(IDebuggerUnit dbg) {
        return map.get(dbg);
    }

    private DebuggerListener(IDebuggerUnit dbg, IRcpClientContext context) {
        this.dbg = dbg;
        this.context = context;
        this.eventLog = new LogDocument(0x100000);
        this.listener = e -> this.onDebugEvent(e);
        dbg.addListener(this.listener);
    }

    public IDebuggerUnit getDebugger() {
        return this.dbg;
    }

    public IRcpClientContext getContext() {
        return this.context;
    }

    public Document getLog() {
        return this.eventLog;
    }

    private void close() {
        if (this.listener != null) {
            this.dbg.removeListener(this.listener);
        }
    }

    private void onDebugEvent(final IEvent e) {
        if (e.getSource() != this.dbg) {
            return;
        }
        UIExecutor.async(UI.getDisplay(), new UIRunnable(){

            @Override
            public void runi() {
                Object addition = Strings.ff("%s", e.getType());
                if (e.getData() != null) {
                    addition = (String)addition + Strings.ff(" / %s", e.getData());
                }
                addition = (String)addition + "\n";
                DebuggerListener.this.eventLog.append((String)addition);
                if (e.getType() == J.DbgClientNotification) {
                    ClientNotification n = (ClientNotification)e.getData();
                    String string = n.getMessage();
                    int n2 = RcpClientContext.clientNotificationLevelToLoggerLevel(n.getLevel());
                    UI.log(n2, null, "Debugger Notification", string);
                } else if (e.getType() == J.DbgAttach) {
                    for (ICodeUnit iCodeUnit : DebuggerListener.this.dbg.getPotentialDebuggees()) {
                        if (!(iCodeUnit instanceof INativeCodeUnit)) continue;
                        iCodeUnit.notifyListeners(new JebEvent(J.UnitChange));
                    }
                } else if (e.getType() == J.DbgDetach) {
                    for (ICodeUnit iCodeUnit : DebuggerListener.this.dbg.getPotentialDebuggees()) {
                        DebuggerListener.this.context.getUIState(iCodeUnit).setProgramCounter(null);
                        if (!(iCodeUnit instanceof INativeCodeUnit)) continue;
                        iCodeUnit.notifyListeners(new JebEvent(J.UnitChange));
                    }
                } else if (e.getType() == J.DbgRun) {
                    if (DebuggerListener.this.dbg != null) {
                        for (IUnit iUnit : DebuggerListener.this.dbg.getPotentialDebuggees()) {
                            DebuggerListener.this.context.getUIState(iUnit).setProgramCounter(null);
                        }
                    }
                } else if (e.getType() != J.DbgPause) {
                    if (e.getType() == J.DbgBreakpointSet || e.getType() == J.DbgBreakpointUnset) {
                        List<? extends IDebuggerBreakpoint> realBreakpoints = DebuggerListener.this.dbg.getBreakpoints();
                        if (realBreakpoints != null) {
                            for (IUnit iUnit : DebuggerListener.this.dbg.getPotentialDebuggees()) {
                                UIState uiState = DebuggerListener.this.context.getUIState(iUnit);
                                ArrayList<String> validAddresses = new ArrayList<String>();
                                for (IDebuggerBreakpoint iDebuggerBreakpoint : realBreakpoints) {
                                    String dbgAddress = iDebuggerBreakpoint.getAddress();
                                    UnitAddress<ICodeUnit> ua = DebuggerListener.this.dbg.convertToUnitAddress(dbgAddress);
                                    if (ua == null || ua.getUnit() != iUnit) continue;
                                    String addr = ua.getAddress();
                                    validAddresses.add(addr);
                                    if (uiState.isBreakpoint(addr) && uiState.isBreakpointEnabled(addr) == iDebuggerBreakpoint.isEnabled()) continue;
                                    uiState.setBreakpoint(addr, iDebuggerBreakpoint.isEnabled());
                                }
                                ArrayList<String> invalidAddresses = new ArrayList<String>();
                                for (String address : uiState.getBreakpoints().keySet()) {
                                    if (validAddresses.contains(address)) continue;
                                    invalidAddresses.add(address);
                                }
                                for (String address : invalidAddresses) {
                                    uiState.removeBreakpoint(address);
                                }
                            }
                        }
                    } else if (e.getType() == J.DbgTargetEvent && e.getData() instanceof IDebuggerEventData) {
                        PartManager pman;
                        IMPart activePart;
                        IDebuggerBreakpoint bp;
                        UIState uiState;
                        String targetAddress;
                        IDebuggerEventData data = (IDebuggerEventData)e.getData();
                        UnitAddress<ICodeUnit> unitAddress = data.getUnitAddress();
                        ICodeUnit iCodeUnit = unitAddress == null ? null : unitAddress.getUnit();
                        String string = targetAddress = unitAddress == null ? null : unitAddress.getAddress();
                        if (iCodeUnit == null || targetAddress == null) {
                            logger.debug("Target unit/address associated with the debuggee event cannot be determined; dbgdata= %s", data);
                            DebuggerListener.this.context.refreshHandlersStates();
                            return;
                        }
                        if (iCodeUnit instanceof ICodeUnit && (uiState = DebuggerListener.this.context.getUIState(iCodeUnit)).isTemporaryBreakpoint(targetAddress) && uiState.removeTemporaryBreakpoint(targetAddress) && (bp = DebuggerListener.this.dbg.getBreakpoint(targetAddress, iCodeUnit)) != null) {
                            DebuggerListener.this.dbg.clearBreakpoint(bp);
                        }
                        if (data.getThreadId() != 0L) {
                            DebuggerListener.this.dbg.setDefaultThread(data.getThreadId());
                        }
                        IMPartManager iMPartManager = (activePart = (pman = DebuggerListener.this.context.getPartManager()).getActivePart()) == null ? null : activePart.getManager();
                        pman.create(iCodeUnit, true);
                        int focusedCount = 0;
                        for (UnitPartManager o : pman.getPartManagersForUnit(iCodeUnit)) {
                            IUnitFragment fragment = o.getActiveFragment();
                            if (fragment == null) continue;
                            (new Object[1])[0] = targetAddress;
                            if (!fragment.setActiveAddress(targetAddress)) continue;
                            o.requestFocus();
                            ++focusedCount;
                        }
                        if (iMPartManager instanceof TerminalPartManager) {
                            TerminalPartManager consolePart = (TerminalPartManager)iMPartManager;
                            consolePart.requestFocus();
                        }
                        if (focusedCount == 0) {
                            if (data.getType() == DebuggerEventType.EXCEPTION || data.getType() == DebuggerEventType.SIGNAL) {
                                UI.warn(null, "Event generated by debugged target", "An exception occurred in unreachable code. The process was paused at:\n\n" + targetAddress);
                            } else {
                                UI.warn(null, "Event generated by debugged target", "The following address cannot be navigated to:\n\n" + targetAddress);
                            }
                        } else {
                            DebuggerListener.this.context.getUIState(iCodeUnit).setProgramCounter(targetAddress);
                        }
                        ((JebEvent)e).setStopPropagation(true);
                    }
                }
                DebuggerListener.this.context.refreshHandlersStates();
            }
        });
    }
}

