/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.api.IUnitFragmentPositionChangeListener;
import com.pnfsoftware.jeb.client.api.UnitFragmentPosition;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionDecompileHandler;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class AutoDecompiler
implements IUnitFragmentPositionChangeListener {
    private static final ILogger logger = GlobalLog.getLogger(AutoDecompiler.class);
    private RcpClientContext context;
    private boolean decompiling;
    private IUnit lastUnit;
    private String lastAddress;

    public AutoDecompiler(RcpClientContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
        context.registerUnitFragmentPositionChangeListener(this);
    }

    @Override
    public void onUpdate(UnitFragmentPosition e) {
        if (this.decompiling) {
            return;
        }
        if (e == null || e.getFragment() == null) {
            if (this.lastUnit != null && this.lastUnit.isDisposed()) {
                this.lastUnit = null;
                this.lastAddress = null;
            }
            return;
        }
        IUnit unit = e.getUnit();
        if (unit == null || !(unit instanceof ICodeUnit)) {
            return;
        }
        ICodeUnit c = (ICodeUnit)unit;
        if (!(c instanceof IDexUnit)) {
            return;
        }
        String addr = e.getAddress();
        if (addr == null) {
            return;
        }
        if (unit == this.lastUnit && addr.equals(this.lastAddress)) {
            return;
        }
        if (!DecompilerHelper.hasDecompilerFor(c)) {
            return;
        }
        PartManager pman = this.context.getPartManager();
        IMPart part = pman.getActivePart();
        if (part == null) {
            return;
        }
        if (pman.getUnitForPart(part) != unit) {
            return;
        }
        if (!this.context.getUiProperties().getAutoDecompileCode()) {
            return;
        }
        this.decompiling = true;
        try {
            if (ActionDecompileHandler.execute(this.context, this.context.getActiveShell(), part, addr, false, false)) {
                this.lastUnit = unit;
                this.lastAddress = addr;
            }
        }
        finally {
            this.decompiling = false;
        }
    }
}

