/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.api.IUnitFragment;
import com.pnfsoftware.jeb.client.jebio.JebIoApiHelper;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexClass;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexField;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeSourceUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeClassItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeFieldItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.java.IJavaClass;
import com.pnfsoftware.jeb.core.units.code.java.IJavaMethod;
import com.pnfsoftware.jeb.core.units.code.java.IJavaSourceUnit;
import com.pnfsoftware.jeb.core.units.code.java.JavaOutputSink;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.AssistantRenamerDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.encoding.json.parser.JSONParser;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.net.Net;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class Assistant {
    private static final ILogger logger = GlobalLog.getLogger(Assistant.class);
    private static final int MAX_DECOMP_SOURCE_LENGTH = 10000;
    private static final int MAX_REQUEST_FREQUENCY = 2;
    private static final Set<String> dexDNRMethodSet = new HashSet<String>(Arrays.asList("<init>", "<clinit>", "hashCode", "equals", "toString"));
    private IRcpClientContext ctx;

    public Assistant(IRcpClientContext ctx) {
        this.ctx = ctx;
    }

    public boolean checkLimitations(IUnit unit) {
        return unit instanceof ISourceUnit;
    }

    public boolean request() {
        UnitPartManager pman;
        IUnit unit = null;
        IUnitFragment fragment = null;
        IItem item = null;
        String addr = null;
        IMPart part = this.ctx.getPartManager().getActivePart();
        if (part != null && PartManager.isUnitPart(part) && (fragment = (pman = (UnitPartManager)part.getManager()).getActiveFragment()) != null) {
            item = fragment.getActiveItem();
            addr = fragment.getActiveAddress();
        }
        return this.request(unit, fragment, item, addr);
    }

    public boolean request(IUnit unit, IUnitFragment fragment, IItem item, String address) {
        if (!this.checkLimitations(unit)) {
            return false;
        }
        try {
            return this.requestInternal(unit, fragment, item, address);
        }
        catch (Exception e) {
            this.ctx.getErrorHandler().processThrowableSilent(e);
            return false;
        }
    }

    public boolean requestInternal(IUnit unit, IUnitFragment fragment, IItem item, String address) {
        int rencnt;
        String decompstr;
        ISourceUnit srcUnit;
        block39: {
            Response r;
            List<String> decompilables;
            int qtype;
            AssistantRenamerDialog dlg;
            block37: {
                String newname;
                ICodeItem codeitem;
                block38: {
                    int lastReqTs;
                    dlg = JebDialog.getInstance(AssistantRenamerDialog.class);
                    if (dlg != null) {
                        dlg.setFocus();
                        return false;
                    }
                    this.incrStatCounter(".ui.assistant.RunCount1");
                    if (!(unit instanceof ISourceUnit)) {
                        return false;
                    }
                    srcUnit = (ISourceUnit)unit;
                    qtype = 0;
                    codeitem = null;
                    decompilables = null;
                    ITextDocument doc = srcUnit.getSourceDocument();
                    try {
                        ITextDocumentPart part = doc.getDocumentPart(doc.getFirstAnchor(), Integer.MAX_VALUE);
                        if (part instanceof JavaOutputSink) {
                            decompilables = ((JavaOutputSink)part).getDecompilables();
                        }
                        decompstr = TextPartUtil.buildRawTextFromPart(part);
                    }
                    finally {
                        doc.dispose();
                    }
                    if (srcUnit instanceof INativeSourceUnit) {
                        codeitem = ((INativeSourceUnit)srcUnit).getNativeItem();
                        elt = ((INativeSourceUnit)srcUnit).getASTItem();
                        if (elt instanceof ICMethod) {
                            qtype = 1;
                        }
                    } else if (srcUnit instanceof IJavaSourceUnit) {
                        codeitem = ((IJavaSourceUnit)srcUnit).getDexItem();
                        elt = ((IJavaSourceUnit)srcUnit).getASTElement();
                        if (elt instanceof IJavaMethod) {
                            qtype = 1;
                        } else if (elt instanceof IJavaClass) {
                            qtype = 2;
                        }
                    }
                    if (qtype == 0 || codeitem == null || decompstr == null || qtype == 2 && decompilables == null) {
                        return false;
                    }
                    if (decompstr.length() >= 10000) {
                        logger.warn("The body of code is too long to be analyzed at the moment", new Object[0]);
                        return false;
                    }
                    if (!Net.isConnectedToInternet()) {
                        logger.warn("The assistant requires an Internet connection", new Object[0]);
                        return false;
                    }
                    int ts = (int)(System.currentTimeMillis() / 1000L);
                    IPropertyManager pm = this.ctx.getPropertyManager();
                    if (pm.getInteger(".ui.assistant.DisclaimerShownTs") == 0) {
                        String disclaimer = "The assistant will look at this code and attempt to provide better names.\nIn order to do this, the decompiled output will be sent to our server.\n\nPlease accept to continue.";
                        if (!UI.confirm(null, "Assistant Disclaimer", disclaimer)) {
                            return false;
                        }
                        pm.setInteger(".ui.assistant.DisclaimerShownTs", ts);
                    }
                    if ((lastReqTs = pm.getInteger(".ui.assistant.LastQueryTs")) != 0 && ts - lastReqTs < 2) {
                        logger.warn("Assistant requests are being made too frequently", new Object[0]);
                        return false;
                    }
                    pm.setInteger(".ui.assistant.LastQueryTs", ts);
                    this.incrStatCounter(".ui.assistant.RunCount2");
                    final int _qtype = qtype;
                    final String _data = decompstr;
                    final JebIoApiHelper helper = new JebIoApiHelper(this.ctx.getNetworkUtility(), null);
                    String respstr = ((RcpClientContext)this.ctx).executeNetworkTask(1000, new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            try {
                                return helper.queryAssistant(_qtype, _data);
                            }
                            catch (IOException iOException) {
                                return null;
                            }
                        }
                    });
                    if (respstr == null) {
                        logger.debug("The assistant reported a failure", new Object[0]);
                        return false;
                    }
                    r = Assistant.parseAssistantResponse(respstr);
                    if (r == null) {
                        logger.debug("The assistant response cannot be parsed", new Object[0]);
                        return false;
                    }
                    logger.debug("RESPONSE: %s", r);
                    rencnt = 0;
                    if (qtype != 1) break block37;
                    String suggname = r.primaryName;
                    String curname = codeitem.getName();
                    if (suggname == null || suggname.isEmpty() || suggname.equals(curname)) {
                        logger.debug("The assistant response is not useful at this time", new Object[0]);
                        return false;
                    }
                    logger.info("%s: Assistant suggestion: %s", curname, suggname);
                    newname = UI.ask(null, "Rename the method?", Strings.ff("The assistant is suggesting the following function name (instead of '%s'):\n%s", curname, suggname), suggname);
                    if (Strings.isBlank(newname)) {
                        return false;
                    }
                    if (!(codeitem instanceof IDexMethod)) break block38;
                    ((IDexMethod)codeitem).setName(newname);
                    ++rencnt;
                    break block39;
                }
                if (!(codeitem instanceof INativeMethodItem)) break block39;
                ((INativeMethodItem)codeitem).setName(newname);
                ++rencnt;
                break block39;
            }
            if (qtype == 2) {
                ICodeUnit code = srcUnit.getDecompiler().getCodeUnit();
                ArrayList<Couple<String, String>> nameWithSigs = new ArrayList<Couple<String, String>>();
                for (String string : decompilables) {
                    ICodeItem iCodeItem = code.getCodeItemByAddress(string);
                    if (iCodeItem == null) continue;
                    nameWithSigs.add(new Couple<String, String>(iCodeItem.getName(), iCodeItem.getSignature()));
                }
                for (Couple couple : r.deobmap) {
                    String string = (String)couple.getFirst();
                    int found = -1;
                    for (int i = 0; i < nameWithSigs.size(); ++i) {
                        if (!string.equals(((Couple)nameWithSigs.get(i)).getFirst())) continue;
                        found = i;
                        break;
                    }
                    if (found < 0) continue;
                    Couple entry = (Couple)nameWithSigs.remove(found);
                    String sig = (String)entry.getSecond();
                    couple.setFirst(sig);
                }
                dlg = new AssistantRenamerDialog(this.ctx.getActiveShell(), srcUnit, r);
                if (!dlg.open().booleanValue()) {
                    return false;
                }
                ArrayList<Couple<ICodeItem, String>> deobmap2 = new ArrayList<Couple<ICodeItem, String>>();
                for (Couple<String, String> couple : r.deobmap) {
                    String curname;
                    String newname;
                    ICodeItem it = code.getCodeItemByAddress(couple.getFirst());
                    if (it == null || Strings.isBlank(newname = couple.getSecond()) || newname.equals(curname = it.getName()) || it instanceof IDexMethod && dexDNRMethodSet.contains(it.getName(false))) continue;
                    deobmap2.add(new Couple<ICodeItem, String>(it, newname));
                }
                for (Couple couple : deobmap2) {
                    ICodeItem it = (ICodeItem)couple.getFirst();
                    String newname = (String)couple.getSecond();
                    if (it instanceof IDexClass) {
                        ((IDexClass)it).setName(newname);
                        ++rencnt;
                        continue;
                    }
                    if (it instanceof IDexMethod) {
                        ((IDexMethod)it).setName(newname);
                        ++rencnt;
                        continue;
                    }
                    if (it instanceof IDexField) {
                        ((IDexField)it).setName(newname);
                        ++rencnt;
                        continue;
                    }
                    if (it instanceof INativeClassItem) {
                        ((INativeClassItem)it).setName(newname);
                        ++rencnt;
                        continue;
                    }
                    if (it instanceof INativeMethodItem) {
                        ((INativeMethodItem)it).setName(newname);
                        ++rencnt;
                        continue;
                    }
                    if (!(it instanceof INativeFieldItem)) continue;
                    ((INativeFieldItem)it).setName(newname);
                    ++rencnt;
                }
            }
        }
        if (rencnt == 0) {
            this.incrStatCounter(".ui.assistant.RunCount3");
            return false;
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("suggestionTaken", "" + rencnt);
        properties.put("decompLen", "" + decompstr.length());
        properties.put("formatType", srcUnit.getDecompiler().getCodeUnit().getFormatType());
        properties.put("jebBuildKey", Licensing.buildkey);
        this.ctx.getTelemetry().record("assistant.r2.result", properties);
        this.incrStatCounter(".ui.assistant.RunCount4");
        return true;
    }

    private void incrStatCounter(String propname) {
        IPropertyManager pm = this.ctx.getPropertyManager();
        int cnt = pm.getInteger(propname);
        pm.setInteger(propname, cnt + 1);
    }

    public static Response parseAssistantResponse(String respstr) {
        try {
            String mname;
            Response r = new Response();
            Map o = (Map)new JSONParser().parse(respstr);
            Map response = (Map)o.get("response");
            r.primaryName = mname = (String)response.get("name");
            List deobmap = (List)response.get("deobmap");
            if (deobmap != null) {
                for (Object e : deobmap) {
                    String oldname = (String)((List)e).get(0);
                    String newname = (String)((List)e).get(1);
                    r.deobmap.add(new Couple<String, String>(oldname, newname));
                }
            }
            return r;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class Response {
        public String primaryName = null;
        public List<Couple<String, String>> deobmap = new ArrayList<Couple<String, String>>();

        public String toString() {
            return Strings.ff("primaryName=%s / deobmap=%s", this.primaryName, this.deobmap);
        }
    }
}

