/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class AssetManagerOverlay {
    private List<Image> images = new ArrayList<Image>();
    private List<Point> positions = new ArrayList<Point>();
    private String id = "";
    private boolean built = false;

    public String getId() {
        return this.id;
    }

    public AssetManagerOverlay addLayer(String filename, Point position) {
        Image img;
        if (!this.built && (img = UIAssetManager.getInstance().getImage(filename)) != null) {
            this.images.add(img);
            this.positions.add(position);
            this.id = this.id + Strings.ff("[%s:%d:%d]", filename, position.x, position.y);
        }
        return this;
    }

    public boolean hasLayer() {
        return !this.images.isEmpty();
    }

    public Image build(Image image) {
        this.built = true;
        ArrayList<OverlayImage> overlays = new ArrayList<OverlayImage>();
        for (int i = 0; i < this.images.size(); ++i) {
            overlays.add(new OverlayImage(this.images.get(i), this.positions.get(i)));
        }
        return new OverlayImageDescriptor(image, overlays).createImage();
    }

    private static class OverlayImage {
        private ImageData data;
        private Point position;

        public OverlayImage(Image image, Point position) {
            this.data = image.getImageData();
            this.position = position;
        }
    }

    private static class OverlayImageDescriptor
    extends CompositeImageDescriptor {
        private final ImageData base;
        private final List<OverlayImage> ovImages;

        OverlayImageDescriptor(Image image, List<OverlayImage> ovImages) {
            this.base = image.getImageData();
            this.ovImages = ovImages;
        }

        @Override
        protected void drawCompositeImage(int width, int height) {
            for (OverlayImage ovImage : this.ovImages) {
                this.drawImage(ovImage.data, ovImage.position.x, ovImage.position.y);
            }
            this.drawImage(this.base, 0, 0);
        }

        @Override
        protected Point getSize() {
            int width = this.base.width;
            int height = this.base.height;
            for (OverlayImage ovImage : this.ovImages) {
                width = Math.max(width, ovImage.data.width + ovImage.position.x);
                height = Math.max(height, ovImage.data.height + ovImage.position.y);
            }
            return new Point(width, height);
        }
    }
}

