/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.ASTVector;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterp;
import com.microsoft.z3.Native;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.Z3Object;
import com.microsoft.z3.Z3ReferenceQueue;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import java.lang.ref.ReferenceQueue;

public class Model
extends Z3Object {
    public <R extends Sort> Expr<R> getConstInterp(Expr<R> expr) {
        this.getContext().checkContextMatch(expr);
        return this.getConstInterp(expr.getFuncDecl());
    }

    public <R extends Sort> Expr<R> getConstInterp(FuncDecl<R> funcDecl) {
        this.getContext().checkContextMatch(funcDecl);
        if (funcDecl.getArity() != 0) {
            throw new Z3Exception("Non-zero arity functions have FunctionInterpretations as a model. Use getFuncInterp.");
        }
        long l = Native.modelGetConstInterp(this.getContext().nCtx(), this.getNativeObject(), funcDecl.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return Expr.create(this.getContext(), l);
    }

    public <R extends Sort> FuncInterp<R> getFuncInterp(FuncDecl<R> funcDecl) {
        this.getContext().checkContextMatch(funcDecl);
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), Native.getRange(this.getContext().nCtx(), funcDecl.getNativeObject())));
        if (funcDecl.getArity() == 0) {
            long l = Native.modelGetConstInterp(this.getContext().nCtx(), this.getNativeObject(), funcDecl.getNativeObject());
            if (z3_sort_kind == Z3_sort_kind.Z3_ARRAY_SORT) {
                if (l == 0L) {
                    return null;
                }
                if (Native.isAsArray(this.getContext().nCtx(), l)) {
                    long l2 = Native.getAsArrayFuncDecl(this.getContext().nCtx(), l);
                    return this.getFuncInterp(new FuncDecl(this.getContext(), l2));
                }
                return null;
            }
            throw new Z3Exception("Constant functions do not have a function interpretation; use getConstInterp");
        }
        long l = Native.modelGetFuncInterp(this.getContext().nCtx(), this.getNativeObject(), funcDecl.getNativeObject());
        if (l == 0L) {
            return null;
        }
        return new FuncInterp(this.getContext(), l);
    }

    public int getNumConsts() {
        return Native.modelGetNumConsts(this.getContext().nCtx(), this.getNativeObject());
    }

    public FuncDecl<?>[] getConstDecls() {
        int n = this.getNumConsts();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this.getContext(), Native.modelGetConstDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return funcDeclArray;
    }

    public int getNumFuncs() {
        return Native.modelGetNumFuncs(this.getContext().nCtx(), this.getNativeObject());
    }

    public FuncDecl<?>[] getFuncDecls() {
        int n = this.getNumFuncs();
        FuncDecl[] funcDeclArray = new FuncDecl[n];
        for (int i = 0; i < n; ++i) {
            funcDeclArray[i] = new FuncDecl(this.getContext(), Native.modelGetFuncDecl(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return funcDeclArray;
    }

    public FuncDecl<?>[] getDecls() {
        int n;
        int n2 = this.getNumFuncs();
        int n3 = this.getNumConsts();
        int n4 = n2 + n3;
        FuncDecl[] funcDeclArray = new FuncDecl[n4];
        for (n = 0; n < n3; ++n) {
            funcDeclArray[n] = new FuncDecl(this.getContext(), Native.modelGetConstDecl(this.getContext().nCtx(), this.getNativeObject(), n));
        }
        for (n = 0; n < n2; ++n) {
            funcDeclArray[n3 + n] = new FuncDecl(this.getContext(), Native.modelGetFuncDecl(this.getContext().nCtx(), this.getNativeObject(), n));
        }
        return funcDeclArray;
    }

    public <R extends Sort> Expr<R> eval(Expr<R> expr, boolean bl) {
        Native.LongPtr longPtr = new Native.LongPtr();
        if (!Native.modelEval(this.getContext().nCtx(), this.getNativeObject(), expr.getNativeObject(), bl, longPtr)) {
            throw new ModelEvaluationFailedException();
        }
        return Expr.create(this.getContext(), longPtr.value);
    }

    public <R extends Sort> Expr<R> evaluate(Expr<R> expr, boolean bl) {
        return this.eval(expr, bl);
    }

    public int getNumSorts() {
        return Native.modelGetNumSorts(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort[] getSorts() {
        int n = this.getNumSorts();
        Sort[] sortArray = new Sort[n];
        for (int i = 0; i < n; ++i) {
            sortArray[i] = Sort.create(this.getContext(), Native.modelGetSort(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return sortArray;
    }

    public <R extends Sort> Expr<R>[] getSortUniverse(R r) {
        ASTVector aSTVector = new ASTVector(this.getContext(), Native.modelGetSortUniverse(this.getContext().nCtx(), this.getNativeObject(), r.getNativeObject()));
        return aSTVector.ToExprArray();
    }

    public String toString() {
        return Native.modelToString(this.getContext().nCtx(), this.getNativeObject());
    }

    Model(Context context, long l) {
        super(context, l);
    }

    @Override
    void incRef() {
        Native.modelIncRef(this.getContext().nCtx(), this.getNativeObject());
    }

    @Override
    void addToReferenceQueue() {
        this.getContext().getReferenceQueue().storeReference(this, (model, referenceQueue) -> new ModelRef((Model)model, referenceQueue));
    }

    private static class ModelRef
    extends Z3ReferenceQueue.Reference<Model> {
        private ModelRef(Model model, ReferenceQueue<Z3Object> referenceQueue) {
            super(model, referenceQueue);
        }

        @Override
        void decRef(Context context, long l) {
            Native.modelDecRef(context.nCtx(), l);
        }
    }

    public class ModelEvaluationFailedException
    extends Z3Exception {
    }
}

