/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.ModuleHandle;
import com.pnf.diemvm.StringEntry;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class StructHandle
extends DiemPoolEntry {
    @SerId(value=1)
    private int modulehandle_index;
    @SerId(value=2)
    private int name_index;
    @SerId(value=3)
    private boolean is_resource;

    public StructHandle(int modulehandle_index, int name_index, boolean is_resource) {
        this.modulehandle_index = modulehandle_index;
        this.name_index = name_index;
        this.is_resource = is_resource;
    }

    public boolean isResource() {
        return this.is_resource;
    }

    public ModuleHandle getModule(DiemUnit l) {
        return (ModuleHandle)l.moduleHandles.get(this.modulehandle_index);
    }

    public String getName(DiemUnit l) {
        return ((StringEntry)l.stringPool.get(this.name_index)).get();
    }

    public String getFullName(DiemUnit l) {
        Object s = ((StringEntry)l.stringPool.get(this.name_index)).get();
        s = (String)s + "@";
        s = (String)s + ((ModuleHandle)l.moduleHandles.get(this.modulehandle_index)).getFullName(l);
        return s;
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        if (this.is_resource) {
            t.append((CharSequence)"resource ");
        }
        ((StringEntry)l.stringPool.get(this.name_index)).format(l, t);
        t.append((CharSequence)"@");
        ((ModuleHandle)l.moduleHandles.get(this.modulehandle_index)).format(l, t);
        return t;
    }
}

