/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.FieldDef;
import com.pnf.diemvm.StructHandle;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.ArrayList;
import java.util.List;

@Ser
class StructDef
extends DiemPoolEntry {
    @SerId(value=1)
    private int structhandle_index;
    @SerId(value=2)
    private int field_count;
    @SerId(value=3)
    private int fields_index;

    public StructDef(int structhandle_index, int field_count, int fields_index) {
        this.structhandle_index = structhandle_index;
        this.field_count = field_count;
        this.fields_index = fields_index;
    }

    public int getHandleIndex() {
        return this.structhandle_index;
    }

    public StructHandle getHandle(DiemUnit l) {
        return (StructHandle)l.structHandles.get(this.structhandle_index);
    }

    public String getName(DiemUnit l) {
        return this.getHandle(l).getName(l);
    }

    public int getFieldCount() {
        return this.field_count;
    }

    public List<FieldDef> getFields(DiemUnit l) {
        ArrayList<FieldDef> r = new ArrayList<FieldDef>(this.field_count);
        for (int i = 0; i < this.field_count; ++i) {
            r.add((FieldDef)l.fieldDefs.get(this.fields_index + i));
        }
        return r;
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        ((StructHandle)l.structHandles.get(this.structhandle_index)).format(l, t);
        t.append((CharSequence)" { ");
        for (int i = 0; i < this.field_count; ++i) {
            if (i > 0) {
                t.append((CharSequence)", ");
            }
            ((FieldDef)l.fieldDefs.get(this.fields_index + i)).format(l, t);
        }
        t.append((CharSequence)" }");
        return t;
    }
}

