/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.AddressEntry;
import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.StringEntry;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class ModuleHandle
extends DiemPoolEntry {
    @SerId(value=1)
    private int address_index;
    @SerId(value=2)
    private int name_index;

    public ModuleHandle(int address_index, int name_index) {
        this.address_index = address_index;
        this.name_index = name_index;
    }

    public AddressEntry getAddress(DiemUnit l) {
        return (AddressEntry)l.addressPool.get(this.address_index);
    }

    public String getName(DiemUnit l) {
        return ((StringEntry)l.stringPool.get(this.name_index)).get();
    }

    public String getFullName(DiemUnit l) {
        return l.addressPool.get(this.address_index) + "." + ((StringEntry)l.stringPool.get(this.name_index)).get();
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        ((AddressEntry)l.addressPool.get(this.address_index)).format(l, t);
        t.append((CharSequence)".");
        ((StringEntry)l.stringPool.get(this.name_index)).format(l, t);
        return t;
    }
}

