/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.SignatureToken;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.List;

@Ser
class FunctionSignature
extends DiemPoolEntry {
    @SerId(value=1)
    private List<SignatureToken> returnTokens;
    @SerId(value=2)
    private List<SignatureToken> paramTokens;

    public FunctionSignature(List<SignatureToken> returnTokens, List<SignatureToken> paramTokens) {
        this.returnTokens = returnTokens;
        this.paramTokens = paramTokens;
    }

    public List<SignatureToken> getReturnTokens() {
        return this.returnTokens;
    }

    public List<SignatureToken> getParamTokens() {
        return this.paramTokens;
    }

    public String toString() {
        return this.paramTokens.toString() + ": " + this.returnTokens.toString();
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        t.append((CharSequence)"(");
        int i = 0;
        for (SignatureToken token : this.paramTokens) {
            if (i > 0) {
                t.append((CharSequence)", ");
            }
            token.format(l, t);
            ++i;
        }
        t.append((CharSequence)"): (");
        i = 0;
        for (SignatureToken token : this.returnTokens) {
            if (i > 0) {
                t.append((CharSequence)", ");
            }
            token.format(l, t);
            ++i;
        }
        t.append((CharSequence)")");
        return t;
    }
}

