/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.FunctionSignature;
import com.pnf.diemvm.ModuleHandle;
import com.pnf.diemvm.StringEntry;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class FunctionHandle
extends DiemPoolEntry {
    @SerId(value=1)
    private int modulehandle_index;
    @SerId(value=2)
    private int name_index;
    @SerId(value=3)
    private int signature_index;

    public FunctionHandle(int modulehandle_index, int name_index, int signature_index) {
        this.modulehandle_index = modulehandle_index;
        this.name_index = name_index;
        this.signature_index = signature_index;
    }

    public ModuleHandle getModule(DiemUnit l) {
        return (ModuleHandle)l.moduleHandles.get(this.modulehandle_index);
    }

    public String getName(DiemUnit l) {
        return this.getFullName(l);
    }

    private String getFullName(DiemUnit l) {
        String fname = ((StringEntry)l.stringPool.get(this.name_index)).get();
        String modname = ((ModuleHandle)l.moduleHandles.get(this.modulehandle_index)).getName(l);
        if ("<self>".equalsIgnoreCase(modname)) {
            return fname;
        }
        return modname + "_" + fname;
    }

    public FunctionSignature getSignature(DiemUnit l) {
        return (FunctionSignature)l.functionSignatures.get(this.signature_index);
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        ((ModuleHandle)l.moduleHandles.get(this.modulehandle_index)).format(l, t);
        t.append((CharSequence)".");
        ((StringEntry)l.stringPool.get(this.name_index)).format(l, t);
        ((FunctionSignature)l.functionSignatures.get(this.signature_index)).format(l, t);
        return t;
    }
}

