/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.CodeUnit;
import com.pnf.diemvm.Diem;
import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.FunctionHandle;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;

@Ser
class FunctionDef
extends DiemPoolEntry {
    @SerId(value=1)
    private int function_handle_index;
    @SerId(value=2)
    private int flags;
    @SerId(value=3)
    private CodeUnit code;

    public FunctionDef(int function_handle_index, int flags, CodeUnit code) {
        this.function_handle_index = function_handle_index;
        this.flags = flags;
        this.code = code;
    }

    public FunctionHandle getHandle(DiemUnit l) {
        return (FunctionHandle)l.functionHandles.get(this.function_handle_index);
    }

    public String getName(DiemUnit l) {
        return this.getHandle(l).getName(l);
    }

    public CodeUnit getCode() {
        return this.code;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        if (this.flags != 0) {
            t.append((CharSequence)Diem.formatFunctionFlags(this.flags)).append((CharSequence)" ");
        }
        ((FunctionHandle)l.functionHandles.get(this.function_handle_index)).format(l, t);
        t.eol();
        t.indent();
        this.code.format(l, t);
        return t.unindent();
    }
}

