/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.AbstractDataEntry;
import com.pnf.diemvm.AddressEntry;
import com.pnf.diemvm.BytearrayEntry;
import com.pnf.diemvm.CodeUnit;
import com.pnf.diemvm.Diem;
import com.pnf.diemvm.DiemBytecodeParser;
import com.pnf.diemvm.DiemInstruction;
import com.pnf.diemvm.DiemObject;
import com.pnf.diemvm.DiemPool;
import com.pnf.diemvm.DiemPoolEntry;
import com.pnf.diemvm.FieldDef;
import com.pnf.diemvm.FunctionDef;
import com.pnf.diemvm.FunctionHandle;
import com.pnf.diemvm.FunctionSignature;
import com.pnf.diemvm.LocalSignature;
import com.pnf.diemvm.ModuleHandle;
import com.pnf.diemvm.SignatureToken;
import com.pnf.diemvm.StringEntry;
import com.pnf.diemvm.StructDef;
import com.pnf.diemvm.StructHandle;
import com.pnf.diemvm.TypeSignature;
import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitNotification;
import com.pnfsoftware.jeb.core.units.code.asm.memory.IVirtualMemory;
import com.pnfsoftware.jeb.core.units.code.asm.memory.MemoryException;
import com.pnfsoftware.jeb.core.units.code.asm.processor.ProcessorException;
import com.pnfsoftware.jeb.core.units.codeobject.AbstractCodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.CodeObjectUnitUtil;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ILinkInfoProvider;
import com.pnfsoftware.jeb.core.units.codeobject.ILoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ISymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.LoaderInformation;
import com.pnfsoftware.jeb.core.units.codeobject.ProcessorType;
import com.pnfsoftware.jeb.core.units.codeobject.SegmentInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolInformation;
import com.pnfsoftware.jeb.core.units.codeobject.SymbolType;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.base.Throwables;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.io.ByteArray;
import com.pnfsoftware.jeb.util.io.Endianness;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Ser
public class DiemUnit
extends AbstractCodeObjectUnit {
    private static final ILogger logger = GlobalLog.getLogger(DiemUnit.class);
    static final int ptrsize = 64;
    static final int ptrsizeInBytes = 8;
    private static final long phyDataBase = 0L;
    private static final String segData = ".data";
    private static final long phyCodeBase = 0x10000000L;
    private static final String segCode = ".code";
    private static final long phyImportsBase = 0x20000000L;
    private static final String segImports = ".imports";
    @SerId(value=1)
    byte[] rawbytes;
    @SerId(value=2)
    DiemBytecodeParser bytecodeParser;
    @SerId(value=10)
    DiemPool<ModuleHandle> moduleHandles = new DiemPool("Module Handles");
    @SerId(value=11)
    DiemPool<StructHandle> structHandles = new DiemPool("Struct Handles");
    @SerId(value=12)
    DiemPool<FunctionHandle> functionHandles = new DiemPool("Function Handles");
    @SerId(value=13)
    DiemPool<AddressEntry> addressPool = new DiemPool("Addresses");
    @SerId(value=14)
    DiemPool<BytearrayEntry> bytearrayPool = new DiemPool("ByteArrays");
    @SerId(value=15)
    DiemPool<StringEntry> stringPool = new DiemPool("Strings");
    @SerId(value=16)
    DiemPool<TypeSignature> typeSignatures = new DiemPool("Type Signatures");
    @SerId(value=17)
    DiemPool<LocalSignature> localSignatures = new DiemPool("Local Signatures");
    @SerId(value=18)
    DiemPool<FunctionSignature> functionSignatures = new DiemPool("Function Signatures");
    @SerId(value=19)
    DiemPool<StructDef> structDefs = new DiemPool("Struct Definitions");
    @SerId(value=20)
    DiemPool<FieldDef> fieldDefs = new DiemPool("Field Definitions");
    @SerId(value=21)
    DiemPool<FunctionDef> functionDefs = new DiemPool("Function Definitions");
    @SerId(value=22)
    FunctionDef main;

    public DiemUnit(String name, IInput input, IUnitProcessor unitProcessor, IUnitCreator parent, IPropertyDefinitionManager pdm) {
        super(input, "diemvm", name, unitProcessor, parent, pdm);
    }

    public DiemBytecodeParser getBytecodeParser() {
        return this.bytecodeParser;
    }

    protected boolean processInternal() {
        boolean bl;
        block19: {
            this.bytecodeParser = new DiemBytecodeParser(this);
            InputStream in = this.getInput().getStream();
            try {
                this.rawbytes = IO.readInputStream((InputStream)in);
                ByteArray ba = new ByteArray(this.rawbytes, 10);
                int tablecount = ba.u8();
                for (int i = 0; i < tablecount; ++i) {
                    int _type = ba.u8();
                    Diem.TableType t = Diem.TableType.fromValue(_type);
                    int table_offset = ba.u31();
                    int table_size = ba.u31();
                    this.processTable(t, ba.copy(table_offset, table_offset + table_size));
                    this.addSection((ISegmentInformation)new SegmentInformation(t.toString(), (long)table_offset, (long)table_size, 0L, 0L, 2));
                }
                if (Licensing.isDebugBuild()) {
                    logger.i(this.formatTables(), new Object[0]);
                }
                long currentAddress = 0L;
                for (AbstractDataEntry e : this.getDataEntries()) {
                    e.mappedAddress = currentAddress;
                    e.mappedSize = e.getBytes().length;
                    SymbolInformation symbol = new SymbolInformation(SymbolType.VARIABLE, 0, (long)e.getIndex(), null, 0L, e.mappedAddress, (long)e.mappedSize);
                    String basetype = e instanceof StringEntry ? "char" : "byte";
                    symbol.setSymbolDataTypeInformation(basetype + "[" + e.mappedSize + "]");
                    this.addSymbol((ISymbolInformation)symbol);
                    currentAddress += (long)e.mappedSize;
                }
                int segsize = (int)(currentAddress - 0L);
                if (segsize > 0) {
                    this.addSegment((ISegmentInformation)new SegmentInformation(segData, 0L, 0L, 0L, (long)segsize, 7));
                }
                currentAddress = 0x10000000L;
                for (FunctionDef e : this.getInternalFunctions()) {
                    e.mappedAddress = currentAddress;
                    e.mappedSize = e.getCode().getInsnFileSize();
                    this.addSymbol((ISymbolInformation)new SymbolInformation(SymbolType.FUNCTION, 4, (long)e.getIndex(), e.getHandle(this).getName(this), 0L, e.mappedAddress, (long)e.mappedSize));
                    currentAddress += (long)e.mappedSize;
                }
                segsize = (int)(currentAddress - 0x10000000L);
                if (segsize > 0) {
                    this.addSegment((ISegmentInformation)new SegmentInformation(segCode, 0L, 0L, 0x10000000L, (long)segsize, 7));
                }
                currentAddress = 0x20000000L;
                for (FunctionHandle e : this.getExternalFunctionHandles()) {
                    e.mappedAddress = currentAddress;
                    SymbolInformation symbol = new SymbolInformation(SymbolType.PTRFUNCTION, 1, (long)e.getIndex(), e.getName(this), 0L, currentAddress, 8L);
                    this.addSymbol((ISymbolInformation)symbol);
                    currentAddress += 8L;
                }
                segsize = (int)(currentAddress - 0x20000000L);
                if (segsize > 0) {
                    this.addSegment((ISegmentInformation)new SegmentInformation(segImports, 0L, 0L, 0x20000000L, (long)segsize, 7));
                }
                LoaderInformation ldinfo = new LoaderInformation.Builder().setVersion("1.0").setTargetProcessor(ProcessorType.UNKNOWN).setWordSize(64).setEndianness(Endianness.LITTLE_ENDIAN).setImageBase(0L).setImageSize(0x80000000L).setFlags(4).setEntryPoint(0x10000000L).build();
                this.setLoaderInformation((ILoaderInformation)ldinfo);
                try {
                    String t = "diemvm_bc";
                    IUnit img = this.getUnitProcessor().process(t + " image", this.getInput(), (IUnitCreator)this, t, true);
                    if (img != null) {
                        this.addChildUnit(img);
                    }
                }
                catch (Exception e) {
                    logger.catching((Throwable)e);
                    this.addNotification((IUnitNotification)new UnitNotification(NotificationType.UNSUPPORTED_FEATURE, "The bytecode was not disassembled"));
                }
                bl = true;
                if (in == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.catching((Throwable)e);
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private void processTable(Diem.TableType t, ByteArray ba) {
        switch (t) {
            case MODULE_HANDLES: {
                this.loadModuleHandles(ba);
                break;
            }
            case STRUCT_HANDLES: {
                this.loadStructHandles(ba);
                break;
            }
            case FUNCTION_HANDLES: {
                this.loadFunctionHandles(ba);
                break;
            }
            case ADDRESS_POOL: {
                this.loadAddressPool(ba);
                break;
            }
            case BYTE_ARRAY_POOL: {
                this.loadBytearrayPool(ba);
                break;
            }
            case STRING_POOL: {
                this.loadStringPool(ba);
                break;
            }
            case TYPE_SIGNATURES: {
                this.loadTypeSignatures(ba);
                break;
            }
            case LOCALS_SIGNATURES: {
                this.loadLocalSignatures(ba);
                break;
            }
            case FUNCTION_SIGNATURES: {
                this.loadFunctionSignatures(ba);
                break;
            }
            case STRUCT_DEFS: {
                this.loadStructDefs(ba);
                break;
            }
            case FIELD_DEFS: {
                this.loadFieldDefs(ba);
                break;
            }
            case FUNCTION_DEFS: {
                this.loadFunctionDefs(ba);
                break;
            }
            case MAIN: {
                this.loadMain(ba);
                break;
            }
            default: {
                throw new RuntimeException("Unknown table type: " + t);
            }
        }
    }

    private void loadModuleHandles(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int address = ba.varu16();
            int name = ba.varu16();
            this.moduleHandles.add(new ModuleHandle(address, name));
        }
    }

    private void loadStructHandles(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int module_handle = ba.varu16();
            int name = ba.varu16();
            boolean is_resource = ba.u8() != 0;
            this.structHandles.add(new StructHandle(module_handle, name, is_resource));
        }
    }

    private void loadFunctionHandles(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int module_handle = ba.varu16();
            int name = ba.varu16();
            int signature = ba.varu16();
            this.functionHandles.add(new FunctionHandle(module_handle, name, signature));
        }
    }

    private void loadAddressPool(ByteArray ba) {
        if (ba.available() % 32 != 0) {
            throw new RuntimeException();
        }
        while (ba.position() < ba.maxPosition()) {
            byte[] a = ba.get(32);
            this.addressPool.add(new AddressEntry(a));
        }
    }

    private void loadBytearrayPool(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int len = ba.vari32();
            if (len < 0 || len > 65535) {
                throw new RuntimeException();
            }
            byte[] bytes = ba.get(len);
            this.bytearrayPool.add(new BytearrayEntry(bytes));
        }
    }

    private void loadStringPool(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int len = ba.vari32();
            if (len < 0 || len > 65535) {
                throw new RuntimeException();
            }
            int off = ba.position();
            String s = new String(ba.bytes(), off, len);
            ba.position(off + len);
            this.stringPool.add(new StringEntry(s));
        }
    }

    private void loadFunctionSignatures(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int st = ba.u8();
            if (st != Diem.SignatureType.FUNCTION_SIGNATURE.getValue()) {
                throw new RuntimeException("Expected a function signature type, got " + st);
            }
            int cnt = ba.u8();
            ArrayList<SignatureToken> returnTokens = new ArrayList<SignatureToken>(cnt);
            for (int i = 0; i < cnt; ++i) {
                returnTokens.add(this.readSigToken(ba));
            }
            cnt = ba.u8();
            ArrayList<SignatureToken> paramTokens = new ArrayList<SignatureToken>(cnt);
            for (int i = 0; i < cnt; ++i) {
                paramTokens.add(this.readSigToken(ba));
            }
            this.functionSignatures.add(new FunctionSignature(returnTokens, paramTokens));
        }
    }

    private void loadLocalSignatures(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int st = ba.u8();
            if (st != Diem.SignatureType.LOCAL_SIGNATURE.getValue()) {
                throw new RuntimeException("Expected a local signature type, got " + st);
            }
            int cnt = ba.u8();
            ArrayList<SignatureToken> tokens = new ArrayList<SignatureToken>(cnt);
            for (int i = 0; i < cnt; ++i) {
                tokens.add(this.readSigToken(ba));
            }
            this.localSignatures.add(new LocalSignature(tokens));
        }
    }

    private void loadTypeSignatures(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int st = ba.u8();
            if (st != Diem.SignatureType.TYPE_SIGNATURE.getValue()) {
                throw new RuntimeException("Expected a type signature type, got " + st);
            }
            SignatureToken token = this.readSigToken(ba);
            this.typeSignatures.add(new TypeSignature(token));
        }
    }

    private SignatureToken readSigToken(ByteArray ba) {
        int value = ba.u8();
        Diem.SerializedType st = Diem.SerializedType.fromValue(value);
        switch (st) {
            case BOOL: 
            case INTEGER: 
            case STRING: 
            case BYTEARRAY: 
            case ADDRESS: {
                return new SignatureToken(st);
            }
            case REFERENCE: {
                return new SignatureToken(this.readSigToken(ba), false);
            }
            case MUTABLE_REFERENCE: {
                return new SignatureToken(this.readSigToken(ba), true);
            }
            case STRUCT: {
                return new SignatureToken(ba.varu16());
            }
        }
        throw new RuntimeException("TBI: " + st);
    }

    private void loadMain(ByteArray ba) {
        this.main = this.readFunctionDef(ba);
    }

    private void loadFunctionDefs(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            FunctionDef f = this.readFunctionDef(ba);
            this.functionDefs.add(f);
        }
    }

    private FunctionDef readFunctionDef(ByteArray ba) {
        int function_handle_index = ba.varu16();
        int flags = ba.u8();
        CodeUnit codeunit = this.readCodeUnit(ba, function_handle_index, flags);
        return new FunctionDef(function_handle_index, flags, codeunit);
    }

    private CodeUnit readCodeUnit(ByteArray ba, int function_handle_index, int flags) {
        List<DiemInstruction> insnlist;
        int max_stack_size = ba.varu16();
        int locals_index = ba.varu16();
        int insncnt = ba.u16();
        int bytecode_offset = ba.position();
        logger.i("==> Parsing bytecode at 0x%X: fh=%d, mss=%d, sig=%d, insncnt=%d", new Object[]{bytecode_offset, function_handle_index, max_stack_size, locals_index, insncnt});
        try {
            insnlist = this.bytecodeParser.parseFunction(function_handle_index, insncnt, bytecode_offset, ba.maxPosition());
        }
        catch (ProcessorException e) {
            throw new RuntimeException(e);
        }
        CodeUnit code = new CodeUnit(max_stack_size, locals_index, insnlist);
        code.setInsnFileOffset(bytecode_offset);
        ba.skip(code.getInsnFileSize());
        return code;
    }

    private void loadStructDefs(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int struct_handle = ba.varu16();
            int field_count = ba.varu16();
            int fields = ba.varu16();
            this.structDefs.add(new StructDef(struct_handle, field_count, fields));
        }
    }

    private void loadFieldDefs(ByteArray ba) {
        while (ba.position() < ba.maxPosition()) {
            int struct_handle = ba.varu16();
            int name = ba.varu16();
            int signature = ba.varu16();
            this.fieldDefs.add(new FieldDef(struct_handle, name, signature));
        }
    }

    public List<AbstractDataEntry> getDataEntries() {
        ArrayList<AbstractDataEntry> r = new ArrayList<AbstractDataEntry>();
        r.addAll(this.addressPool.getAll());
        r.addAll(this.bytearrayPool.getAll());
        r.addAll(this.stringPool.getAll());
        return r;
    }

    public List<FunctionDef> getInternalFunctions() {
        if (this.main != null) {
            Assert.a((boolean)this.functionDefs.isEmpty(), (String)"Diem script cannot contain functions defs aside from main()");
            return Arrays.asList(this.main);
        }
        return this.functionDefs.getAll();
    }

    public List<FunctionHandle> getExternalFunctionHandles() {
        ArrayList<FunctionHandle> internals = new ArrayList<FunctionHandle>();
        for (FunctionDef e : this.getInternalFunctions()) {
            internals.add(e.getHandle(this));
        }
        ArrayList<FunctionHandle> r = new ArrayList<FunctionHandle>();
        Iterator iterator = this.functionHandles.iterator();
        while (iterator.hasNext()) {
            FunctionHandle e = (FunctionHandle)iterator.next();
            if (internals.contains(e)) continue;
            r.add(e);
        }
        return r;
    }

    protected boolean shouldAllocateFullImage() {
        return false;
    }

    protected boolean applyRelocations(IVirtualMemory mem, long base, ILinkInfoProvider linkInfoPrv) {
        return false;
    }

    protected boolean mapRawNoReloc(IVirtualMemory mem, long base) {
        if (base != 0L) {
            throw new IllegalArgumentException("Must map at address 0");
        }
        super.mapRawNoReloc(mem, base);
        try {
            int writesize;
            int size;
            if (CodeObjectUnitUtil.findSegmentByName((ICodeObjectUnit)this, (String)segData) != null) {
                Iterator<DiemPoolEntry> iterator = this.getDataEntries().iterator();
                while (iterator.hasNext()) {
                    AbstractDataEntry functionHandle;
                    size = functionHandle.mappedSize;
                    functionHandle = iterator.next();
                    writesize = mem.write(functionHandle.mappedAddress, size, functionHandle.getBytes(), 0);
                    if (writesize == size) continue;
                    throw new MemoryException("Partial write");
                }
            }
            if (CodeObjectUnitUtil.findSegmentByName((ICodeObjectUnit)this, (String)segCode) != null) {
                for (FunctionDef functionDef : this.getInternalFunctions()) {
                    size = functionDef.getCode().getInsnFileSize();
                    writesize = mem.write(functionDef.mappedAddress, size, this.rawbytes, functionDef.getCode().getInsnFileOffset());
                    if (writesize == size) continue;
                    throw new MemoryException("Partial write");
                }
            }
            if (CodeObjectUnitUtil.findSegmentByName((ICodeObjectUnit)this, (String)segImports) != null) {
                for (FunctionHandle functionHandle : this.getExternalFunctionHandles()) {
                }
            }
            return true;
        }
        catch (MemoryException e) {
            throw new RuntimeException(e);
        }
    }

    Diem.BinaryType getBinaryType() {
        return this.main != null ? Diem.BinaryType.SCRIPT : Diem.BinaryType.MODULE;
    }

    int getStructFieldCount(int sd_index) {
        return ((StructDef)this.structDefs.get(sd_index)).getFieldCount();
    }

    FunctionSignature getFunctionSignature(int fh_index) {
        return ((FunctionHandle)this.functionHandles.get(fh_index)).getSignature(this);
    }

    String getFunctionName(int fh_index) {
        return ((FunctionHandle)this.functionHandles.get(fh_index)).getName(this);
    }

    FunctionDef getFunctionByAddress(long address) {
        for (FunctionDef e : this.getInternalFunctions()) {
            if (address != e.mappedAddress) continue;
            return e;
        }
        return null;
    }

    FunctionDef getFunctionByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        for (FunctionDef e : this.getInternalFunctions()) {
            FunctionHandle handle = e.getHandle(this);
            if (!name.equals(handle.getName(this))) continue;
            return e;
        }
        return null;
    }

    FunctionHandle getFunctionHandleByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.functionHandles.iterator();
        while (iterator.hasNext()) {
            FunctionHandle e = (FunctionHandle)iterator.next();
            if (!name.equals(e.getName(this))) continue;
            return e;
        }
        return null;
    }

    public String formatTables() {
        TextBuilder t = new TextBuilder();
        this.moduleHandles.format(this, t).eol();
        this.structHandles.format(this, t).eol();
        this.functionHandles.format(this, t).eol();
        this.structDefs.format(this, t).eol();
        this.fieldDefs.format(this, t).eol();
        this.typeSignatures.format(this, t).eol();
        this.functionSignatures.format(this, t).eol();
        this.localSignatures.format(this, t).eol();
        this.stringPool.format(this, t).eol();
        this.bytearrayPool.format(this, t).eol();
        this.addressPool.format(this, t).eol();
        this.functionDefs.format(this, t).eol();
        if (this.main != null) {
            this.main.format(this, t).eol();
        }
        return t.toString();
    }

    String formatObject(DiemObject o) {
        TextBuilder t = new TextBuilder();
        return o.format(this, t).toString();
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.formatTables());
        }
        catch (Exception e) {
            sb.append("\n\nAn error occurred when formatting the tables:\n");
            sb.append(Throwables.formatStacktrace((Throwable)e));
        }
        return sb.toString();
    }

    public byte[] getIconData() {
        try {
            return IO.readInputStream((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("diem_icon.png"));
        }
        catch (IOException e) {
            return null;
        }
    }
}

