/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.Diem;
import com.pnf.diemvm.DiemInstruction;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.FunctionDef;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.SourceCustomizerAdapter;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.COutputSink;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICClass;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICCustomStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.ICMethod;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;

public class DiemSourceCustomizer
extends SourceCustomizerAdapter {
    DiemUnit unit;
    INativeCodeUnit<DiemInstruction> code;
    INativeDecompilerUnit<DiemInstruction> decomp;

    public DiemSourceCustomizer(INativeDecompilerUnit<DiemInstruction> decomp) {
        this.decomp = decomp;
        this.code = (INativeCodeUnit)decomp.getParent();
        this.unit = (DiemUnit)this.code.getParent();
    }

    public boolean generateClassDeclarationLine(ICClass elt, COutputSink out) {
        if (this.unit.getBinaryType() == Diem.BinaryType.MODULE) {
            out.appendKeyword("module");
            out.space();
            elt.getClasstype().generate(out);
            return true;
        }
        return false;
    }

    public boolean preFieldsGeneration(ICClass elt, COutputSink out) {
        return true;
    }

    public boolean preMethodsGeneration(ICClass elt, COutputSink out) {
        return true;
    }

    public boolean generateMethodDeclarationLine(ICMethod elt, COutputSink out) {
        int index = elt.getIndex();
        INativeMethodItem routine = this.code.getMethodByIndex(index);
        FunctionDef f = this.unit.getFunctionByAddress(routine.getData().getMemoryAddress());
        if (f.getFlags() != 0) {
            out.appendKeyword(Diem.formatFunctionFlags(f.getFlags()));
            out.space();
        }
        return false;
    }

    public boolean generateNativeStatement(ICCustomStatement elt, COutputSink out) {
        return super.generateNativeStatement(elt, out);
    }
}

