/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.Diem;
import com.pnf.diemvm.DiemInstruction;
import com.pnf.diemvm.DiemUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IGlobalAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.NativeDecompilationStage;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeClassItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IClassManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.IClassType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPackageManager;
import com.pnfsoftware.jeb.core.units.code.asm.type.ITypeManager;
import com.pnfsoftware.jeb.util.concurrent.ACLock;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;

public class DiemModuleRebuilder
implements IGlobalAnalyzer {
    private static final ILogger logger = GlobalLog.getLogger(DiemModuleRebuilder.class);
    public static final String StandardModuleName = "DecompiledModule";
    DiemUnit unit;
    INativeCodeUnit<DiemInstruction> code;
    INativeDecompilerUnit<DiemInstruction> decomp;
    private INativeClassItem classItem;

    public DiemModuleRebuilder(INativeDecompilerUnit<DiemInstruction> decomp) {
        this.decomp = decomp;
        this.code = (INativeCodeUnit)decomp.getParent();
        this.unit = (DiemUnit)this.code.getParent();
    }

    public INativeClassItem getRebuiltModule() {
        return this.classItem;
    }

    public boolean perform() {
        if (this.unit.getBinaryType() == Diem.BinaryType.SCRIPT) {
            return true;
        }
        if (this.unit.getBinaryType() != Diem.BinaryType.MODULE) {
            return false;
        }
        if (this.classItem != null) {
            throw new IllegalStateException("The module was already rebuilt");
        }
        try (ACLock unused = this.code.getLock().a();){
            this.rebuildModule();
        }
        return true;
    }

    void rebuildModule() {
        ITypeManager typeman = this.code.getTypeManager();
        IClassManager classman = this.code.getClassManager();
        IPackageManager pman = this.code.getPackageManager();
        List routines = this.code.getInternalMethods();
        for (INativeMethodItem routine : routines) {
            this.decompile(routine, null);
        }
        String classname = StandardModuleName;
        IClassType classType = typeman.createClassType(classname, 1, 0);
        this.classItem = classman.createClass(classType);
        typeman.completeClassTypeInitialization(classType);
        for (INativeMethodItem routine : routines) {
            classman.addNonVirtualMethod(this.classItem, routine);
        }
        classman.completeClassInitialization(this.classItem);
        for (INativeMethodItem routine : routines) {
            pman.moveToClass((INativeItem)routine, this.classItem);
        }
    }

    IDecompiledMethod decompile(INativeMethodItem routine, NativeDecompilationStage stage) {
        try {
            return this.decomp.decompileMethodEx(routine, null, stage);
        }
        catch (Exception e) {
            logger.catchingSilent((Throwable)e);
            return null;
        }
    }
}

