/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.Diem;
import com.pnf.diemvm.DiemInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.FlowInformation;
import com.pnfsoftware.jeb.core.units.code.ICodePointer;
import com.pnfsoftware.jeb.core.units.code.IFlowInformation;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.InstructionFlags;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Ser
public class DiemInstruction
implements IInstruction {
    @SerId(value=1)
    Diem.OpcodeDef opdef;
    @SerId(value=2)
    byte[] code;
    @SerId(value=3)
    DiemInstructionOperand[] opnds;
    @SerId(value=4)
    int preExecStackDelta;
    @SerId(value=5)
    int postExecStackDelta;
    @SerId(value=6)
    int indexInFunction;
    @SerId(value=7)
    int offsetInFunction;
    @SerId(value=8)
    int targetDelta;

    public DiemInstruction(Diem.OpcodeDef opdef) {
        this.opdef = opdef;
    }

    public Diem.OpcodeDef getOpcode() {
        return this.opdef;
    }

    public int getProcessorMode() {
        return 64;
    }

    public int getSize() {
        return this.code.length;
    }

    public byte[] getCode() {
        return this.code;
    }

    public String getMnemonic() {
        return this.opdef.toString();
    }

    public DiemInstructionOperand[] getOperands() {
        return this.opnds;
    }

    public long getOperandAsLong() {
        return (Long)this.opnds[0].getObject();
    }

    public int getOperandAsIndex() {
        return (Integer)this.opnds[0].getObject();
    }

    public String getPrefix() {
        return null;
    }

    public IFlowInformation getBreakingFlow(long instructionAddress) {
        if (this.opdef == Diem.OpcodeDef.RET) {
            return new FlowInformation();
        }
        if (this.opdef == Diem.OpcodeDef.BR_TRUE || this.opdef == Diem.OpcodeDef.BR_FALSE || this.opdef == Diem.OpcodeDef.BRANCH) {
            FlowInformation f = new FlowInformation();
            if (this.opdef == Diem.OpcodeDef.BR_TRUE || this.opdef == Diem.OpcodeDef.BR_FALSE) {
                f.addTarget((ICodePointer)new CodePointer(instructionAddress + (long)this.getSize()));
            }
            f.addTarget((ICodePointer)new CodePointer(instructionAddress + (long)this.targetDelta));
            return f;
        }
        return FlowInformation.NONE;
    }

    public IFlowInformation getRoutineCall(long instructionAddress) {
        if (this.opdef == Diem.OpcodeDef.CALL) {
            return new FlowInformation();
        }
        return FlowInformation.NONE;
    }

    public IFlowInformation collectIndirectCallReferences(long instructionAddress) {
        return FlowInformation.NONE;
    }

    public void getDefUse(List<Integer> def, List<Integer> use, Object context) {
    }

    public boolean canThrow() {
        return false;
    }

    public Set<InstructionFlags> getInstructionFlags() {
        return Collections.emptySet();
    }

    public String format(Object context) {
        long address = context instanceof Long ? (Long)context : 0L;
        StringBuilder sb = new StringBuilder();
        sb.append(this.opdef.toString());
        if (this.opnds != null && this.opnds.length == 1) {
            sb.append(" ").append(this.opnds[0].format(this, address));
        }
        return String.format("%-30s     [%d,%d]", sb.toString(), this.preExecStackDelta, this.postExecStackDelta);
    }

    public String toString() {
        return this.format(null);
    }
}

