/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.DiemUnit;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.AbstractUnitIdentifier;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitProcessor;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;

public class DiemIdentifier
extends AbstractUnitIdentifier {
    private static final ILogger logger = GlobalLog.getLogger(DiemIdentifier.class);
    public static final String TYPE = "diemvm";
    public static final Version VERSION = Version.create((int)0, (int)4, (int)2);

    public DiemIdentifier() {
        super(TYPE, 0.0);
    }

    public IPluginInformation getPluginInformation() {
        return new PluginInformation("Diem contract parser", "Parser for Diem VM binary modules and scripts (1.0) ", "PNF Software", VERSION);
    }

    public boolean canIdentify(IInput input, IUnitCreator parent, String name, Map<Object, Object> identmap) {
        if (!DiemIdentifier.checkBytes((IInput)input, (int)0, (int[])new int[]{76, 73, 66, 82, 65, 86, 77, 10})) {
            return false;
        }
        if (!DiemIdentifier.checkBytes((IInput)input, (int)0, (int[])new int[]{68, 73, 69, 77, 86, 77, 10})) {
            return false;
        }
        ByteBuffer hdr = input.getHeader();
        if (hdr.limit() < 10) {
            return false;
        }
        hdr.order(ByteOrder.LITTLE_ENDIAN);
        byte verMaj = hdr.get(8);
        byte verMin = hdr.get(9);
        if (verMaj != 1 || verMin != 0) {
            logger.warn("Unsupported Diem module version: %d.%d", new Object[]{(int)verMaj, (int)verMin});
            return false;
        }
        return true;
    }

    public IUnit prepare(String name, IInput input, IUnitProcessor unitProcessor, IUnitCreator parent, Map<Object, Object> identmap) {
        DiemUnit unit = new DiemUnit(name, input, unitProcessor, parent, this.pdm);
        return unit;
    }
}

