/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.Diem;
import com.pnfsoftware.jeb.core.units.code.asm.ChainedOperationResult;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.AbstractNativeDecompilerExtension;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IDecompiledMethod;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.INativeDecompilerContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEStatement;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IEUntranslatedInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardType;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.IWildcardTypeManager;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.IEMasterOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.IEOptFilterCanDiscard;

public class DiemDecompilerExtension
extends AbstractNativeDecompilerExtension {
    public ChainedOperationResult<Boolean> customizeIntermediateOptimizer(INativeDecompilerContext decompiler, IEMasterOptimizer mo) {
        mo.addDisregardedOutputFilter(new IEOptFilterCanDiscard(){

            public boolean check(CFG<IEStatement> cfg, long insnAddress, int regDef) {
                return regDef < 0;
            }
        });
        return ChainedOperationResult.TRUE_CONTINUE;
    }

    public ChainedOperationResult<Boolean> applyAdditionalTypes(IDecompiledMethod target, CFG<IEStatement> cfg) {
        IWildcardTypeManager etypeman = target.getDecompiler().getIntermediateContext().getWildcardTypeManager();
        IWildcardType tBool = etypeman.create("bool");
        IWildcardType tAddress = etypeman.create("address");
        for (IEStatement stm : cfg.instructions()) {
            IEUntranslatedInstruction u;
            if (!(stm instanceof IEUntranslatedInstruction) || !((u = (IEUntranslatedInstruction)stm).getTag() instanceof Integer)) continue;
            Diem.OpcodeDef opcode = Diem.OpcodeDef.fromValue((Integer)u.getTag());
            switch (opcode) {
                case ASSERT: {
                    u.getParameterExpression(1).setType(tBool);
                    break;
                }
                case GET_TXN_SENDER: {
                    u.getReturnExpression().setType(tAddress);
                    break;
                }
            }
        }
        return ChainedOperationResult.TRUE_CONTINUE;
    }
}

