/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.AddressEntry;
import com.pnf.diemvm.BytearrayEntry;
import com.pnf.diemvm.DiemInstruction;
import com.pnf.diemvm.DiemInstructionOperand;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.FieldDef;
import com.pnf.diemvm.FunctionDef;
import com.pnf.diemvm.FunctionHandle;
import com.pnf.diemvm.StringEntry;
import com.pnf.diemvm.StructDef;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.code.CodeDocumentPart;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.IInstructionOperand;
import com.pnfsoftware.jeb.core.units.code.asm.render.GenericCodeFormatter;
import com.pnfsoftware.jeb.core.units.code.asm.render.NumberFormatter;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;

@Ser
public class DiemCodeFormatter
extends GenericCodeFormatter<DiemInstruction> {
    public DiemCodeFormatter() {
        this.setMnemonicRightPaddingLength(0);
    }

    public String generateExtraMethodComment(long address) {
        DiemUnit unit = (DiemUnit)this.getCodeUnit().getParent();
        FunctionDef f = unit.getFunctionByAddress(address);
        if (f == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Diem signature: %s / ", unit.formatObject(f.getHandle(unit).getSignature(unit))));
        sb.append(String.format("Locals: %s", unit.formatObject(f.getCode().getLocals(unit))));
        return sb.toString();
    }

    public void formatInstruction(long address, DiemInstruction insn, CodeDocumentPart out) {
        DiemInstruction _insn = insn;
        String p = String.format("[%d,%d] ", _insn.preExecStackDelta, _insn.postExecStackDelta);
        out.appendAndRecord(p, ItemClassIdentifiers.COMMENT);
        out.append("  ");
        super.formatInstruction(address, (IInstruction)insn, out);
    }

    public void formatOperand(long address, DiemInstruction insn, IInstructionOperand opnd, int opndIndexGlobal, int opndDepth, CodeDocumentPart out) {
        DiemUnit unit = (DiemUnit)this.getCodeUnit().getParent();
        DiemInstruction _insn = insn;
        DiemInstructionOperand _opnd = (DiemInstructionOperand)opnd;
        Object o = _opnd.getObject();
        switch (_opnd.getOperandType()) {
            case Branch: {
                long targetAddress = address + (long)_insn.targetDelta;
                this.formatAddress(targetAddress, out);
                break;
            }
            case ImmUint64: {
                long val = (Long)o;
                NumberFormatter prefs = this.getNumberFormatter(opnd, false);
                if (prefs == null) {
                    prefs = this.getDefaultNumberFormatter();
                }
                String s = prefs.format(64, val);
                out.appendAndRecord(s, ItemClassIdentifiers.IMMEDIATE, this.createItemIdForImmediate(address, opndIndexGlobal));
                break;
            }
            case IdxLocal: {
                out.append("@" + _opnd.getObject());
                break;
            }
            case IdxAddress: {
                out.append(((AddressEntry)unit.addressPool.get((Integer)o)).toString());
                break;
            }
            case IdxByteArray: {
                out.append(((BytearrayEntry)unit.bytearrayPool.get((Integer)o)).toString());
                break;
            }
            case IdxString: {
                String str = ((StringEntry)unit.stringPool.get((Integer)o)).toString();
                out.appendAndRecord(Formatter.escapeString((CharSequence)str), ItemClassIdentifiers.STRING);
                break;
            }
            case IdxFieldDef: {
                out.append(((FieldDef)unit.fieldDefs.get((Integer)o)).getName(unit));
                break;
            }
            case IdxFuncHandle: {
                out.append(((FunctionHandle)unit.functionHandles.get((Integer)o)).getName(unit));
                break;
            }
            case IdxStructDef: {
                out.append(((StructDef)unit.structDefs.get((Integer)o)).getName(unit));
                break;
            }
            default: {
                out.append(opnd.format((IInstruction)insn, address));
            }
        }
    }
}

