/*
 * Decompiled with CFR 0.152.
 */
package com.pnf.diemvm;

import com.pnf.diemvm.DiemInstruction;
import com.pnf.diemvm.DiemObject;
import com.pnf.diemvm.DiemUnit;
import com.pnf.diemvm.LocalSignature;
import com.pnfsoftware.jeb.util.format.TextBuilder;
import com.pnfsoftware.jeb.util.serialization.annotations.Ser;
import com.pnfsoftware.jeb.util.serialization.annotations.SerId;
import java.util.List;

@Ser
class CodeUnit
implements DiemObject {
    @SerId(value=1)
    private int max_stack_size;
    @SerId(value=2)
    private int local_sig_index;
    @SerId(value=3)
    private List<DiemInstruction> insnlist;
    @SerId(value=4)
    private int bytecode_offset;

    public CodeUnit(int max_stack_size, int local_sig_index, List<DiemInstruction> insnlist) {
        this.max_stack_size = max_stack_size;
        this.local_sig_index = local_sig_index;
        this.insnlist = insnlist;
    }

    public int getMaxStackSize() {
        return this.max_stack_size;
    }

    public LocalSignature getLocals(DiemUnit l) {
        return (LocalSignature)l.localSignatures.get(this.local_sig_index);
    }

    public List<DiemInstruction> getInstructions() {
        return this.insnlist;
    }

    public int getInsnFileSize() {
        int size = 0;
        for (DiemInstruction insn : this.insnlist) {
            size += insn.getSize();
        }
        return size;
    }

    public int getInsnFileOffset() {
        return this.bytecode_offset;
    }

    public void setInsnFileOffset(int offset) {
        this.bytecode_offset = offset;
    }

    @Override
    public TextBuilder format(DiemUnit l, TextBuilder t) {
        t.append((CharSequence)"max_stack_size: ").append(this.max_stack_size).eol();
        t.append((CharSequence)"locals: ");
        ((LocalSignature)l.localSignatures.get(this.local_sig_index)).format(l, t).eol();
        int i = 0;
        for (DiemInstruction insn : this.insnlist) {
            t.append((CharSequence)insn.format(i)).eol();
            ++i;
        }
        return t;
    }
}

