/*
 * Decompiled with CFR 0.152.
 */
package specialAlgorithm;

import entities.ByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.SpecialAlgorithm;

public class MSSQL2012
implements SpecialAlgorithm {
    private MessageDigest m = null;

    public MSSQL2012() {
        try {
            this.m = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toHash(byte[] b) {
        return "0x" + DatatypeConverter.printHexBinary((byte[])b);
    }

    @Override
    public final String crypt(String password, String salt) {
        byte[] salt1 = null;
        if (salt == null) {
            salt1 = new byte[4];
            new Random().nextBytes(salt1);
        } else {
            salt1 = salt.getBytes();
        }
        return this.toHash(this.cryptPerf(password.getBytes(), salt1));
    }

    @Override
    public final byte[] cryptPerf(byte[] password, byte[] salt) {
        byte[] bhash = null;
        byte[] saltedPassword = null;
        byte[] bpassword = ByteArray.toUTF16LE(password);
        saltedPassword = ByteArray.concat(bpassword, salt);
        this.m.update(saltedPassword);
        byte[] bhashIntermediate = this.m.digest();
        byte[] constant = new byte[]{2, 0};
        bhash = new byte[]{constant[0], constant[1]};
        bhash = ByteArray.concat(bhash, salt);
        bhash = ByteArray.concat(bhash, bhashIntermediate);
        return bhash;
    }

    @Override
    public byte[] getSaltFromHash(byte[] hash) {
        byte[] salt = new byte[4];
        int auxIndex = 0;
        int i = 2;
        while (i < 6) {
            salt[auxIndex] = hash[i];
            ++auxIndex;
            ++i;
        }
        return salt;
    }

    @Override
    public byte[] appendSaltToWord(byte[] word, byte[] salt) {
        return ByteArray.concat(word, salt);
    }

    @Override
    public final byte[] toByteArray(String hash) {
        int separatorPos = hash.indexOf(120);
        String hexHash = hash.substring(separatorPos + 1, hash.length());
        return DatatypeConverter.parseHexBinary((String)hexHash);
    }
}

