/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.AuxiliaryForDecryptThreads;
import entities.AvailableCharsets;
import java.util.List;

public final class DictionaryRuleProcessor {
    private int min_length = 4;
    private int max_length = 16;
    private StringBuilder memory;
    private static final String VOWELS = "aeiouAEIOU";
    private static final String CONSONANTS = "bcdfghjklmn\u00f1pqrstvwxyzBCDFGHJKLMN\u00d1PQRSTVWXYZ";
    private static final String PUNCTUATION = ".,:;'?!`\"";
    private static final String SYMBOLS = "$%^&*()-_+=|\\<>[]{}#@/~";
    private static final String ED_STR = "ed";
    private static final String ING_STR = "ing";
    private static final char[] NUMERIC_CONSTANTS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public DictionaryRuleProcessor() {
    }

    public DictionaryRuleProcessor(int min_length, int max_length) {
        this.min_length = min_length;
        this.max_length = max_length;
    }

    public int getMin_length() {
        return this.min_length;
    }

    public void setMin_length(int min_length) {
        this.min_length = min_length;
    }

    public int getMax_length() {
        return this.max_length;
    }

    public void setMax_length(int max_length) {
        this.max_length = max_length;
    }

    public StringBuilder getMemory() {
        return this.memory;
    }

    public void setMemory(StringBuilder memory) {
        this.memory = new StringBuilder(memory.toString());
    }

    public boolean rejectConditionList(List<String> conditions, StringBuilder word) {
        boolean returnValue = false;
        for (String cond : conditions) {
            returnValue = this.rejectCondition(cond, word);
            if (returnValue) break;
        }
        return returnValue;
    }

    public boolean rejectCondition(String condition, StringBuilder word) {
        String options;
        boolean returnValue = false;
        char charClass = condition.charAt(0);
        if (charClass == '-') {
            if (condition.length() > 1) {
                char c2 = condition.charAt(1);
                if (c2 == ':') {
                    return false;
                }
                if (c2 == 'c' || c2 == '8' || c2 == 's' || c2 == 'p') {
                    returnValue = false;
                }
            } else {
                System.out.println("Wrong length of condition!: " + condition);
                return true;
            }
        }
        if ((options = condition.substring(1, condition.length())).length() == 0 && charClass != 'Q') {
            System.out.println("Wrong length of condition!: " + condition);
            return true;
        }
        if (charClass == 'Q') {
            return AuxiliaryForDecryptThreads.equalsTo(this.memory, word);
        }
        if (charClass == '>') {
            returnValue = this.rejectUnlessLengthGraterThan(options.charAt(0), word);
        } else if (charClass == '<') {
            returnValue = this.rejectUnlessLengthLessThan(options.charAt(0), word);
        } else if (charClass == '!') {
            returnValue = this.rejectContains(options, word);
        } else if (charClass == '/') {
            returnValue = !this.rejectContains(options, word);
        } else if (charClass == '=') {
            if (options.length() == 2 || options.length() == 3) {
                int position = Character.getNumericValue(options.charAt(0));
                returnValue = this.rejectUnlessCharacterAtPosition(position, options.substring(1), word);
            } else {
                System.err.println("[rejectCondition] error in condition =");
            }
        } else if (charClass == '(') {
            int position = 0;
            returnValue = this.rejectUnlessCharacterAtPosition(position, options, word);
        } else if (charClass == ')') {
            int position = word.length() - 1;
            returnValue = this.rejectUnlessCharacterAtPosition(position, options, word);
        } else if (charClass == '%') {
            returnValue = this.rejectUnlessContainsMoreThanOneInstanceOf(options, word);
        }
        return returnValue;
    }

    private boolean rejectUnlessContainsMoreThanOneInstanceOf(String options, StringBuilder word) {
        int instances = Character.getNumericValue(options.charAt(0));
        boolean returnValue = false;
        int count = Integer.MIN_VALUE;
        if (options.length() == 2) {
            count = this.countInstancesOfChar(options.charAt(1), word);
        } else if (options.length() == 3) {
            if (options.charAt(1) == '?') {
                count = this.countInstancesOfCharSet(options.charAt(2), word);
            } else {
                System.err.println("[rejectUnlessContainsMoreThanOneInstanceOf] wrong rule");
            }
        } else {
            System.err.println("[rejectUnlessContainsMoreThanOneInstanceOf] wrong rule");
        }
        returnValue = count < instances;
        return returnValue;
    }

    private int countInstancesOfCharSet(char option, StringBuilder word) {
        String myCharset = null;
        boolean charsetIn = true;
        if (option == '?') {
            myCharset = "?";
        } else if (option == 'v') {
            myCharset = VOWELS;
        } else if (option == 'V') {
            myCharset = VOWELS;
            charsetIn = false;
        } else if (option == 'c') {
            myCharset = CONSONANTS;
        } else if (option == 'C') {
            myCharset = CONSONANTS;
            charsetIn = false;
        } else if (option == 'w') {
            myCharset = " ";
        } else if (option == 'W') {
            myCharset = " ";
            charsetIn = false;
        } else if (option == 'p') {
            myCharset = PUNCTUATION;
        } else if (option == 'P') {
            myCharset = PUNCTUATION;
            charsetIn = false;
        } else if (option == 's') {
            myCharset = SYMBOLS;
        } else if (option == 'S') {
            myCharset = SYMBOLS;
            charsetIn = false;
        } else if (option == 'l') {
            myCharset = AvailableCharsets.getCharsetByName("loweralpha");
        } else if (option == 'L') {
            myCharset = AvailableCharsets.getCharsetByName("loweralpha");
            charsetIn = false;
        } else if (option == 'u') {
            myCharset = AvailableCharsets.getCharsetByName("alpha");
        } else if (option == 'U') {
            myCharset = AvailableCharsets.getCharsetByName("alpha");
            charsetIn = false;
        } else if (option == 'd') {
            myCharset = AvailableCharsets.getCharsetByName("numeric");
        } else if (option == 'D') {
            myCharset = AvailableCharsets.getCharsetByName("numeric");
            charsetIn = false;
        } else if (option == 'a') {
            myCharset = AvailableCharsets.getCharsetByName("mixalpha");
        } else if (option == 'A') {
            myCharset = AvailableCharsets.getCharsetByName("mixalpha");
            charsetIn = false;
        } else if (option == 'x') {
            myCharset = AvailableCharsets.getCharsetByName("mixalpha-numeric");
        } else if (option == 'X') {
            myCharset = AvailableCharsets.getCharsetByName("mixalpha-numeric");
            charsetIn = false;
        } else if (option == 'z') {
            myCharset = AvailableCharsets.getCharsetByName("ascii-32-95");
        } else if (option == 'Z') {
            myCharset = AvailableCharsets.getCharsetByName("ascii-32-95");
            charsetIn = false;
        } else {
            System.err.println("[countInstancesOfCharSet] invalid charset!!!");
            return 0;
        }
        int charsetLength = myCharset.length();
        int wordLength = word.length();
        int count = 0;
        if (charsetIn) {
            int i = 0;
            while (i < wordLength) {
                char aux = word.charAt(i);
                int j = 0;
                while (j < charsetLength) {
                    if (aux == myCharset.charAt(j)) {
                        ++count;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            boolean ok = true;
            int i = 0;
            while (i < wordLength) {
                char aux = word.charAt(i);
                int j = 0;
                while (j < charsetLength) {
                    if (aux == myCharset.charAt(j)) {
                        ok = false;
                        break;
                    }
                    ++j;
                }
                if (ok) {
                    ++count;
                } else {
                    ok = true;
                }
                ++i;
            }
        }
        return count;
    }

    private int countInstancesOfChar(char c, StringBuilder word) {
        int count = 0;
        int wordLength = word.length();
        int i = 0;
        while (i < wordLength) {
            if (c == word.charAt(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private boolean rejectUnlessCharacterAtPosition(int position, String options, StringBuilder word) {
        boolean returnValue = false;
        if (options.length() == 1) {
            returnValue = options.charAt(0) != word.charAt(position);
        } else if (options.length() == 2) {
            if (options.charAt(0) == '?') {
                char ca = word.charAt(position);
                returnValue = !this.containsCharacterClass(options.charAt(1), ca);
            } else {
                System.err.println("[rejectUnlessCharacterAtPosition] wrong rule!");
                returnValue = true;
            }
        }
        return returnValue;
    }

    private boolean rejectContains(String options, StringBuilder word) {
        int opLength = options.length();
        boolean returnValue = false;
        if (opLength == 1) {
            char c = options.charAt(0);
            returnValue = this.containsCharacter(c, word);
        } else if (opLength == 2) {
            char charClass = options.charAt(0);
            char option = options.charAt(1);
            returnValue = charClass != '?' ? false : this.containsCharacterClass(option, word);
        }
        return returnValue;
    }

    private boolean containsCharacterClass(char option, StringBuilder word) {
        boolean returnValue = false;
        String charset = "";
        if (option == '?') {
            returnValue = this.containsCharacter('?', word);
        } else if (option == 'v') {
            charset = VOWELS;
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'V') {
            charset = VOWELS;
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'c') {
            charset = CONSONANTS;
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'C') {
            charset = CONSONANTS;
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'w') {
            returnValue = this.containsCharacter(' ', word);
        } else if (option == 'W') {
            returnValue = !this.containsCharacter(' ', word);
        } else if (option == 'p') {
            charset = PUNCTUATION;
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'P') {
            charset = PUNCTUATION;
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 's') {
            charset = SYMBOLS;
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'S') {
            charset = SYMBOLS;
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'l') {
            charset = AvailableCharsets.getCharsetByName("loweralpha");
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'L') {
            charset = AvailableCharsets.getCharsetByName("loweralpha");
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'u') {
            charset = AvailableCharsets.getCharsetByName("alpha");
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'U') {
            charset = AvailableCharsets.getCharsetByName("alpha");
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'd') {
            charset = AvailableCharsets.getCharsetByName("numeric");
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'D') {
            charset = AvailableCharsets.getCharsetByName("numeric");
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'a') {
            charset = AvailableCharsets.getCharsetByName("mixalpha");
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'A') {
            charset = AvailableCharsets.getCharsetByName("mixalpha");
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'x') {
            charset = AvailableCharsets.getCharsetByName("mixalpha-numeric");
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'X') {
            charset = AvailableCharsets.getCharsetByName("mixalpha-numeric");
            returnValue = !this.onlyContainsCharset(charset, word);
        } else if (option == 'z') {
            charset = AvailableCharsets.getCharsetByName("ascii-32-95");
            returnValue = this.containsCharset(charset, word);
        } else if (option == 'Z') {
            charset = AvailableCharsets.getCharsetByName("ascii-32-95");
            returnValue = !this.onlyContainsCharset(charset, word);
        }
        return returnValue;
    }

    private boolean containsCharacterClass(char option, char c) {
        boolean returnValue = false;
        String charset = "";
        if (option == '?') {
            returnValue = '?' == c;
        } else if (option == 'v') {
            charset = VOWELS;
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'V') {
            charset = VOWELS;
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'c') {
            charset = CONSONANTS;
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'C') {
            charset = CONSONANTS;
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'w') {
            returnValue = ' ' == c;
        } else if (option == 'W') {
            returnValue = ' ' != c;
        } else if (option == 'p') {
            charset = PUNCTUATION;
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'P') {
            charset = PUNCTUATION;
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 's') {
            charset = SYMBOLS;
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'S') {
            charset = SYMBOLS;
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'l') {
            charset = AvailableCharsets.getCharsetByName("loweralpha");
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'L') {
            charset = AvailableCharsets.getCharsetByName("loweralpha");
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'u') {
            charset = AvailableCharsets.getCharsetByName("alpha");
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'U') {
            charset = AvailableCharsets.getCharsetByName("alpha");
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'd') {
            charset = AvailableCharsets.getCharsetByName("numeric");
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'D') {
            charset = AvailableCharsets.getCharsetByName("numeric");
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'a') {
            charset = AvailableCharsets.getCharsetByName("mixalpha");
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'A') {
            charset = AvailableCharsets.getCharsetByName("mixalpha");
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'x') {
            charset = AvailableCharsets.getCharsetByName("mixalpha-numeric");
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'X') {
            charset = AvailableCharsets.getCharsetByName("mixalpha-numeric");
            returnValue = !this.onlyContainsCharset(charset, c);
        } else if (option == 'z') {
            charset = AvailableCharsets.getCharsetByName("ascii-32-95");
            returnValue = this.containsCharset(charset, c);
        } else if (option == 'Z') {
            charset = AvailableCharsets.getCharsetByName("ascii-32-95");
            returnValue = !this.onlyContainsCharset(charset, c);
        }
        return returnValue;
    }

    private boolean containsCharset(String charset, StringBuilder word) {
        boolean returnValue = false;
        int wordLength = word.length();
        int charsetLength = charset.length();
        int i = 0;
        block0: while (i < wordLength) {
            char aux1 = word.charAt(i);
            int j = 0;
            while (j < charsetLength) {
                if (aux1 == charset.charAt(j)) {
                    returnValue = true;
                    break block0;
                }
                ++j;
            }
            ++i;
        }
        return returnValue;
    }

    private boolean containsCharset(String charset, char c) {
        boolean returnValue = false;
        int charsetLength = charset.length();
        int j = 0;
        while (j < charsetLength) {
            if (c == charset.charAt(j)) {
                returnValue = true;
                break;
            }
            ++j;
        }
        return returnValue;
    }

    private boolean onlyContainsCharset(String charset, StringBuilder word) {
        int wordLength = word.length();
        int charsetLength = charset.length();
        boolean ok = false;
        int i = 0;
        while (i < wordLength) {
            ok = false;
            char aux1 = word.charAt(i);
            ok = false;
            int j = 0;
            while (j < charsetLength) {
                if (aux1 == charset.charAt(j)) {
                    ok = true;
                    break;
                }
                ++j;
            }
            if (!ok) break;
            ++i;
        }
        return ok;
    }

    private boolean onlyContainsCharset(String charset, char c) {
        int charsetLength = charset.length();
        boolean ok = false;
        int j = 0;
        while (j < charsetLength) {
            if (c == charset.charAt(j)) {
                ok = true;
                break;
            }
            ++j;
        }
        return ok;
    }

    private boolean containsCharacter(char c, StringBuilder word) {
        boolean returnValue = false;
        int wordLength = word.length();
        int i = 0;
        while (i < wordLength) {
            if (word.charAt(i) == c) {
                returnValue = true;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    private int isNumericConstant(char c) {
        int returnValue = -1;
        if (c == '*') {
            returnValue = this.max_length;
        } else if (c == '+') {
            returnValue = this.max_length + 1;
        } else if (c == '-') {
            returnValue = this.max_length - 1;
        } else if (c == 'l') {
            returnValue = this.memory.length();
        } else if (c == 'm') {
            returnValue = this.memory.length() - 1;
        } else {
            int i = 0;
            while (i < NUMERIC_CONSTANTS.length) {
                if (c == NUMERIC_CONSTANTS[i]) {
                    returnValue = i + 10;
                    break;
                }
                ++i;
            }
        }
        return returnValue;
    }

    private boolean rejectUnlessLengthLessThan(char option, StringBuilder word) {
        boolean returnValue = false;
        int lengthValue = this.isNumericConstant(option);
        returnValue = lengthValue == -1 ? word.length() >= Character.getNumericValue(option) : word.length() >= lengthValue;
        return returnValue;
    }

    private boolean rejectUnlessLengthGraterThan(char option, StringBuilder word) {
        boolean returnValue = false;
        int lengthValue = this.isNumericConstant(option);
        returnValue = lengthValue == -1 ? word.length() <= Character.getNumericValue(option) : word.length() <= lengthValue;
        return returnValue;
    }

    public StringBuilder applyRuleActionList(StringBuilder word, List<String> actions) {
        for (String action : actions) {
            word = this.applyAction(word, action);
        }
        return word;
    }

    public StringBuilder applyAction(StringBuilder word, String action) {
        if (action.length() == 0) {
            System.out.println("ERROR! Bad action definition! (ignoring it...)");
            return word;
        }
        char c = action.charAt(0);
        if (c == ':') {
            return word;
        }
        StringBuilder returnValue = null;
        char o = '\u0000';
        StringBuilder options = new StringBuilder();
        if (action.length() > 1) {
            o = action.charAt(1);
            options.append(action.substring(1, action.length()));
        }
        if (c == 's') {
            StringBuilder aux = new StringBuilder();
            if (action.length() <= 1) {
                System.out.println("ERROR! Bad action definition! (ignoring it...)");
                return word;
            }
            char auxc = action.charAt(1);
            int wordLength = word.length();
            char ca = '\u0000';
            if (auxc != '?') {
                char X = action.charAt(1);
                if (action.length() <= 2) {
                    System.out.println("ERROR! Bad action definition! (ignoring it...)");
                    return word;
                }
                char Y = action.charAt(2);
                int i = 0;
                while (i < wordLength) {
                    ca = word.charAt(i);
                    if (ca == X) {
                        aux.append(Y);
                    } else {
                        aux.append(ca);
                    }
                    ++i;
                }
            } else {
                if (action.length() <= 3) {
                    System.out.println("ERROR! Bad action definition! (ignoring it...)");
                    return word;
                }
                char myClass = action.charAt(2);
                char Y = action.charAt(3);
                int i = 0;
                while (i < wordLength) {
                    ca = word.charAt(i);
                    if (this.containsCharacterClass(myClass, ca)) {
                        aux.append(Y);
                    } else {
                        aux.append(ca);
                    }
                    ++i;
                }
            }
            returnValue = aux;
        } else if (c == '@') {
            StringBuilder aux = new StringBuilder();
            if (action.length() <= 1) {
                System.out.println("ERROR! Bad action definition! (ignoring it...)");
                return word;
            }
            char auxc = action.charAt(1);
            int wordLength = word.length();
            char ca = '\u0000';
            if (auxc != '?') {
                char X = action.charAt(1);
                int i = 0;
                while (i < wordLength) {
                    ca = word.charAt(i);
                    if (ca != X) {
                        aux.append(ca);
                    }
                    ++i;
                }
            } else {
                if (action.length() <= 2) {
                    System.out.println("ERROR! Bad action definition! (ignoring it...)");
                    return word;
                }
                char myClass = action.charAt(2);
                int i = 0;
                while (i < wordLength) {
                    ca = word.charAt(i);
                    if (!this.containsCharacterClass(myClass, ca)) {
                        aux.append(ca);
                    }
                    ++i;
                }
            }
            returnValue = aux;
        } else if (c == 'S') {
            StringBuilder aux = new StringBuilder();
            int wordLength = word.length();
            int i = 0;
            while (i < wordLength) {
                char ca = word.charAt(i);
                aux.append(this.getShiftCharacterCase(ca));
                ++i;
            }
            returnValue = aux;
        } else if (c == 'V') {
            StringBuilder aux = new StringBuilder();
            int wordLength = word.length();
            int i = 0;
            while (i < wordLength) {
                char ca = word.charAt(i);
                if (this.containsCharset(CONSONANTS, ca)) {
                    aux.append(Character.toUpperCase(ca));
                } else if (this.containsCharset(VOWELS, ca)) {
                    aux.append(Character.toLowerCase(ca));
                } else {
                    aux.append(ca);
                }
                ++i;
            }
            returnValue = aux;
        } else if (c == 'R') {
            StringBuilder aux = new StringBuilder();
            int wordLength = word.length();
            int i = 0;
            while (i < wordLength) {
                char ca = word.charAt(i);
                aux.append(this.getShiftCharacterRight(ca));
                ++i;
            }
            returnValue = aux;
        } else if (c == 'L') {
            StringBuilder aux = new StringBuilder();
            int wordLength = word.length();
            int i = 0;
            while (i < wordLength) {
                char ca = word.charAt(i);
                aux.append(this.getShiftCharacterLeft(ca));
                ++i;
            }
            returnValue = aux;
        } else if (c == 'p') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            aux.append('s');
            returnValue = aux;
        } else if (c == 'P') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            aux.append(ED_STR);
            returnValue = aux;
        } else if (c == 'I') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            int lastCharPosition = word.length() - 1;
            char ca = word.charAt(lastCharPosition);
            if (this.containsCharset(VOWELS, ca)) {
                aux.deleteCharAt(lastCharPosition);
            }
            aux.append(ING_STR);
            returnValue = aux;
        } else if (c == '\'') {
            StringBuilder aux = new StringBuilder();
            int lengthValue = this.isNumericConstant(o);
            int pos = 0;
            pos = lengthValue == -1 ? Character.getNumericValue(o) : lengthValue;
            if (pos <= word.length()) {
                int i = 0;
                while (i < pos) {
                    aux.append(word.charAt(i));
                    ++i;
                }
            } else {
                aux.append((CharSequence)word);
            }
            returnValue = aux;
        } else if (c == 'l') {
            StringBuilder aux = new StringBuilder();
            int i = 0;
            while (i < word.length()) {
                aux.append(Character.toLowerCase(word.charAt(i)));
                ++i;
            }
            returnValue = aux;
        } else if (c == 'u') {
            StringBuilder aux = new StringBuilder();
            int i = 0;
            while (i < word.length()) {
                aux.append(Character.toUpperCase(word.charAt(i)));
                ++i;
            }
            returnValue = aux;
        } else if (c == 'c') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            if (word.length() == 0) {
                returnValue = new StringBuilder(word);
            } else {
                aux.setCharAt(0, Character.toUpperCase(word.charAt(0)));
                returnValue = aux;
            }
        } else if (c == 'C') {
            StringBuilder aux = new StringBuilder();
            if (word.length() == 0) {
                aux.append((CharSequence)word);
            } else {
                aux.append(Character.toLowerCase(word.charAt(0)));
                int i = 1;
                while (i < word.length()) {
                    aux.append(Character.toUpperCase(word.charAt(i)));
                    ++i;
                }
            }
            returnValue = aux;
        } else if (c == 't') {
            StringBuilder aux = new StringBuilder();
            int wordLength = word.length();
            char ca = '\u0000';
            int i = 0;
            while (i < wordLength) {
                ca = word.charAt(i);
                if (this.containsCharacterClass('l', ca)) {
                    aux.append(Character.toUpperCase(ca));
                } else if (this.containsCharacterClass('u', ca)) {
                    aux.append(Character.toLowerCase(ca));
                } else {
                    aux.append(ca);
                }
                ++i;
            }
            returnValue = aux;
        } else if (c == 'T') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            int lengthValue = this.isNumericConstant(o);
            int pos = 0;
            pos = lengthValue == -1 ? Character.getNumericValue(o) : lengthValue;
            if (pos < word.length()) {
                char ca = word.charAt(pos);
                if (this.containsCharacterClass('l', ca)) {
                    aux.setCharAt(pos, Character.toUpperCase(ca));
                } else if (this.containsCharacterClass('u', ca)) {
                    aux.setCharAt(pos, Character.toLowerCase(ca));
                }
            }
            returnValue = aux;
        } else if (c == 'r') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            aux.reverse();
            returnValue = aux;
        } else if (c == 'd') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            aux.append((CharSequence)word);
            returnValue = aux;
        } else if (c == 'f') {
            StringBuilder aux1 = new StringBuilder();
            StringBuilder aux2 = new StringBuilder();
            aux1.append((CharSequence)word);
            aux2.append((CharSequence)word);
            aux1.reverse();
            aux2.append((CharSequence)aux1);
            returnValue = aux2;
        } else if (c == '{') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            if (word.length() != 0) {
                aux.deleteCharAt(0);
                aux.append(word.charAt(0));
            }
            returnValue = aux;
        } else if (c == '}') {
            int lastCharPosition = word.length() - 1;
            StringBuilder aux = new StringBuilder();
            aux.append(word.charAt(lastCharPosition));
            aux.append((CharSequence)word);
            aux.deleteCharAt(lastCharPosition + 1);
            returnValue = aux;
        } else if (c == '$') {
            StringBuilder aux = new StringBuilder(word);
            aux.insert(aux.length(), o);
            returnValue = aux;
        } else if (c == '^') {
            StringBuilder aux = new StringBuilder(word);
            aux.insert(0, o);
            returnValue = aux;
        } else if (c == '[') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            if (word.length() != 0) {
                aux.deleteCharAt(0);
            }
            returnValue = aux;
        } else if (c == ']') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            if (word.length() != 0) {
                aux.deleteCharAt(word.length() - 1);
            }
            returnValue = aux;
        } else if (c == 'D') {
            StringBuilder aux = new StringBuilder();
            aux.append((CharSequence)word);
            try {
                int pos = Integer.parseInt(options.toString());
                if (word.length() > pos) {
                    aux.deleteCharAt(pos);
                }
            }
            catch (Exception pos) {
                // empty catch block
            }
            returnValue = aux;
        } else if (c == 'M') {
            this.memory = new StringBuilder(word);
            returnValue = new StringBuilder(word);
        } else if (c == 'X') {
            if (options.length() == 3) {
                int startPos = 0;
                int endPos = 0;
                int insertPos = 0;
                char myChar = options.charAt(0);
                int aux = this.isNumericConstant(myChar);
                startPos = aux == -1 ? Character.getNumericValue(myChar) : aux;
                myChar = options.charAt(1);
                aux = this.isNumericConstant(myChar);
                endPos = aux == -1 ? Character.getNumericValue(myChar) : aux;
                myChar = options.charAt(2);
                aux = this.isNumericConstant(myChar);
                insertPos = aux == -1 ? Character.getNumericValue(myChar) : aux;
                StringBuilder pre1 = new StringBuilder();
                pre1.append(this.memory.substring(startPos, endPos));
                returnValue = new StringBuilder();
                returnValue.append(word.substring(0, insertPos));
                returnValue.append((CharSequence)pre1);
                returnValue.append(word.substring(insertPos));
            } else {
                returnValue = new StringBuilder(word);
            }
        } else {
            returnValue = new StringBuilder("NULL(unknow_rule)");
        }
        return returnValue;
    }

    private char getShiftCharacterCase(char c) {
        if (c == ' ') {
            c = (char)32;
        } else if (c == '!') {
            c = (char)49;
        } else if (c == '\"') {
            c = (char)39;
        } else if (c == '#') {
            c = (char)51;
        } else if (c == '$') {
            c = (char)52;
        } else if (c == '%') {
            c = (char)53;
        } else if (c == '&') {
            c = (char)55;
        } else if (c == '\'') {
            c = (char)34;
        } else if (c == '(') {
            c = (char)57;
        } else if (c == ')') {
            c = (char)48;
        } else if (c == '*') {
            c = (char)56;
        } else if (c == '+') {
            c = (char)61;
        } else if (c == ',') {
            c = (char)60;
        } else if (c == '-') {
            c = (char)95;
        } else if (c == '.') {
            c = (char)62;
        } else if (c == '/') {
            c = (char)63;
        } else if (c == '0') {
            c = (char)41;
        } else if (c == '1') {
            c = (char)33;
        } else if (c == '2') {
            c = (char)64;
        } else if (c == '3') {
            c = (char)35;
        } else if (c == '4') {
            c = (char)36;
        } else if (c == '5') {
            c = (char)37;
        } else if (c == '6') {
            c = (char)94;
        } else if (c == '7') {
            c = (char)38;
        } else if (c == '8') {
            c = (char)42;
        } else if (c == '9') {
            c = (char)40;
        } else if (c == ':') {
            c = (char)59;
        } else if (c == ';') {
            c = (char)58;
        } else if (c == '<') {
            c = (char)44;
        } else if (c == '=') {
            c = (char)43;
        } else if (c == '>') {
            c = (char)46;
        } else if (c == '?') {
            c = (char)47;
        } else if (c == '@') {
            c = (char)50;
        } else if (c == 'A') {
            c = (char)97;
        } else if (c == 'B') {
            c = (char)98;
        } else if (c == 'C') {
            c = (char)99;
        } else if (c == 'D') {
            c = (char)100;
        } else if (c == 'E') {
            c = (char)101;
        } else if (c == 'F') {
            c = (char)102;
        } else if (c == 'G') {
            c = (char)103;
        } else if (c == 'H') {
            c = (char)104;
        } else if (c == 'I') {
            c = (char)105;
        } else if (c == 'J') {
            c = (char)106;
        } else if (c == 'K') {
            c = (char)107;
        } else if (c == 'L') {
            c = (char)108;
        } else if (c == 'M') {
            c = (char)109;
        } else if (c == 'N') {
            c = (char)110;
        } else if (c == 'O') {
            c = (char)111;
        } else if (c == 'P') {
            c = (char)112;
        } else if (c == 'Q') {
            c = (char)113;
        } else if (c == 'R') {
            c = (char)114;
        } else if (c == 'S') {
            c = (char)115;
        } else if (c == 'T') {
            c = (char)116;
        } else if (c == 'U') {
            c = (char)117;
        } else if (c == 'V') {
            c = (char)118;
        } else if (c == 'W') {
            c = (char)119;
        } else if (c == 'X') {
            c = (char)120;
        } else if (c == 'Y') {
            c = (char)121;
        } else if (c == 'Z') {
            c = (char)122;
        } else if (c == '[') {
            c = (char)123;
        } else if (c == '\\') {
            c = (char)124;
        } else if (c == ']') {
            c = (char)125;
        } else if (c == '^') {
            c = (char)54;
        } else if (c == '_') {
            c = (char)45;
        } else if (c == '`') {
            c = (char)126;
        } else if (c == 'a') {
            c = (char)65;
        } else if (c == 'b') {
            c = (char)66;
        } else if (c == 'c') {
            c = (char)67;
        } else if (c == 'd') {
            c = (char)68;
        } else if (c == 'e') {
            c = (char)69;
        } else if (c == 'f') {
            c = (char)70;
        } else if (c == 'g') {
            c = (char)71;
        } else if (c == 'h') {
            c = (char)72;
        } else if (c == 'i') {
            c = (char)73;
        } else if (c == 'j') {
            c = (char)74;
        } else if (c == 'k') {
            c = (char)75;
        } else if (c == 'l') {
            c = (char)76;
        } else if (c == 'm') {
            c = (char)77;
        } else if (c == 'n') {
            c = (char)78;
        } else if (c == 'o') {
            c = (char)79;
        } else if (c == 'p') {
            c = (char)80;
        } else if (c == 'q') {
            c = (char)81;
        } else if (c == 'r') {
            c = (char)82;
        } else if (c == 's') {
            c = (char)83;
        } else if (c == 't') {
            c = (char)84;
        } else if (c == 'u') {
            c = (char)85;
        } else if (c == 'v') {
            c = (char)86;
        } else if (c == 'w') {
            c = (char)87;
        } else if (c == 'x') {
            c = (char)88;
        } else if (c == 'y') {
            c = (char)89;
        } else if (c == 'z') {
            c = (char)90;
        } else if (c == '{') {
            c = (char)91;
        } else if (c == '|') {
            c = (char)92;
        } else if (c == '}') {
            c = (char)93;
        } else if (c == '~') {
            c = (char)96;
        }
        return c;
    }

    private char getShiftCharacterRight(char c) {
        if (c == ' ') {
            c = (char)32;
        } else if (c == '!') {
            c = (char)64;
        } else if (c == '\"') {
            c = (char)34;
        } else if (c == '#') {
            c = (char)36;
        } else if (c == '$') {
            c = (char)37;
        } else if (c == '%') {
            c = (char)94;
        } else if (c == '&') {
            c = (char)42;
        } else if (c == '\'') {
            c = (char)39;
        } else if (c == '(') {
            c = (char)41;
        } else if (c == ')') {
            c = (char)95;
        } else if (c == '*') {
            c = (char)40;
        } else if (c == '+') {
            c = (char)124;
        } else if (c == ',') {
            c = (char)46;
        } else if (c == '-') {
            c = (char)61;
        } else if (c == '.') {
            c = (char)47;
        } else if (c == '/') {
            c = (char)92;
        } else if (c == '0') {
            c = (char)45;
        } else if (c == '1') {
            c = (char)50;
        } else if (c == '2') {
            c = (char)51;
        } else if (c == '3') {
            c = (char)52;
        } else if (c == '4') {
            c = (char)53;
        } else if (c == '5') {
            c = (char)54;
        } else if (c == '6') {
            c = (char)55;
        } else if (c == '7') {
            c = (char)56;
        } else if (c == '8') {
            c = (char)57;
        } else if (c == '9') {
            c = (char)48;
        } else if (c == ':') {
            c = (char)34;
        } else if (c == ';') {
            c = (char)39;
        } else if (c == '<') {
            c = (char)62;
        } else if (c == '=') {
            c = (char)92;
        } else if (c == '>') {
            c = (char)63;
        } else if (c == '?') {
            c = (char)124;
        } else if (c == '@') {
            c = (char)35;
        } else if (c == 'A') {
            c = (char)83;
        } else if (c == 'B') {
            c = (char)78;
        } else if (c == 'C') {
            c = (char)86;
        } else if (c == 'D') {
            c = (char)70;
        } else if (c == 'E') {
            c = (char)82;
        } else if (c == 'F') {
            c = (char)71;
        } else if (c == 'G') {
            c = (char)72;
        } else if (c == 'H') {
            c = (char)74;
        } else if (c == 'I') {
            c = (char)79;
        } else if (c == 'J') {
            c = (char)75;
        } else if (c == 'K') {
            c = (char)76;
        } else if (c == 'L') {
            c = (char)58;
        } else if (c == 'M') {
            c = (char)60;
        } else if (c == 'N') {
            c = (char)77;
        } else if (c == 'O') {
            c = (char)80;
        } else if (c == 'P') {
            c = (char)123;
        } else if (c == 'Q') {
            c = (char)87;
        } else if (c == 'R') {
            c = (char)84;
        } else if (c == 'S') {
            c = (char)68;
        } else if (c == 'T') {
            c = (char)89;
        } else if (c == 'U') {
            c = (char)73;
        } else if (c == 'V') {
            c = (char)66;
        } else if (c == 'W') {
            c = (char)69;
        } else if (c == 'X') {
            c = (char)67;
        } else if (c == 'Y') {
            c = (char)85;
        } else if (c == 'Z') {
            c = (char)88;
        } else if (c == '[') {
            c = (char)93;
        } else if (c == '\\') {
            c = (char)92;
        } else if (c == ']') {
            c = (char)93;
        } else if (c == '^') {
            c = (char)38;
        } else if (c == '_') {
            c = (char)43;
        } else if (c == '`') {
            c = (char)49;
        } else if (c == 'a') {
            c = (char)115;
        } else if (c == 'b') {
            c = (char)110;
        } else if (c == 'c') {
            c = (char)118;
        } else if (c == 'd') {
            c = (char)102;
        } else if (c == 'e') {
            c = (char)114;
        } else if (c == 'f') {
            c = (char)103;
        } else if (c == 'g') {
            c = (char)104;
        } else if (c == 'h') {
            c = (char)106;
        } else if (c == 'i') {
            c = (char)111;
        } else if (c == 'j') {
            c = (char)107;
        } else if (c == 'k') {
            c = (char)108;
        } else if (c == 'l') {
            c = (char)59;
        } else if (c == 'm') {
            c = (char)44;
        } else if (c == 'n') {
            c = (char)109;
        } else if (c == 'o') {
            c = (char)112;
        } else if (c == 'p') {
            c = (char)91;
        } else if (c == 'q') {
            c = (char)119;
        } else if (c == 'r') {
            c = (char)116;
        } else if (c == 's') {
            c = (char)100;
        } else if (c == 't') {
            c = (char)121;
        } else if (c == 'u') {
            c = (char)105;
        } else if (c == 'v') {
            c = (char)98;
        } else if (c == 'w') {
            c = (char)101;
        } else if (c == 'x') {
            c = (char)99;
        } else if (c == 'y') {
            c = (char)117;
        } else if (c == 'z') {
            c = (char)120;
        } else if (c == '{') {
            c = (char)125;
        } else if (c == '|') {
            c = (char)124;
        } else if (c == '}') {
            c = (char)125;
        } else if (c == '~') {
            c = (char)33;
        }
        return c;
    }

    private char getShiftCharacterLeft(char c) {
        if (c == ' ') {
            c = (char)32;
        } else if (c == '!') {
            c = (char)126;
        } else if (c == '\"') {
            c = (char)58;
        } else if (c == '#') {
            c = (char)64;
        } else if (c == '$') {
            c = (char)35;
        } else if (c == '%') {
            c = (char)36;
        } else if (c == '&') {
            c = (char)94;
        } else if (c == '\'') {
            c = (char)59;
        } else if (c == '(') {
            c = (char)42;
        } else if (c == ')') {
            c = (char)40;
        } else if (c == '*') {
            c = (char)38;
        } else if (c == '+') {
            c = (char)95;
        } else if (c == ',') {
            c = (char)109;
        } else if (c == '-') {
            c = (char)48;
        } else if (c == '.') {
            c = (char)44;
        } else if (c == '/') {
            c = (char)46;
        } else if (c == '0') {
            c = (char)57;
        } else if (c == '1') {
            c = (char)96;
        } else if (c == '2') {
            c = (char)49;
        } else if (c == '3') {
            c = (char)50;
        } else if (c == '4') {
            c = (char)51;
        } else if (c == '5') {
            c = (char)52;
        } else if (c == '6') {
            c = (char)53;
        } else if (c == '7') {
            c = (char)54;
        } else if (c == '8') {
            c = (char)55;
        } else if (c == '9') {
            c = (char)56;
        } else if (c == ':') {
            c = (char)76;
        } else if (c == ';') {
            c = (char)108;
        } else if (c == '<') {
            c = (char)77;
        } else if (c == '=') {
            c = (char)45;
        } else if (c == '>') {
            c = (char)60;
        } else if (c == '?') {
            c = (char)62;
        } else if (c == '@') {
            c = (char)33;
        } else if (c == 'A') {
            c = (char)65;
        } else if (c == 'B') {
            c = (char)86;
        } else if (c == 'C') {
            c = (char)88;
        } else if (c == 'D') {
            c = (char)83;
        } else if (c == 'E') {
            c = (char)87;
        } else if (c == 'F') {
            c = (char)68;
        } else if (c == 'G') {
            c = (char)70;
        } else if (c == 'H') {
            c = (char)71;
        } else if (c == 'I') {
            c = (char)85;
        } else if (c == 'J') {
            c = (char)72;
        } else if (c == 'K') {
            c = (char)74;
        } else if (c == 'L') {
            c = (char)75;
        } else if (c == 'M') {
            c = (char)78;
        } else if (c == 'N') {
            c = (char)66;
        } else if (c == 'O') {
            c = (char)73;
        } else if (c == 'P') {
            c = (char)79;
        } else if (c == 'Q') {
            c = (char)81;
        } else if (c == 'R') {
            c = (char)69;
        } else if (c == 'S') {
            c = (char)65;
        } else if (c == 'T') {
            c = (char)82;
        } else if (c == 'U') {
            c = (char)89;
        } else if (c == 'V') {
            c = (char)67;
        } else if (c == 'W') {
            c = (char)81;
        } else if (c == 'X') {
            c = (char)90;
        } else if (c == 'Y') {
            c = (char)84;
        } else if (c == 'Z') {
            c = (char)90;
        } else if (c == '[') {
            c = (char)112;
        } else if (c == '\\') {
            c = (char)61;
        } else if (c == ']') {
            c = (char)91;
        } else if (c == '^') {
            c = (char)37;
        } else if (c == '_') {
            c = (char)41;
        } else if (c == '`') {
            c = (char)96;
        } else if (c == 'a') {
            c = (char)97;
        } else if (c == 'b') {
            c = (char)118;
        } else if (c == 'c') {
            c = (char)120;
        } else if (c == 'd') {
            c = (char)115;
        } else if (c == 'e') {
            c = (char)119;
        } else if (c == 'f') {
            c = (char)100;
        } else if (c == 'g') {
            c = (char)102;
        } else if (c == 'h') {
            c = (char)103;
        } else if (c == 'i') {
            c = (char)117;
        } else if (c == 'j') {
            c = (char)104;
        } else if (c == 'k') {
            c = (char)106;
        } else if (c == 'l') {
            c = (char)107;
        } else if (c == 'm') {
            c = (char)110;
        } else if (c == 'n') {
            c = (char)98;
        } else if (c == 'o') {
            c = (char)105;
        } else if (c == 'p') {
            c = (char)111;
        } else if (c == 'q') {
            c = (char)113;
        } else if (c == 'r') {
            c = (char)101;
        } else if (c == 's') {
            c = (char)97;
        } else if (c == 't') {
            c = (char)114;
        } else if (c == 'u') {
            c = (char)121;
        } else if (c == 'v') {
            c = (char)99;
        } else if (c == 'w') {
            c = (char)113;
        } else if (c == 'x') {
            c = (char)122;
        } else if (c == 'y') {
            c = (char)116;
        } else if (c == 'z') {
            c = (char)122;
        } else if (c == '{') {
            c = (char)80;
        } else if (c == '|') {
            c = (char)43;
        } else if (c == '}') {
            c = (char)123;
        } else if (c == '~') {
            c = (char)126;
        }
        return c;
    }
}

