/*
 * Decompiled with CFR 0.152.
 */
package entities;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.MD5Crypt;
import specialAlgorithm.MyMessageDigest;

public final class AvailableAlgorithms {
    private static String[] ALGORITHMS = new String[]{"unknow", "MD5", "MD4", "unknow", "unknow", "SHA-256", "SHA-512", "unknow", "MD5CRYPT", "SHA-1", "ORACLE-10G", "ORACLE-11G", "NTLM", "LM", "MSSQL-2000", "MSSQL-2005", "MSSQL-2012", "MYSQL-322", "MYSQL-411", "POSTGRESQL", "SYBASE-ASE1502", "INFORMIX-1170"};
    private static char[] ALGORITHMS_CODES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L'};
    private static char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '/', '+', '='};

    public static final String MD5(String s) {
        MessageDigest m = null;
        try {
            m = MessageDigest.getInstance("MD5");
            m.update(s.getBytes(), 0, s.length());
            return DatatypeConverter.printHexBinary((byte[])m.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String MD5Crypt(String password, String salt) {
        MD5Crypt m = new MD5Crypt();
        return m.crypt(password, salt);
    }

    public static final byte[] MD5_byteArray(byte[] s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(s, 0, s.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String SHA1(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA1");
            m.update(s.getBytes(), 0, s.length());
            return DatatypeConverter.printHexBinary((byte[])m.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] SHA1_byteArray(byte[] s) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA1");
            m.update(s, 0, s.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String SHA256(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA-256");
            m.update(s.getBytes(), 0, s.length());
            return DatatypeConverter.printHexBinary((byte[])m.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] SHA256_byteArray(byte[] s) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA-256");
            m.update(s, 0, s.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String SHA512(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA-512");
            m.update(s.getBytes(), 0, s.length());
            return DatatypeConverter.printHexBinary((byte[])m.digest()).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final byte[] SHA512_byteArray(byte[] s) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA-512");
            m.update(s, 0, s.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptCisco7(byte[] hash) {
        byte[] xarr = new byte[]{100, 115, 102, 100, 59, 107, 102, 111, 65, 44, 46, 105, 121, 101, 119, 114, 107, 108, 100, 74, 75, 68, 72, 83, 85, 66};
        System.out.println("hash len: " + hash.length);
        int i = hash[0];
        StringBuilder result = new StringBuilder("");
        int c = 1;
        while (c < hash.length) {
            result.append((char)(hash[c] ^ xarr[i++]));
            i %= 53;
            ++c;
        }
        return result.toString();
    }

    public static int getAlgorithmTypeCode(String algorithm) {
        int hashTypeNumber = 0;
        int i = 0;
        while (i < ALGORITHMS.length) {
            if (algorithm.equalsIgnoreCase(ALGORITHMS[i])) {
                hashTypeNumber = i;
            }
            ++i;
        }
        return hashTypeNumber;
    }

    public static String getAlgorithmName(int algorithmCode) {
        String returnValue = "UNKNOW";
        if (algorithmCode > 0 && algorithmCode < ALGORITHMS.length) {
            returnValue = ALGORITHMS[algorithmCode];
        }
        return returnValue;
    }

    public static String getAlgorithmName(String algorithmCode) {
        String returnValue = "UNKNOW";
        int wordLength = algorithmCode.length();
        if (wordLength == 1) {
            returnValue = String.valueOf(AvailableAlgorithms.getAlgorithmName(Character.getNumericValue(algorithmCode.charAt(0)))) + "()";
        } else if (wordLength > 1) {
            returnValue = "";
            int i = 0;
            while (i < wordLength) {
                returnValue = String.valueOf(returnValue) + AvailableAlgorithms.getAlgorithmName(Character.getNumericValue(algorithmCode.charAt(i))) + "(";
                ++i;
            }
            i = 0;
            while (i < wordLength) {
                returnValue = String.valueOf(returnValue) + ")";
                ++i;
            }
        }
        return returnValue;
    }

    public static boolean isSupportedAlgorithm(String algorithmCode) {
        boolean returnValue = true;
        int wordLength = algorithmCode.length();
        int i = 0;
        while (i < wordLength) {
            int j = Character.getNumericValue(algorithmCode.charAt(i));
            if (!AvailableAlgorithms.isSupportedAlgorithm(j)) {
                returnValue = false;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    public static boolean isNativeAlgorithm(int algorithmCode) {
        boolean returnValue = false;
        if (algorithmCode == 1 || algorithmCode == 5 || algorithmCode == 6 || algorithmCode == 9) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isNativeAlgorithm(String algorithmCodes) {
        boolean returnValue = true;
        int wordLength = algorithmCodes.length();
        int ac = 0;
        int i = 0;
        while (i < wordLength) {
            ac = Character.getNumericValue(algorithmCodes.charAt(i));
            if (!AvailableAlgorithms.isNativeAlgorithm(ac)) {
                returnValue = false;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    public static boolean isSupportedAlgorithm(int algorithmCode) {
        boolean returnValue = false;
        if (!AvailableAlgorithms.getAlgorithmName(algorithmCode).equalsIgnoreCase("UNKNOW")) {
            returnValue = true;
        }
        return returnValue;
    }

    public static boolean isUsernameSaltedHash(int algorithmCode) {
        return MyMessageDigest.isUsernameSaltedHash(AvailableAlgorithms.getAlgorithmName(algorithmCode));
    }

    public static boolean isHashedSpecialAlgorithm(int algorithmCode) {
        return MyMessageDigest.isSaltededSpecialAlgorithm(AvailableAlgorithms.getAlgorithmName(algorithmCode));
    }

    public static String getUTF8String(byte[] b) {
        String aux = "";
        try {
            aux = new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return aux;
    }

    public static String getUpperCaseHash(byte[] b) {
        return DatatypeConverter.printHexBinary((byte[])b);
    }

    public static String getLowerCaseHash(byte[] b) {
        return DatatypeConverter.printHexBinary((byte[])b).toLowerCase();
    }

    public static MyMessageDigest getMyMessageDigest(int algorithmCode) {
        MyMessageDigest m = null;
        String algName = AvailableAlgorithms.getAlgorithmName(algorithmCode);
        if (!AvailableAlgorithms.isNativeAlgorithm(algorithmCode)) {
            m = new MyMessageDigest(algName);
        } else {
            try {
                m = (MyMessageDigest)MessageDigest.getInstance(algName);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    public MessageDigest getMessageDigest(String algorithm) {
        return AvailableAlgorithms.getMessageDigest(AvailableAlgorithms.getAlgorithmTypeCode(algorithm));
    }

    public static MessageDigest getMessageDigest(int algorithmCode) {
        MessageDigest m = null;
        String algName = AvailableAlgorithms.getAlgorithmName(algorithmCode);
        try {
            m = AvailableAlgorithms.isNativeAlgorithm(algorithmCode) ? MessageDigest.getInstance(algName) : new MyMessageDigest(algName);
        }
        catch (NoSuchAlgorithmException e) {
            m = null;
        }
        return m;
    }

    public static MessageDigest[] getMessageDigestArray(String algorithmCodes) {
        int wordLength = algorithmCodes.length();
        MessageDigest[] ma = new MessageDigest[wordLength];
        int ac = 0;
        algorithmCodes = new StringBuilder(algorithmCodes.toUpperCase()).reverse().toString();
        int i = 0;
        while (i < wordLength) {
            ac = Character.getNumericValue(algorithmCodes.charAt(i));
            if (AvailableAlgorithms.isNativeAlgorithm(ac)) {
                ma[i] = AvailableAlgorithms.getMessageDigest(ac);
            }
            ++i;
        }
        return ma;
    }

    public static int getAlgorithmCodeFromInput(String algorithmCodes) {
        int returnValue = 0;
        if (algorithmCodes.length() == 1) {
            algorithmCodes = algorithmCodes.toUpperCase();
            char c = algorithmCodes.charAt(0);
            int i = 0;
            while (i < ALGORITHMS.length) {
                if (c == ALGORITHMS_CODES[i]) {
                    returnValue = i;
                    break;
                }
                ++i;
            }
        } else {
            returnValue = 0;
        }
        return returnValue;
    }

    private static final boolean isHexChar(char c) {
        boolean returnValue = false;
        char cu = Character.toUpperCase(c);
        int i = 0;
        while (i < HEX_CHARS.length) {
            if (cu == HEX_CHARS[i]) {
                returnValue = true;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    public static final boolean isHexHash(String hash) {
        boolean returnValue = true;
        if (hash.length() % 2 == 0) {
            int i = 0;
            while (i < hash.length()) {
                returnValue = AvailableAlgorithms.isHexChar(hash.charAt(i));
                if (returnValue) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    public static final boolean isValidHash(String hash, int algorithmCode) {
        boolean returnValue = false;
        if (hash == null) {
            returnValue = false;
        } else if (hash.length() == 0) {
            returnValue = false;
        } else if (AvailableAlgorithms.isSupportedAlgorithm(algorithmCode)) {
            if (AvailableAlgorithms.isNativeAlgorithm(algorithmCode)) {
                if (algorithmCode == 1) {
                    returnValue = hash.length() == 32 && AvailableAlgorithms.isHexHash(hash);
                } else if (algorithmCode == 5) {
                    returnValue = hash.length() == 64 && AvailableAlgorithms.isHexHash(hash);
                } else if (algorithmCode == 6) {
                    returnValue = hash.length() == 128 && AvailableAlgorithms.isHexHash(hash);
                } else if (algorithmCode == 9) {
                    returnValue = hash.length() == 40 && AvailableAlgorithms.isHexHash(hash);
                }
            } else {
                returnValue = MyMessageDigest.isValidHash(hash, AvailableAlgorithms.getAlgorithmName(algorithmCode));
            }
        }
        return returnValue;
    }

    public static List<String> guessAlgorithms(String hash, boolean luckyMode) {
        ArrayList<String> returnValue = new ArrayList<String>();
        int i = 0;
        while (i < ALGORITHMS.length) {
            if (AvailableAlgorithms.isValidHash(hash, i)) {
                returnValue.add(ALGORITHMS[i]);
            }
            ++i;
        }
        if (returnValue.size() > 1 && luckyMode) {
            ArrayList<String> aux = new ArrayList<String>();
            for (String algName : returnValue) {
                if (algName.equalsIgnoreCase("MD5")) {
                    aux.add(algName);
                    break;
                }
                if (!algName.equalsIgnoreCase("SHA-1")) continue;
                aux.add(algName);
                break;
            }
            if (aux.size() == 0) {
                aux.add((String)returnValue.get(0));
            }
            returnValue = aux;
        }
        return returnValue;
    }

    public static String[] getAvailableAlgorithms() {
        return ALGORITHMS;
    }

    public static String getAlgorithmCodeInput(int algCode) {
        char c = ALGORITHMS_CODES[algCode];
        String returnValue = new String("");
        returnValue = String.valueOf(returnValue) + c;
        return returnValue;
    }

    private static final boolean isBase64Char(char c) {
        boolean returnValue = false;
        int i = 0;
        while (i < BASE64_CHARS.length) {
            if (c == BASE64_CHARS[i]) {
                returnValue = true;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    public static boolean isBase64Hash(String hash) {
        boolean returnValue = true;
        if (hash.length() % 4 == 0) {
            int i = 0;
            while (i < hash.length()) {
                returnValue = AvailableAlgorithms.isBase64Char(hash.charAt(i));
                if (returnValue) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            returnValue = false;
        }
        return returnValue;
    }

    public static boolean isValidStringNumber(String number) {
        boolean returnValue = true;
        int i = 0;
        while (i < number.length()) {
            if (!Character.isDigit(number.charAt(i))) {
                returnValue = false;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    public static byte[] getSaltByteArray(String salt, String saltType) {
        byte[] saltByte = null;
        if (salt != null) {
            if (saltType.equals("int64")) {
                if (AvailableAlgorithms.isValidStringNumber(salt)) {
                    saltByte = new BigInteger(salt).toByteArray();
                }
            } else if (saltType.equals("hex")) {
                if (AvailableAlgorithms.isHexHash(salt)) {
                    saltByte = DatatypeConverter.parseHexBinary((String)salt);
                }
            } else if (saltType.equals("utf8")) {
                saltByte = salt.getBytes();
            }
        }
        return saltByte;
    }
}

