#!/usr/bin/env python3
# File: core/FullList.py

import datetime
import os
import random
import sys

from . import Conn, LinkScan

files = None
tot_iterations = 0
now = datetime.datetime.now()


def _copy_file(src_path: str, dst_path: str) -> None:
    os.makedirs(os.path.dirname(dst_path), exist_ok=True)
    with open(src_path, "rb") as src, open(dst_path, "wb") as dst:
        dst.write(src.read())


def Scan(url, verbose, outdir, wordlist):
    global files, tot_iterations, now

    i = 0  # downloaded
    j = 0  # scanned
    tot_iterations += 1

    if outdir is None:
        rnd = str(random.randint(1, 99999))
        outdir = os.path.abspath("htexploit-" + rnd.zfill(5))
        if verbose > 0:
            print(f"[+] Output not specified, setting '{outdir}'")
    else:
        outdir = os.path.abspath(outdir)

    try:
        files = open(wordlist, "r", encoding="utf-8", errors="ignore")
    except OSError:
        print(f"[-] Unable to open '{wordlist}' wordlist file.")
        print("[-] Exiting\n")
        sys.exit(1)

    fulllist_dir = os.path.join(outdir, "FullList")
    res_dir = os.path.join(outdir, "res")

    # Create output dirs and initialize report
    if not os.path.exists(fulllist_dir):
        if verbose > 0:
            print("[+] Creating Output Dir\n")
        try:
            os.makedirs(fulllist_dir, exist_ok=True)
            os.makedirs(res_dir, exist_ok=True)
        except OSError:
            print("[-] Error creating output directory, do you have permissions?")
            sys.exit("[-] Exiting.\n")

        try:
            # Copy report resources
            _copy_file(os.path.join(os.getcwd(), "res", "reporting", "logo.png"),
                       os.path.join(res_dir, "logo.png"))
            _copy_file(os.path.join(os.getcwd(), "res", "reporting", "style.css"),
                       os.path.join(res_dir, "style.css"))

            # Start report
            rep_path = os.path.join(outdir, "HTExploit-FullList.html")
            with open(rep_path, "w", encoding="utf-8", errors="ignore") as repfile:
                header_path = os.path.join(os.getcwd(), "res", "reporting", "header.html")
                with open(header_path, "r", encoding="utf-8", errors="ignore") as header:
                    repfile.write(header.read())

                repfile.write("<p align='center'><font size=4><b>HTExploit - Full-List Scan Report</b></font></p>")
                repfile.write(f"<h4>Scan date: {now.strftime('%Y-%m-%d %H:%M')}</h4>")
                repfile.write(f"<h4>Scanned URL: <a href='{url}' target='_blank'>{url}</a></h4>")
                repfile.write("<table class='bordered'><thead>")
                repfile.write("<tr><th>ID</th><th>Name</th></tr></thead>")
        except OSError:
            print("[-] Error creating report files, do you have permissions?")

    if verbose > 0:
        print("[+] Full Scan started")

    for line in files:
        entry = line.strip()
        if not entry:
            continue

        out_html = os.path.join(fulllist_dir, entry + ".html")

        # Do not download a file more than once
        if os.path.isfile(out_html):
            if verbose > 1:
                print(f"[-] File '{entry}' has already been downloaded")
            j += 1
            continue

        conn_res = Conn.Connect(2, url + "/" + line)

        if conn_res == 1:
            print("[-] Connection error.")
            print("[-] Check if URL is valid and target is up and listening on the specified port.\n")
            sys.exit(1)

        # Original logic: treat first 3 chars as HTTP code "200"
        conn_str = str(conn_res)
        if not conn_str.startswith("200"):
            if verbose > 1:
                print(f"[-] File '{entry}' couldn't be retrieved")
        else:
            i += 1
            if verbose > 1:
                print(f"[+] File '{entry}' was downloaded")

            body = conn_str[3:]  # remove leading "200"
            try:
                with open(out_html, "w", encoding="utf-8", errors="ignore") as outfile:
                    outfile.write(body)

                with open(os.path.join(fulllist_dir, "rawlist"), "a", encoding="utf-8", errors="ignore") as reptfile:
                    reptfile.write(entry + "\n")

            except OSError:
                # If the filename is not accepted by the OS, generate a fallback name
                try:
                    fallback = os.path.join(outdir, "LinkScan", f"file-{str(i).zfill(8)}.html")
                    os.makedirs(os.path.dirname(fallback), exist_ok=True)
                    with open(fallback, "w", encoding="utf-8", errors="ignore") as outfile:
                        outfile.write(body)

                    with open(os.path.join(fulllist_dir, "rawlist"), "a", encoding="utf-8", errors="ignore") as reptfile:
                        reptfile.write(entry + "\n")
                except OSError:
                    if verbose > 1:
                        print("[x] I/O error on writing output file, do you have permissions?")

        j += 1

    # Append a line break at the end, for the report
    with open(os.path.join(fulllist_dir, "rawlist"), "a", encoding="utf-8", errors="ignore") as reptfile:
        reptfile.write("\n")

    if verbose > 0:
        print()
        print("[+] Full Scan Completed")

    if j > 0 and i != 0:
        if verbose > 0:
            print(f"[+] {i} files were downloaded, out of {j} ({(i * 100) // j}% success rate)")
        LinkScan.Scan(url, verbose, outdir)

    else:
        if verbose > 0:
            print(f"[+] {i} files were downloaded. It seems you've downloaded everything you could from this website")

        print("[+] Creating report...")

        tot_files = 1
        rep_path = os.path.join(outdir, "HTExploit-FullList.html")

        try:
            with open(rep_path, "a", encoding="utf-8", errors="ignore") as repfile:
                raw_path = os.path.join(fulllist_dir, "rawlist")
                with open(raw_path, "r", encoding="utf-8", errors="ignore") as rawfile:
                    for line in rawfile:
                        name = line.strip()
                        if not name:
                            continue
                        repfile.write("<TR><TD>")
                        repfile.write(str(tot_files))
                        repfile.write("</TD><TD>")
                        repfile.write(f"<a href='FullList/{name}.html' target='_blank'>{name}</a><br />")
                        repfile.write("</TD></TR>")
                        tot_files += 1

                footer_path = os.path.join(os.getcwd(), "res", "reporting", "footer.html")
                with open(footer_path, "r", encoding="utf-8", errors="ignore") as footer:
                    repfile.write("\n")
                    repfile.write(footer.read())
        except OSError:
            pass

        print("[+] Scan completed.")
        print("[+]", tot_files - 1, "total files were downloaded, after", tot_iterations, "iteration(s)")
        print("[+] The final report file is in '" + outdir + "'\n")
        print("[x] Keep shopping at the HTExploit store! :)\n")
        sys.exit(0)
