# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""The hashdb module provides interfaces to the hashdb block hash database."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _hashdb
else:
    import _hashdb

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _hashdb.delete_SwigPyIterator

    def value(self):
        return _hashdb.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _hashdb.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _hashdb.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _hashdb.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _hashdb.SwigPyIterator_equal(self, x)

    def copy(self):
        return _hashdb.SwigPyIterator_copy(self)

    def next(self):
        return _hashdb.SwigPyIterator_next(self)

    def __next__(self):
        return _hashdb.SwigPyIterator___next__(self)

    def previous(self):
        return _hashdb.SwigPyIterator_previous(self)

    def advance(self, n):
        return _hashdb.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _hashdb.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _hashdb.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _hashdb.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _hashdb.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _hashdb.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _hashdb.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _hashdb:
_hashdb.SwigPyIterator_swigregister(SwigPyIterator)

def hashdb_version():
    r"""hashdb_version() -> char const *"""
    return _hashdb.hashdb_version()

def version():
    r"""version() -> char const *"""
    return _hashdb.version()
class settings_t(object):
    r"""Proxy of C++ hashdb::settings_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    settings_version = property(_hashdb.settings_t_settings_version_get, _hashdb.settings_t_settings_version_set, doc=r"""settings_version : uint32_t""")
    block_size = property(_hashdb.settings_t_block_size_get, _hashdb.settings_t_block_size_set, doc=r"""block_size : uint32_t""")

    def __init__(self):
        r"""__init__(settings_t self) -> settings_t"""
        _hashdb.settings_t_swiginit(self, _hashdb.new_settings_t())

    def settings_string(self):
        r"""settings_string(settings_t self) -> std::string"""
        return _hashdb.settings_t_settings_string(self)
    __swig_destroy__ = _hashdb.delete_settings_t

# Register settings_t in _hashdb:
_hashdb.settings_t_swigregister(settings_t)
EXPANDED = _hashdb.EXPANDED

EXPANDED_OPTIMIZED = _hashdb.EXPANDED_OPTIMIZED

COUNT = _hashdb.COUNT

APPROXIMATE_COUNT = _hashdb.APPROXIMATE_COUNT


def create_hashdb(hashdb_dir, settings, command_string):
    r"""create_hashdb(std::string const & hashdb_dir, settings_t settings, std::string const & command_string) -> std::string"""
    return _hashdb.create_hashdb(hashdb_dir, settings, command_string)

def read_settings(hashdb_dir, OUTPUT):
    r"""read_settings(std::string const & hashdb_dir, settings_t OUTPUT) -> std::string"""
    return _hashdb.read_settings(hashdb_dir, OUTPUT)

def hex_to_bin(hex_string):
    r"""hex_to_bin(std::string const & hex_string) -> std::string"""
    return _hashdb.hex_to_bin(hex_string)

def bin_to_hex(binary_string):
    r"""bin_to_hex(std::string const & binary_string) -> std::string"""
    return _hashdb.bin_to_hex(binary_string)

def ingest(hashdb_dir, ingest_path, step_size, repository_name, whitelist_dir, disable_recursive_processing, disable_calculate_entropy, disable_calculate_labels, command_string):
    r"""ingest(std::string const & hashdb_dir, std::string const & ingest_path, size_t const step_size, std::string const & repository_name, std::string const & whitelist_dir, bool const disable_recursive_processing, bool const disable_calculate_entropy, bool const disable_calculate_labels, std::string const & command_string) -> std::string"""
    return _hashdb.ingest(hashdb_dir, ingest_path, step_size, repository_name, whitelist_dir, disable_recursive_processing, disable_calculate_entropy, disable_calculate_labels, command_string)

def scan_media(hashdb_dir, media_image_file, step_size, disable_recursive_processing, scan_mode):
    r"""scan_media(std::string const & hashdb_dir, std::string const & media_image_file, size_t const step_size, bool const disable_recursive_processing, hashdb::scan_mode_t const scan_mode) -> std::string"""
    return _hashdb.scan_media(hashdb_dir, media_image_file, step_size, disable_recursive_processing, scan_mode)

def read_media(*args):
    r"""
    read_media(std::string const & media_image_file, std::string const & media_offset, uint64_t const count) -> std::string
    read_media(std::string const & media_image_file, uint64_t const offset, uint64_t const count) -> std::string
    """
    return _hashdb.read_media(*args)

def read_media_size(media_image_file):
    r"""read_media_size(std::string const & media_image_file) -> std::string"""
    return _hashdb.read_media_size(media_image_file)
class import_manager_t(object):
    r"""Proxy of C++ hashdb::import_manager_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, hashdb_dir, command_string):
        r"""__init__(import_manager_t self, std::string const & hashdb_dir, std::string const & command_string) -> import_manager_t"""
        _hashdb.import_manager_t_swiginit(self, _hashdb.new_import_manager_t(hashdb_dir, command_string))
    __swig_destroy__ = _hashdb.delete_import_manager_t

    def insert_source_name(self, file_hash, repository_name, filename):
        r"""insert_source_name(import_manager_t self, std::string const & file_hash, std::string const & repository_name, std::string const & filename)"""
        return _hashdb.import_manager_t_insert_source_name(self, file_hash, repository_name, filename)

    def insert_source_data(self, file_hash, filesize, file_type, zero_count, nonprobative_count):
        r"""insert_source_data(import_manager_t self, std::string const & file_hash, uint64_t const filesize, std::string const & file_type, uint64_t const zero_count, uint64_t const nonprobative_count)"""
        return _hashdb.import_manager_t_insert_source_data(self, file_hash, filesize, file_type, zero_count, nonprobative_count)

    def insert_hash(self, block_hash, k_entropy, block_label, file_hash):
        r"""insert_hash(import_manager_t self, std::string const & block_hash, uint64_t const k_entropy, std::string const & block_label, std::string const & file_hash)"""
        return _hashdb.import_manager_t_insert_hash(self, block_hash, k_entropy, block_label, file_hash)

    def import_json(self, json_string):
        r"""import_json(import_manager_t self, std::string const & json_string) -> std::string"""
        return _hashdb.import_manager_t_import_json(self, json_string)

    def has_source(self, file_hash):
        r"""has_source(import_manager_t self, std::string const & file_hash) -> bool"""
        return _hashdb.import_manager_t_has_source(self, file_hash)

    def first_source(self):
        r"""first_source(import_manager_t self) -> std::string"""
        return _hashdb.import_manager_t_first_source(self)

    def next_source(self, file_hash):
        r"""next_source(import_manager_t self, std::string const & file_hash) -> std::string"""
        return _hashdb.import_manager_t_next_source(self, file_hash)

    def size(self):
        r"""size(import_manager_t self) -> std::string"""
        return _hashdb.import_manager_t_size(self)

    def size_hashes(self):
        r"""size_hashes(import_manager_t self) -> size_t"""
        return _hashdb.import_manager_t_size_hashes(self)

    def size_sources(self):
        r"""size_sources(import_manager_t self) -> size_t"""
        return _hashdb.import_manager_t_size_sources(self)

# Register import_manager_t in _hashdb:
_hashdb.import_manager_t_swigregister(import_manager_t)
class scan_manager_t(object):
    r"""Proxy of C++ hashdb::scan_manager_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, hashdb_dir):
        r"""__init__(scan_manager_t self, std::string const & hashdb_dir) -> scan_manager_t"""
        _hashdb.scan_manager_t_swiginit(self, _hashdb.new_scan_manager_t(hashdb_dir))
    __swig_destroy__ = _hashdb.delete_scan_manager_t

    def export_hash_json(self, block_hash):
        r"""export_hash_json(scan_manager_t self, std::string const & block_hash) -> std::string"""
        return _hashdb.scan_manager_t_export_hash_json(self, block_hash)

    def export_source_json(self, file_hash):
        r"""export_source_json(scan_manager_t self, std::string const & file_hash) -> std::string"""
        return _hashdb.scan_manager_t_export_source_json(self, file_hash)

    def find_hash_count(self, block_hash):
        r"""find_hash_count(scan_manager_t self, std::string const & block_hash) -> size_t"""
        return _hashdb.scan_manager_t_find_hash_count(self, block_hash)

    def find_approximate_hash_count(self, block_hash):
        r"""find_approximate_hash_count(scan_manager_t self, std::string const & block_hash) -> size_t"""
        return _hashdb.scan_manager_t_find_approximate_hash_count(self, block_hash)

    def find_source_data(self, file_hash):
        r"""find_source_data(scan_manager_t self, std::string const & file_hash) -> bool"""
        return _hashdb.scan_manager_t_find_source_data(self, file_hash)

    def find_hash_json(self, scan_mode, block_hash):
        r"""find_hash_json(scan_manager_t self, hashdb::scan_mode_t const scan_mode, std::string const & block_hash) -> std::string"""
        return _hashdb.scan_manager_t_find_hash_json(self, scan_mode, block_hash)

    def first_hash(self):
        r"""first_hash(scan_manager_t self) -> std::string"""
        return _hashdb.scan_manager_t_first_hash(self)

    def next_hash(self, block_hash):
        r"""next_hash(scan_manager_t self, std::string const & block_hash) -> std::string"""
        return _hashdb.scan_manager_t_next_hash(self, block_hash)

    def first_source(self):
        r"""first_source(scan_manager_t self) -> std::string"""
        return _hashdb.scan_manager_t_first_source(self)

    def next_source(self, file_hash):
        r"""next_source(scan_manager_t self, std::string const & file_hash) -> std::string"""
        return _hashdb.scan_manager_t_next_source(self, file_hash)

    def size(self):
        r"""size(scan_manager_t self) -> std::string"""
        return _hashdb.scan_manager_t_size(self)

    def size_hashes(self):
        r"""size_hashes(scan_manager_t self) -> size_t"""
        return _hashdb.scan_manager_t_size_hashes(self)

    def size_sources(self):
        r"""size_sources(scan_manager_t self) -> size_t"""
        return _hashdb.scan_manager_t_size_sources(self)

# Register scan_manager_t in _hashdb:
_hashdb.scan_manager_t_swigregister(scan_manager_t)
class scan_stream_t(object):
    r"""Proxy of C++ hashdb::scan_stream_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, scan_manager, hash_size, scan_mode):
        r"""__init__(scan_stream_t self, scan_manager_t scan_manager, size_t const hash_size, hashdb::scan_mode_t const scan_mode) -> scan_stream_t"""
        _hashdb.scan_stream_t_swiginit(self, _hashdb.new_scan_stream_t(scan_manager, hash_size, scan_mode))
    __swig_destroy__ = _hashdb.delete_scan_stream_t

    def put(self, unscanned_data):
        r"""put(scan_stream_t self, std::string const & unscanned_data)"""
        return _hashdb.scan_stream_t_put(self, unscanned_data)

    def get(self):
        r"""get(scan_stream_t self) -> std::string"""
        return _hashdb.scan_stream_t_get(self)

    def empty(self):
        r"""empty(scan_stream_t self) -> bool"""
        return _hashdb.scan_stream_t_empty(self)

# Register scan_stream_t in _hashdb:
_hashdb.scan_stream_t_swigregister(scan_stream_t)
class timestamp_t(object):
    r"""Proxy of C++ hashdb::timestamp_t class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(timestamp_t self) -> timestamp_t"""
        _hashdb.timestamp_t_swiginit(self, _hashdb.new_timestamp_t())
    __swig_destroy__ = _hashdb.delete_timestamp_t

    def stamp(self, name):
        r"""stamp(timestamp_t self, std::string const & name) -> std::string"""
        return _hashdb.timestamp_t_stamp(self, name)

# Register timestamp_t in _hashdb:
_hashdb.timestamp_t_swigregister(timestamp_t)

