[golismero]
description = Default user profile for GoLismero.

#------------------------------------------------------------------------------
# Audit options
#------------------------------------------------------------------------------

# Audit name. If not given a name is autogenerated.
#audit_name = MyAudit

# Audit database.
# Use ":memory:" for in-memory database, or a filename for a database file.
# Use ":auto:" to create a new database file based on the audit name.
audit_db = :memory:

#------------------------------------------------------------------------------
# Report options
#------------------------------------------------------------------------------

# If true, report only the vulnerabilities. If false, report everything found.
# Use 'default' to let GoLismero decide what's more appropriate.
only_vulns = default

#------------------------------------------------------------------------------
# Network options
#------------------------------------------------------------------------------

# Include subdomains in the target scope.
include_subdomains = yes

# Include parent folders in the target scope.
allow_parent = yes

# Maximum spidering depth. Defaults to 1.
depth = 1

# Maximum number of links to analyze (0 => infinite).
max_links = 0

# Follow redirects.
follow_redirects = yes

# Follow a redirection on the target URL itself, regardless of "follow_redirects".
follow_first_redirect = yes

# Proxy options.
#proxy_addr = localhost
#proxy_user = my_user_name
#proxy_pass = my_secret_password

# Cookie to send with HTTP requests.
#cookie = user=Joe&admin=true

#------------------------------------------------------------------------------
# Plugin options
#------------------------------------------------------------------------------

# Plugin whitelist, comma separated. Use "all" to include all plugins.
enable_plugins = all

# Plugin blacklist, comma separated. Use "all" to disable all plugins.
# For example you could disable plugins that require special configuration,
# like a dedicated server or an API key, if you don't have them.
#disable_plugins = shodan, openvas, spiderfoot

# Plugin settings overrides follow.
# The format is the same as in the main config file.
#
# Example:
# [openvas]
# host = 192.162.56.101
