#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["SuspiciousHTML"]

from .. import Vulnerability
from ... import identity
from ...information.html import HTML


#------------------------------------------------------------------------------
class SuspiciousHTML(Vulnerability):
    """
    Suspicious HTML Content.

    HTML content was found that may contain sensitive information.
    User attention could be required.
    """

    TARGET_CLASS = HTML

    DEFAULTS = Vulnerability.DEFAULTS.copy()
    DEFAULTS["level"]      = "informational"
    DEFAULTS["cvss_base"]  = "2.9"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Information_Leakage",
    )


    #--------------------------------------------------------------------------
    def __init__(self, target, substring, **kwargs):
        """
        :param target: HTML content where the suspicious substring was found.
        :type target: HTML

        :param substring: Substring that causes suspicion.
        :type substring: str
        """

        # Validate the data types.
        if type(substring) is not str:
            raise TypeError("Expected str, got %r instead" % type(substring))

        # Save the properties.
        self.__substring  = substring

        # Parent constructor.
        super(SuspiciousHTML, self).__init__(target, **kwargs)

    __init__.__doc__ += Vulnerability.__init__.__doc__[
            Vulnerability.__init__.__doc__.find("\n        :keyword"):]


    #--------------------------------------------------------------------------
    @identity
    def substring(self):
        """
        :returns: Substring that causes suspicion.
        :rtype: str
        """
        return self.__substring
