#!/usr/bin/python
# -*- coding: utf-8 -*-

__license__ = """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Authors:
  Jekkay Hu | jekkay<@>gmail.com
  Daniel Garcia Garcia a.k.a cr0hn | cr0hn<@>cr0hn.com
  Mario Vilas | mvilas<@>gmail.com

Golismero project site: http://golismero-project.com
Golismero project mail: contact@golismero-project.com


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

from . import HTTPInjection


#------------------------------------------------------------------------------
class XSS(HTTPInjection):
    """
    Cross-Site Scripting.

    Cross-site scripting vulnerabilities, also known as XSS, allow an attacker
    to inject arbitrary HTML content into a web page. Typically an attacker
    would inject JavaScript code in order to control the web application on
    behalf of the user, or redirect the user to a malicious site.

    There are several libraries and methods of filtering user input to prevent
    XSS vulnerabilities. Use whichever is provided for your current programming
    language and platform or, if none is available or feasible, try using
    third party products. As a last resort, try developing your own XSS filter
    using the guidelines provided by OWASP.
    """

    DEFAULTS = HTTPInjection.DEFAULTS.copy()
    DEFAULTS["cwe"]        = ("CWE-79", "CWE-80")
    DEFAULTS["cvss_base"]  = "6.8"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Cross_Site_Scripting_Flaw",
        "https://www.owasp.org/index.php/Cross-site_Scripting_(XSS)",
        "https://www.owasp.org/index.php/"
                        "XSS_(Cross_Site_Scripting)_Prevention_Cheat_Sheet",
        "https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet",
    )
