#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["VulnerableWebApp"]

from .. import WebVulnerability


#------------------------------------------------------------------------------
class VulnerableWebApp(WebVulnerability):
    """
    Vulnerable Web Application.

    A vulnerable version of a web application, framework or CMS was found.

    Apply all missing patches or upgrade to a newer version.
    """

    DEFAULTS = WebVulnerability.DEFAULTS.copy()
    DEFAULTS["level"]      = "high"
    DEFAULTS["cvss_base"]  = "8.5"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/"
                                "Top_10_2013-A5-Security_Misconfiguration",
    )
